/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.net.InetAddress;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.NoSuchApplicationException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.log.ui.internal.util.TraceMergeUIDialog;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizard;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LocalLogParserLoader;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.log.ui.internal.wizards.ParserParameter;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.IHyadesExtendedResource;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;

public class ImportLogWizard
extends Wizard
implements IImportWizard,
IRunnableWithProgress {
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected LogParserItem _parser;
    protected LogNavigator fViewer;
    protected Shell fShell;
    protected String errorMessage = null;
    protected String logParserId;
    protected String reasonAction = null;
    private LogParserItem currentSelectedParser;
    private boolean bAppend = false;
    private final String CANCEL = "cancel";
    private ImportLogWizardPage wizardPage;
    private boolean shouldOpenLogView = false;

    public ImportLogWizard() {
        IDialogSettings workbenchSettings = LogUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("com.ibm.etools.pd.ras.wizard.ImportLogFile");
        if (section == null) {
            section = workbenchSettings.addNewSection("com.ibm.etools.pd.ras.wizard.ImportLogFile");
        }
        this.setDialogSettings(section);
        this.fShell = Workbench.getInstance().getActiveWorkbenchWindow().getShell();
    }

    public LogParserItem getSelectedParser() {
        return this._parser;
    }

    public List getLogFileElements() {
        return this.wizardPage.getLogFileElements();
    }

    public void addPages() {
        super.addPages();
        this.setWindowTitle(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_WIZARD_TITLE"));
        this.wizardPage = new ImportLogWizardPage();
        this.addPage((IWizardPage)this.wizardPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        if (!this.performPageFinish()) {
            return false;
        }
        this.errorMessage = null;
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)this);
        }
        catch (InterruptedException exc) {
            return false;
        }
        catch (Exception e) {
            this.errorMessage = e.getLocalizedMessage();
        }
        if (this.errorMessage != null) {
            if (this.errorMessage.startsWith("cancel")) {
                return false;
            }
            if (this.reasonAction == null) {
                this.fShell = Workbench.getInstance().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)this.fShell, (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.errorMessage);
            } else {
                Status errorStatus = new Status(4, "org.eclipse.core.resources", 566, this.reasonAction, null);
                ErrorDialog.openError((Shell)LogUIPlugin.getActiveWorkbenchShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.errorMessage, (IStatus)errorStatus);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor mon) {
        PerfUtil p = new PerfUtil("LogImportWizard.run 1", true);
        List elements = this.getLogFileElements();
        mon.beginTask(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_PROGRESS_DESC"), elements.size() * 8);
        TRCAgent _agent = null;
        int i = 0;
        while (i < elements.size()) {
            TRCProcessProxy _process;
            Node node;
            int j = 0;
            this.bAppend = true;
            LogFileElement element = (LogFileElement)elements.get(i);
            mon.subTask(element.getParser().getDescription());
            if (element.getMergedAgent() != null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        TraceMergeUIDialog dialog = new TraceMergeUIDialog(ImportLogWizard.this.getShell(), LogUIPlugin.getResourceString("STR_EXISTING_DATA_DESC_2"));
                        int ret = dialog.open();
                        if (ret == 1) {
                            return;
                        }
                        if (ret == 2) {
                            ImportLogWizard.this.bAppend = true;
                        }
                        if (ret == 3) {
                            ImportLogWizard.this.bAppend = false;
                        }
                    }
                });
            }
            String project = element.getProject();
            String monitor = element.getMonitor();
            String host = element.getHost();
            boolean localHost = true;
            try {
                node = NodeFactory.createNode((String)host);
                Node lnode = NodeFactory.createNode((String)"localhost");
                localHost = node.getName().equals(lnode.getName());
            }
            catch (Exception e) {
                this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_HOST_ERROR_");
                this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_HOST_REASON");
                this.reasonAction = HyadesUtil.change((String)this.reasonAction, (String)"%1", (String)host);
                return;
            }
            Display.getDefault().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ImportLogWizard importLogWizard = ImportLogWizard.this;
                    synchronized (importLogWizard) {
                        try {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            boolean shouldSwitch = HyadesUIPlugin.getInstance().openPerspectiveSwitchDialog(window.getShell(), "org.eclipse.hyades.trace.internal.ui.tracePerspective", UIPlugin.getDefault().getPreferenceStore(), "switch_to_perspective", LogUIPlugin.getResourceString("CONFIRM_PERSP_SWITCH_MSG"));
                            if (shouldSwitch) {
                                UIPlugin.getActivePage();
                            }
                            if ("org.eclipse.hyades.trace.internal.ui.tracePerspective".equals(window.getActivePage().getPerspective().getId())) {
                                ImportLogWizard.this.fViewer = (LogNavigator)UIPlugin.getActivePage().showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
                                StructuredViewer viewer = ImportLogWizard.this.fViewer.getViewer();
                                viewer.refresh();
                                ImportLogWizard.this.shouldOpenLogView = true;
                            } else {
                                ImportLogWizard.this.shouldOpenLogView = false;
                            }
                        }
                        catch (Exception e) {
                            HyadesUIPlugin.logError((Throwable)e);
                            return;
                        }
                    }
                }
            });
            _agent = element.getMergedAgent() != null ? element.getMergedAgent().getAgent() : null;
            Hashtable input = this.getUserInput(element, true);
            if (_agent == null) {
                TRCNode trcNode;
                IContainer container = PDCoreUtil.createContainer((IPath)new Path(project));
                TRCMonitor trcMonitor = PDCoreUtil.createMonitor((IContainer)container, (String)monitor);
                IContainer fContainer = container;
                this.refreshView(fContainer);
                mon.worked(++j);
                String portNb = UIPlugin.getDefault().getPreferenceStore().getString("localhost_port");
                TRCNode fNode = trcNode = PDCoreUtil.createNode((TRCMonitor)trcMonitor, (String)node.getName(), (String)portNb);
                TRCMonitor fMonitor = trcMonitor;
                this.refreshView(fMonitor);
                _process = this.createProcess(container, trcNode, element);
                this.refreshView(fNode);
                try {
                    _agent = this.createAgent(_process, element, null);
                }
                catch (Exception e) {
                    this.errorMessage = e.getLocalizedMessage();
                    return;
                }
                if (this.errorMessage != null && this.errorMessage.startsWith("cancel")) {
                    return;
                }
                TRCProcessProxy fProcess = _process;
                this.refreshView(fProcess);
            } else {
                _process = _agent.getAgentProxy().getProcessProxy();
                if (!this.bAppend) {
                    _agent = this.createAgent(_process, element, element.getMergedAgent());
                }
            }
            mon.worked(++j);
            if (mon.isCanceled()) {
                throw new OperationCanceledException();
            }
            TRCAgent trcAgent = _agent;
            TRCProcessProxy trcProcess = _process;
            if (localHost) {
                try {
                    XMLLoader xmlLoader = new XMLLoader(trcAgent);
                    xmlLoader.loadEvent("<CommonBaseEvents>".getBytes(), "<CommonBaseEvents>".getBytes().length);
                    LocalLogParserLoader parserLoader = new LocalLogParserLoader(element.getParser().getParserInstance(), input);
                    parserLoader.setXMLLoader(xmlLoader);
                    parserLoader.startParsing();
                    xmlLoader.loadEvent("</CommonBaseEvents>".getBytes(), "</CommonBaseEvents>".getBytes().length);
                    mon.worked(j += 3);
                    if (mon.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    try {
                        xmlLoader.cleanUp();
                    }
                    catch (Exception exc) {}
                }
                catch (Exception e) {
                    this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                    this.reasonAction = e.getLocalizedMessage();
                    return;
                }
            } else {
                node = PDCoreUtil.profileConnect((String)host, (String)String.valueOf(10002));
                if (node == null) break;
                Process process = ProcessFactory.createProcess((Node)node, (String)"RemoteLogParserLoader", (String)this.getParserCommand(element));
                process.addProcessListener((ProcessListener)new ProcessListenerImpl(trcProcess, trcAgent.getAgentProxy()));
                Agent agent = AgentFactory.createAgent((Process)process, (String)"Remote Log Loader IRemoteEntity", (String)"Logging");
                TRCAgentProxy aproxy = trcAgent.getAgentProxy();
                agent.setAutoAttach(true);
                agent.addAgentListener((AgentListener)new LogAgentListener(trcAgent, aproxy, trcProcess));
                Agent errorAgent = AgentFactory.createAgent((Process)process, (String)"Remote Log Loader Error IRemoteEntity", (String)"Logging");
                errorAgent.setAutoAttach(true);
                errorAgent.addAgentListener((AgentListener)new ErrorAgentListener());
                try {
                    process.launch();
                    mon.worked(j += 3);
                }
                catch (NoSuchApplicationException n) {
                    String parserClass = element.getParser().getId().trim();
                    if (!parserClass.equals("com.ibm.etools.logging.parsers.WASActivityLogParser")) {
                        this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                        this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON_OLD_RAC");
                        return;
                    }
                    Hashtable userInput = this.getUserInput(element, true);
                    String was_home = (String)userInput.get("was_home");
                    String activityPath = (String)userInput.get("file_path");
                    Process preV5Process = ProcessFactory.createProcess((Node)node, (String)"ActivityLogParser", (String)"com.ibm.etools.logging.was.WASActivityLogParser".concat(" \"").concat(activityPath).concat("\" \"").concat(was_home).concat("\""));
                    preV5Process.addProcessListener((ProcessListener)new ProcessListenerImpl(trcProcess, trcAgent.getAgentProxy()));
                    Agent preV5ProcessAgent = AgentFactory.createAgent((Process)preV5Process, (String)"WAS Activity Log Agent", (String)"Logging");
                    preV5ProcessAgent.setAutoAttach(true);
                    preV5ProcessAgent.addAgentListener((AgentListener)new LogAgentListener(trcAgent, aproxy, trcProcess));
                    Agent preV5ErrorAgent = AgentFactory.createAgent((Process)preV5Process, (String)"WAS Activity Log Error Agent", (String)"Logging");
                    preV5ErrorAgent.setAutoAttach(true);
                    preV5ErrorAgent.addAgentListener((AgentListener)new ErrorAgentListener());
                    try {
                        preV5Process.launch();
                    }
                    catch (Exception e) {
                        this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                        this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON_UNKNOWN");
                        LogUIPlugin.log(e);
                        return;
                    }
                }
                catch (Exception e) {
                    this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                    this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON_UNKNOWN");
                    LogUIPlugin.log(e);
                    return;
                }
            }
            ++i;
        }
        mon.done();
        p.stopAndPrintStatus();
        final TRCAgent refreshAgent = _agent;
        ImportLogWizard importLogWizard = this;
        synchronized (importLogWizard) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (ImportLogWizard.this.shouldOpenLogView) {
                        ((TreeViewer)ImportLogWizard.this.fViewer.getViewer()).setExpandedState((Object)ImportLogWizard.this.fViewer.getContentProvider().getLogFolder(), true);
                        ImportLogWizard.this.fViewer.getViewer().setSelection((ISelection)new StructuredSelection((Object)refreshAgent.getAgentProxy()));
                        ImportLogWizard.this.openLogView(refreshAgent);
                    }
                }
            });
        }
    }

    private void refreshView(final Object object) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource(object);
                event.setType(128);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
    }

    protected boolean performPageFinish() {
        return this.wizardPage.finish();
    }

    private String getParserCommand(LogFileElement element) {
        String cmd = element.getParser().getParserClass().concat(" ");
        Hashtable input = this.getUserInput(element, true);
        Locale defaultLocale = Locale.getDefault();
        String localeProperty = defaultLocale.getLanguage().trim();
        if (localeProperty.length() > 0) {
            input.put("client_locale_language", localeProperty);
            localeProperty = defaultLocale.getCountry().trim();
            if (localeProperty.length() > 0) {
                input.put("client_locale_country", localeProperty);
            }
            if ((localeProperty = defaultLocale.getVariant().trim()).length() > 0) {
                input.put("client_locale_variant", localeProperty);
            }
        }
        Enumeration enumeration = input.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            String value = input.get(key).toString();
            cmd = cmd.concat("\"").concat(key.toString()).concat("=");
            cmd = value.endsWith("\\") || value.endsWith("/") ? cmd.concat(value.substring(0, value.length() - 1)).concat("\" ") : cmd.concat(value).concat("\" ");
        }
        return cmd.trim();
    }

    private Hashtable getUserInput(LogFileElement element, boolean parserParam) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        ArrayList fields = element.getParser().getFields();
        int i = fields.size();
        List values = element.getValues();
        i = 0;
        while (i < fields.size()) {
            ParserField field = (ParserField)fields.get(i);
            table.put(field.getId(), values.get(i));
            ++i;
        }
        if (parserParam) {
            ArrayList params = element.getParser().getParserParameters();
            int j = 0;
            while (j < params.size()) {
                ParserParameter param = (ParserParameter)params.get(j);
                table.put(param.getName(), param.getValue());
                ++j;
            }
        }
        return table;
    }

    private TRCAgent createAgent(TRCProcessProxy process, LogFileElement element, TRCAgentProxy mergeAgentProxy) {
        String timestamp;
        TRCAgentProxy agent = null;
        String fPath = (String)this.getUserInput(element, false).get("file_path");
        final String name = element.getParser().getName() + (fPath != null ? " " + fPath : "");
        String type = "Logging";
        if (mergeAgentProxy != null) {
            if (this.bAppend) {
                return mergeAgentProxy.getAgent();
            }
            ((IHyadesExtendedResource)mergeAgentProxy.getAgent().eResource()).delete();
            mergeAgentProxy.setAgent(null);
            mergeAgentProxy.getProcessProxy().eResource().setModified(true);
            mergeAgentProxy.setProcessProxy(null);
        } else {
            EList agents = process.getAgentProxies();
            Object[] agentProxys = agents.toArray();
            int i = 0;
            while (i < agents.size()) {
                agent = (TRCAgentProxy)agentProxys[i];
                if (agent.getName().equals(name)) {
                    this.errorMessage = null;
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            String msg = LogUIPlugin.getResourceString("STR_EXISTING_DATA_DESC_1");
                            msg = TString.change((String)msg, (String)"%1", (String)name);
                            TraceMergeUIDialog dialog = new TraceMergeUIDialog(ImportLogWizard.this.getShell(), msg);
                            int ret = dialog.open();
                            if (ret == 1) {
                                ImportLogWizard.this.errorMessage = "cancel";
                            }
                            if (ret == 2) {
                                ImportLogWizard.this.bAppend = true;
                            }
                            if (ret == 3) {
                                ImportLogWizard.this.bAppend = false;
                            }
                        }
                    });
                    if (this.errorMessage == "cancel") {
                        return null;
                    }
                    if (this.bAppend) {
                        return agent.getAgent();
                    }
                    ((IHyadesExtendedResource)agent.getAgent().eResource()).delete();
                    agent.setAgent(null);
                    agent.getProcessProxy().eResource().setModified(true);
                    agent.setProcessProxy(null);
                }
                ++i;
            }
        }
        Date currentDate = new Date();
        String rID = timestamp = DateFormat.getDateTimeInstance(0, 0).format(currentDate);
        rID = HyadesUtil.change((String)rID, (String)" ", (String)"");
        rID = HyadesUtil.change((String)rID, (String)":", (String)"");
        rID = rID + "-" + currentDate.getTime();
        String agentName = process.getNode().getMonitor().getName() + "_" + process.getNode().getName() + "_" + process.getPid() + "_" + rID + "_" + element.getParser().getDescription();
        agentName = HyadesUtil.change((String)agentName, (String)" ", (String)"");
        String pPath = process.eResource().getURI().toString();
        Path path = new Path(pPath);
        if (path.segmentCount() > 1) {
            pPath = path.removeLastSegments(1).toString();
        }
        String fileName = agentName + this.getAgentNamePostfix(element);
        IPath filePath = new Path(pPath).append(fileName);
        URI uri = URI.createURI((String)filePath.toString());
        Resource agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        agDoc.setModified(true);
        EList agExt = agDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)agDoc);
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        agent = factory.createTRCAgentProxy();
        agent.setName(name);
        agent.setType(type);
        agent.setProcessProxy(process);
        process.getAgentProxies().add((Object)agent);
        TRCAgent ag = factory.createTRCAgent();
        ag.setAgentProxy(agent);
        ag.setType(type);
        agExt.add((Object)ag);
        return ag;
    }

    private String getAgentNamePostfix(LogFileElement element) {
        String res = null;
        Preferences store = HierarchyPlugin.getPlugin().getPluginPreferences();
        if (element.isUseLargeLogSupport() && store.contains("largeResourceSupportCurrentDBType")) {
            String activeDBType = store.getString("largeResourceSupportCurrentDBType");
            Iterator iter = HyadesResourceExtensions.getInstance().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (!(entry.getKey() instanceof String)) continue;
                IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension)entry.getValue();
                String postfix = (String)entry.getKey();
                if (!postfix.endsWith(".trcadb") || !hyadesResourceFactory.getStoreType(postfix).equals(activeDBType)) continue;
                return postfix;
            }
        }
        if (res == null) {
            res = ".trcaxmi";
        }
        return res;
    }

    private TRCProcessProxy createProcess(IContainer container, TRCNode node, LogFileElement element) {
        int pID = 0;
        String logPath = "";
        Hashtable elems = this.getUserInput(element, false);
        Iterator iterator = elems.keySet().iterator();
        if (iterator.hasNext()) {
            logPath = logPath + elems.get(iterator.next()).toString();
        }
        while (iterator.hasNext()) {
            logPath = logPath + " " + elems.get(iterator.next()).toString();
        }
        TRCProcessProxy process = null;
        EList processes = node.getProcessProxies();
        Iterator i = processes.iterator();
        int counter = 0;
        while (i.hasNext()) {
            process = (TRCProcessProxy)i.next();
            ++counter;
            if (process.getName() == null || !process.getName().equals(logPath)) continue;
            process.eResource().setModified(true);
            return process;
        }
        TRCMonitor monitor = node.getMonitor();
        String rID = new Date().toString();
        rID = HyadesUtil.change((String)rID, (String)" ", (String)"");
        rID = HyadesUtil.change((String)rID, (String)":", (String)"");
        String processName = node.getMonitor().getName() + "_" + node.getName() + "_" + counter + "_" + pID;
        String fileName = processName + "." + "trcpxmi";
        IPath path = container.getFullPath().append(fileName);
        URI uri = URI.createURI((String)("platform:/resource" + path.toString()));
        Resource pDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        pDoc.setModified(true);
        EList pExt = pDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)pDoc);
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        process = factory.createTRCProcessProxy();
        process.setPid(pID);
        process.setRuntimeId(String.valueOf(pID));
        process.setName(logPath);
        process.setLaunchMode(0);
        process.setNode(node);
        pExt.add((Object)process);
        TRCProcessProxy fProcess = process;
        this.refreshView(fProcess);
        return process;
    }

    private void initializeValues() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.parsers", "logParser");
        int idx = 0;
        while (idx < config.length) {
            block7: {
                IConfigurationElement elem = config[idx];
                if (this.logParserId.trim().equals(elem.getAttribute("id").trim())) {
                    this._parser = new LogParserItem(elem.getAttribute("id"), elem.getAttribute("name"), elem.getAttribute("ui_name"), elem.getAttribute("description"));
                    this._parser.setConfigurationElement(elem);
                    this._parser.setClass(elem.getAttribute("class"));
                    this._parser.setUIType(elem.getAttribute("ui_type"));
                    String iconPath = elem.getAttribute("icon");
                    if (iconPath != null && iconPath.length() > 0) {
                        URL pluginURL = Platform.getBundle((String)elem.getDeclaringExtension().getNamespace()).getEntry("/");
                        try {
                            URL url = new URL(pluginURL, iconPath);
                            ImageDescriptor image = ImageDescriptor.createFromURL((URL)url);
                            this._parser.setImageDescriptor(image);
                        }
                        catch (Exception exc) {
                            Status status = new Status(4, LogUIPlugin.getPluginId(), 2, "exception.malformedURL", (Throwable)exc);
                            LogUIPlugin.getDefault().getLog().log((IStatus)status);
                            break block7;
                        }
                    }
                    IConfigurationElement[] felems = elem.getChildren("field");
                    int i = 0;
                    while (i < felems.length) {
                        IConfigurationElement felem = felems[i];
                        ParserField pfield = new ParserField(felem.getAttribute("id"), felem.getAttribute("name"));
                        pfield.setConfigurationElement(felem);
                        pfield.setDefaultValue(felem.getAttribute("defaultValue"));
                        pfield.setContextId(felem.getAttribute("helpContextId"));
                        pfield.setTooltip(felem.getAttribute("tooltip"));
                        pfield.setFilters(felem.getAttribute("browseType"));
                        pfield.useBrowse(felem.getAttribute("useBrowse").equals("true"));
                        pfield.setUiType(felem.getAttribute("ui_type"));
                        pfield.setListener(felem.getAttribute("listener"));
                        this._parser.addEntry(pfield);
                        ++i;
                    }
                    IConfigurationElement[] fparameters = elem.getChildren("parserParameter");
                    int i2 = 0;
                    while (i2 < fparameters.length) {
                        IConfigurationElement fparameter = fparameters[i2];
                        ParserParameter para = new ParserParameter(fparameter.getAttribute("name"), fparameter.getAttribute("value"));
                        this._parser.addParameter(para);
                        ++i2;
                    }
                }
            }
            ++idx;
        }
    }

    private void openLogView(TRCAgent agent) {
        IAssociationMappingRegistry registry = TraceAssociationManager.getTraceViewMappingRegistry();
        IAssociationMapping mapping = registry.getAssociationMapping("analyzerExtensions");
        if (mapping == null) {
            return;
        }
        IAssociationDescriptor[] array = mapping.getAssociationDescriptors(agent.getType());
        if (array.length > 0) {
            IAssociationDescriptor desc = array[0];
            try {
                IAction action = (IAction)desc.createImplementationClassInstance();
                if (action != null) {
                    action.run();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        IWorkbenchPage page = UIPlugin.getActivePage();
        try {
            this.fViewer = (LogNavigator)page.showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
            StructuredViewer viewer = this.fViewer.getViewer();
            if (viewer != null) {
                viewer.refresh();
            }
        }
        catch (Exception e) {
            HyadesUIPlugin.logError((Throwable)e);
        }
    }

    class ErrorAgentListener
    implements AgentListener {
        public void agentActive(Agent agent) {
            try {
                agent.startMonitoring(new DataProcessor(this){
                    private final /* synthetic */ ErrorAgentListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void incommingData(byte[] buffer, int length, InetAddress peer) {
                        String agentErrorMessage = new String(buffer, 0, length);
                        Display.getDefault().asyncExec(new Runnable(this, agentErrorMessage){
                            private final /* synthetic */ String val$agentErrorMessage;
                            private final /* synthetic */ 13 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$agentErrorMessage = val$agentErrorMessage;
                            }

                            public void run() {
                                ErrorAgentListener.access$700((ErrorAgentListener)13.access$600(this.this$2)).fShell = Workbench.getInstance().getActiveWorkbenchWindow().getShell();
                                MessageDialog.openError((Shell)ErrorAgentListener.access$700((ErrorAgentListener)13.access$600(this.this$2)).fShell, (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$agentErrorMessage);
                            }
                        });
                    }

                    public void incommingData(char[] buffer, int length, InetAddress peer) {
                    }

                    public void invalidDataType(byte[] data, int length, InetAddress peer) {
                    }

                    public void waitingForData() {
                    }

                    static /* synthetic */ ErrorAgentListener access$600(13 x0) {
                        return x0.this$1;
                    }
                });
            }
            catch (Exception e) {
                String agentErrorMessage = e.toString();
                Display.getDefault().asyncExec(new Runnable(this, agentErrorMessage){
                    private final /* synthetic */ String val$agentErrorMessage;
                    private final /* synthetic */ ErrorAgentListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$agentErrorMessage = val$agentErrorMessage;
                    }

                    public void run() {
                        ErrorAgentListener.access$700((ErrorAgentListener)this.this$1).fShell = Workbench.getInstance().getActiveWorkbenchWindow().getShell();
                        MessageDialog.openError((Shell)ErrorAgentListener.access$700((ErrorAgentListener)this.this$1).fShell, (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$agentErrorMessage);
                    }
                });
            }
        }

        public void agentInactive(Agent agent) {
        }

        public void error(Agent agent, String errorId, String message) {
            String errMsg = errorId.concat(": ").concat(message);
            Display.getDefault().asyncExec(new Runnable(this, errMsg){
                private final /* synthetic */ String val$errMsg;
                private final /* synthetic */ ErrorAgentListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$errMsg = val$errMsg;
                }

                public void run() {
                    ErrorAgentListener.access$700((ErrorAgentListener)this.this$1).fShell = Workbench.getInstance().getActiveWorkbenchWindow().getShell();
                    MessageDialog.openError((Shell)ErrorAgentListener.access$700((ErrorAgentListener)this.this$1).fShell, (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$errMsg);
                }
            });
        }

        public void handleCommand(Agent agent, CommandElement command) {
        }

        static /* synthetic */ ImportLogWizard access$700(ErrorAgentListener x0) {
            return x0.ImportLogWizard.this;
        }
    }

    class LogAgentListener
    implements AgentListener {
        private TRCAgentProxy aproxy;
        private TRCAgent trcAgent;
        private TRCProcessProxy trcProcess;

        public LogAgentListener(TRCAgent trcAgent, TRCAgentProxy aproxy, TRCProcessProxy trcProcess) {
            this.aproxy = aproxy;
            this.trcAgent = trcAgent;
            this.trcProcess = trcProcess;
        }

        public void agentActive(Agent agent) {
            this.aproxy.setActive(true);
            this.aproxy.setAttached(true);
            this.aproxy.setMonitored(true);
            LoadersUtils.registerAgentInstance((TRCAgentProxy)this.aproxy, (Object)agent);
            Display.getDefault().asyncExec(new Runnable(this){
                private final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                    event.setSource((Object)LogAgentListener.access$400(this.this$1));
                    event.setType(1);
                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            });
            try {
                XMLTraceDataProcessor dataProcessor = new XMLTraceDataProcessor(this, this.trcAgent.getAgentProxy()){
                    private final /* synthetic */ LogAgentListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void dataServerExited() {
                        super.dataServerExited();
                        LoadersUtils.deregisterAgentInstance((TRCAgentProxy)LogAgentListener.access$400(this.this$1));
                        Display.getDefault().asyncExec(new Runnable(this){
                            private final /* synthetic */ 8 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void run() {
                                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                                event.setSource((Object)LogAgentListener.access$400(8.access$500(this.this$2)));
                                event.setType(32);
                                UIPlugin.getDefault().notifyProfileEventListener(event);
                            }
                        });
                    }

                    static /* synthetic */ LogAgentListener access$500(8 x0) {
                        return x0.this$1;
                    }
                };
                agent.startMonitoring((DataProcessor)dataProcessor);
            }
            catch (Exception e) {
                String agentErrorMessage = e.toString();
                Display.getDefault().asyncExec(new Runnable(this, agentErrorMessage){
                    private final /* synthetic */ String val$agentErrorMessage;
                    private final /* synthetic */ LogAgentListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$agentErrorMessage = val$agentErrorMessage;
                    }

                    public void run() {
                        MessageDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$agentErrorMessage);
                    }
                });
            }
        }

        public void agentInactive(Agent agent) {
            this.aproxy.setActive(false);
            this.aproxy.setAttached(false);
            this.aproxy.setMonitored(false);
            this.trcProcess.setActive(false);
            Display.getDefault().asyncExec(new Runnable(this){
                private final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                    event.setSource((Object)LogAgentListener.access$400(this.this$1));
                    event.setType(16);
                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            });
        }

        public void error(Agent agent, String errorId, String message) {
            String errMsg = errorId.concat(": ").concat(message);
            Display.getDefault().asyncExec(new Runnable(this, errMsg){
                private final /* synthetic */ String val$errMsg;
                private final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$errMsg = val$errMsg;
                }

                public void run() {
                    MessageDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)this.val$errMsg);
                }
            });
        }

        public void handleCommand(Agent agent, CommandElement command) {
        }

        static /* synthetic */ TRCAgentProxy access$400(LogAgentListener x0) {
            return x0.aproxy;
        }
    }

    class ProcessListenerImpl
    implements ProcessListener {
        TRCAgentProxy trcAgent;
        TRCProcessProxy trcProcess;

        public ProcessListenerImpl(TRCProcessProxy process, TRCAgentProxy agent) {
            this.trcProcess = process;
            this.trcAgent = agent;
        }

        public void processExited(Process process) {
            this.trcAgent.setActive(false);
            this.trcAgent.setAttached(false);
            this.trcAgent.setMonitored(false);
            Display.getDefault().asyncExec(new Runnable(this){
                private final /* synthetic */ ProcessListenerImpl this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (ImportLogWizard.access$100(ProcessListenerImpl.access$300(this.this$1))) {
                        ProcessListenerImpl.access$300((ProcessListenerImpl)this.this$1).fViewer.getViewer().refresh((Object)this.this$1.trcAgent);
                    }
                }
            });
        }

        public void processLaunched(Process process) {
            try {
                if (this.trcProcess != null) {
                    this.trcProcess.setPid(Integer.parseInt(process.getProcessId()));
                    this.trcProcess.setRuntimeId(process.getUUID());
                    this.trcProcess.setActive(true);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }

        static /* synthetic */ ImportLogWizard access$300(ProcessListenerImpl x0) {
            return x0.ImportLogWizard.this;
        }
    }
}

