/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.Map;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LogSetUI;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogSetDialog
extends Dialog {
    private LogSetUI logSetUI;
    private int type;
    private ImportLogWizardPage page;
    private Map logSets;
    private String defaultLogSet;
    private boolean logSetSelChanged = false;
    private boolean currentLogSetChanged = false;
    private String logSetName;

    public LogSetDialog(Shell parentShell, int type) {
        super(parentShell);
        this.type = type;
    }

    public LogSetDialog(Shell parentShell, int type, ImportLogWizardPage page) {
        super(parentShell);
        this.type = type;
        this.page = page;
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridData data = GridUtil.createFill();
        result.setLayoutData((Object)data);
        result.setLayout((Layout)new GridLayout());
        this.logSetUI = new LogSetUI(this);
        this.setTitle();
        this.logSetUI.createContent(result, this.type);
        switch (this.type) {
            case 0: {
                WorkbenchHelp.setHelp((Control)result, (String)(LogUIPlugin.getPluginId() + ".ls0000"));
                break;
            }
            case 1: {
                WorkbenchHelp.setHelp((Control)result, (String)(LogUIPlugin.getPluginId() + ".ls0010"));
                break;
            }
            case 2: {
                WorkbenchHelp.setHelp((Control)result, (String)(LogUIPlugin.getPluginId() + ".ls0020"));
            }
        }
        return result;
    }

    private void setTitle() {
        switch (this.type) {
            case 0: {
                this.getShell().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_NEW_TITLE"));
                break;
            }
            case 1: {
                this.getShell().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_OPEN_TITLE"));
                break;
            }
            case 2: {
                this.getShell().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_EDIT_TITLE"));
                break;
            }
            case 3: {
                this.getShell().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_REN_TITLE"));
            }
        }
    }

    public void setOKButtonEnabled(boolean enabled) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    public Map getLogSets() {
        return this.logSets;
    }

    public void setLogSets(Map newSet) {
        this.logSets = newSet;
    }

    public String getDefaultLogSet() {
        return this.defaultLogSet;
    }

    public void setDefaultLogSet(String newDefault) {
        this.defaultLogSet = newDefault;
    }

    public void setLogSetSelectionChanged(boolean value) {
        this.logSetSelChanged = value;
    }

    public boolean hasLogSetSelectionChanged() {
        return this.logSetSelChanged;
    }

    public boolean hasCurrentLogSetChanged() {
        return this.currentLogSetChanged;
    }

    public void setCurrentLogSetChanged(boolean newVal) {
        this.currentLogSetChanged = newVal;
    }

    public String getCurrentLogSet() {
        return this.page.getLogSetManager().getDefaultLogSet();
    }

    public String getLogSetName() {
        return this.logSetName;
    }

    public void setLogSetName(String newText) {
        this.logSetName = newText;
    }
}

