/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationType;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ComponentConfigSection
extends Composite
implements IDetails,
ModifyListener,
INotifyChangedListener {
    protected Text descriptionText;
    protected Label uniqueId;
    protected boolean isDisplaying;
    protected ConfigurationType currentSelection;
    protected ConfigurationTypeItemProvider itemProvider;
    protected ConfigurationItemProviderAdapterFactory itemFactory = new ConfigurationItemProviderAdapterFactory();

    public ComponentConfigSection(RuleBuilderWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 5;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONFIG_DESCR"), 0);
        this.descriptionText = factory.createText(this, "", 2);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_CONFIG_ID"), 0);
        this.uniqueId = factory.createLabel(this, "");
        this.uniqueId.setLayoutData((Object)new GridData(768));
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.itemProvider = (ConfigurationTypeItemProvider)this.itemFactory.createConfigurationTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject object) {
        if (this.currentSelection == object) {
            return;
        }
        if (this.descriptionText.isFocusControl() || this.uniqueId.isFocusControl()) {
            return;
        }
        this.currentSelection = (ConfigurationType)object;
        this.isDisplaying = true;
        this.descriptionText.setText(this.currentSelection.getDescription() == null ? "" : this.currentSelection.getDescription());
        this.uniqueId.setText(this.currentSelection.getUniqueID() == null ? "" : this.currentSelection.getUniqueID());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        this.currentSelection = (ConfigurationType)currentSelection;
        this.currentSelection.setDescription(this.descriptionText.getText());
        this.currentSelection.setUniqueID(this.uniqueId.getText());
        return false;
    }

    public void setFocusToText() {
        this.descriptionText.setFocus();
        this.descriptionText.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.descriptionText && !(text = this.descriptionText.getText()).equals(this.currentSelection.getDescription())) {
            if (text.length() == 0 && this.currentSelection.getDescription() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, AcadEditorPlugin.getPlugin().getString("STR_CONFIG_DESCR"));
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object obj = notification.getNotifier();
        if (obj == null || obj != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }
}

