/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.commons;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.internal.logging.core.XmlGenerator;
import org.eclipse.hyades.logging.core.IExternalizableToXml;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;

public class FileLogger
implements Log {
    public static final int TRACE_LEVEL = 0;
    public static final int DEBUG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int WARN_LEVEL = 3;
    public static final int ERROR_LEVEL = 4;
    public static final int FATAL_LEVEL = 5;
    private static final String[] LEVEL_NAMES = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private int level = 3;
    private String name = null;
    private XmlGenerator xmlGenerator = null;
    private BufferedWriter fileWriter = null;
    private String fileName = null;
    private CommonBaseEvent startEvent = null;
    private CommonBaseEvent stopEvent = null;
    private static String localHostIP = null;

    public FileLogger(String name) {
        this.name = name;
        this.xmlGenerator = new XmlGenerator(name);
        this.createStartStopEvents();
        this.configure();
    }

    public boolean isTraceEnabled() {
        return this.level <= 0;
    }

    public boolean isDebugEnabled() {
        return this.level <= 1;
    }

    public boolean isInfoEnabled() {
        return this.level <= 2;
    }

    public boolean isWarnEnabled() {
        return this.level <= 3;
    }

    public boolean isErrorEnabled() {
        return this.level <= 4;
    }

    public boolean isFatalEnabled() {
        return this.level <= 5;
    }

    public void trace(Object record) {
        if (this.isTraceEnabled()) {
            this.write(this.convertToXML(record));
        }
    }

    public void trace(Object record, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.write(this.convertToXML(record));
            this.write(this.convertToXML(throwable));
        }
    }

    public void debug(Object record) {
        if (this.isDebugEnabled()) {
            this.write(this.convertToXML(record));
        }
    }

    public void debug(Object record, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.write(this.convertToXML(record));
            this.write(this.convertToXML(throwable));
        }
    }

    public void info(Object record) {
        if (this.isInfoEnabled()) {
            this.write(this.convertToXML(record));
        }
    }

    public void info(Object record, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.write(this.convertToXML(record));
            this.write(this.convertToXML(throwable));
        }
    }

    public void warn(Object record) {
        if (this.isWarnEnabled()) {
            this.write(this.convertToXML(record));
        }
    }

    public void warn(Object record, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.write(this.convertToXML(record));
            this.write(this.convertToXML(throwable));
        }
    }

    public void error(Object record) {
        if (this.isErrorEnabled()) {
            this.write(this.convertToXML(record));
        }
    }

    public void error(Object record, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.write(this.convertToXML(record));
            this.write(this.convertToXML(throwable));
        }
    }

    public void fatal(Object record) {
        if (this.isFatalEnabled()) {
            this.write(this.convertToXML(record));
        }
    }

    public void fatal(Object record, Throwable throwable) {
        if (this.isFatalEnabled()) {
            this.write(this.convertToXML(record));
            this.write(this.convertToXML(throwable));
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setFileName(String fileName) throws IllegalArgumentException {
        this.fileName = fileName;
        try {
            this.openLogFile();
        }
        catch (IOException i) {
            this.fileName = null;
            throw new IllegalArgumentException("Invalid log file path");
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public final void finalize() {
        this.closeLogFile();
    }

    public boolean isLogging() {
        return this.fileWriter != null;
    }

    private void closeLogFile() {
        if (this.isLogging()) {
            this.writeStopEvent();
            try {
                this.fileWriter.close();
            }
            catch (IOException i) {
                // empty catch block
            }
        }
        this.fileWriter = null;
    }

    private void openLogFile() throws IOException {
        this.fileWriter = new BufferedWriter(new FileWriter(this.fileName, true));
        this.writeStartEvent();
    }

    public int getLevel() {
        return this.level;
    }

    public String getLevelAsString() {
        return LEVEL_NAMES[this.level];
    }

    public synchronized void setLevel(int level) throws IllegalArgumentException {
        if (!this.isValidLevel(level)) {
            throw new IllegalArgumentException("Invalid logging level");
        }
        this.level = level;
    }

    public synchronized void setLevelAsString(String stringLevel) throws IllegalArgumentException {
        this.setLevel(this.getLevelInteger(stringLevel));
    }

    private int getLevelInteger(String levelName) {
        block5: {
            if (levelName == null || levelName.trim().length() == 0) break block5;
            String tempLevel = levelName.trim();
            int counter = 0;
            while (counter < LEVEL_NAMES.length) {
                if (tempLevel.equalsIgnoreCase(LEVEL_NAMES[counter])) {
                    return counter;
                }
                ++counter;
            }
            try {
                int levelNum = Integer.parseInt(tempLevel);
                if (this.isValidLevel(levelNum)) {
                    return levelNum;
                }
            }
            catch (NumberFormatException n) {}
        }
        return -1;
    }

    private boolean isValidLevel(int checkLevel) {
        return checkLevel >= 0 || checkLevel <= 5;
    }

    private boolean isValidLevelString(String checkLevel) {
        return this.isValidLevel(this.getLevelInteger(checkLevel));
    }

    private String convertToXML(Object object) {
        if (object instanceof IExternalizableToXml) {
            return ((IExternalizableToXml)object).externalizeCanonicalXmlString();
        }
        this.xmlGenerator.reset(LEVEL_NAMES[this.level], false, 4);
        return this.xmlGenerator.objectToXML(object);
    }

    private void write(String message) {
        block2: {
            if (!this.isLogging()) break block2;
            try {
                this.fileWriter.write(message);
                this.fileWriter.flush();
                this.fileWriter.write(LINE_SEPARATOR);
                this.fileWriter.flush();
            }
            catch (IOException i) {}
        }
    }

    private void configure() {
        String systemProperty = System.getProperty("org.eclipse.hyades.logging.commons.FileLogger.FileName");
        if (systemProperty != null && systemProperty.trim().length() > 0) {
            this.setFileName(systemProperty);
        }
        if ((systemProperty = System.getProperty("org.eclipse.hyades.logging.commons.FileLogger.Level")) != null && systemProperty.trim().length() > 0 && this.isValidLevelString(systemProperty)) {
            this.setLevelAsString(systemProperty);
        }
    }

    private void createStartStopEvents() {
        EventFactory eventFactory = EventFactoryContext.getInstance().getSimpleEventFactoryHome().getAnonymousEventFactory();
        this.startEvent = eventFactory.createCommonBaseEvent();
        ComponentIdentification startSourceComponentId = eventFactory.createComponentIdentification();
        startSourceComponentId.setLocation(localHostIP);
        startSourceComponentId.setLocationType("IPV4");
        startSourceComponentId.setComponent("org.eclipse.hyades.logging.commons");
        startSourceComponentId.setSubComponent("FileLogger");
        startSourceComponentId.setComponentIdType("Application");
        startSourceComponentId.setComponentType("ApacheCommonsLog");
        this.startEvent.setSourceComponentId(startSourceComponentId);
        StartSituation startSituation = eventFactory.createStartSituation();
        startSituation.setReasoningScope("INTERNAL");
        startSituation.setSituationQualifier("START COMPLETED");
        startSituation.setSuccessDisposition("SUCCESSFUL");
        Situation startEventSituation = eventFactory.createSituation();
        startEventSituation.setCategoryName("StartSituation");
        startEventSituation.setSituationType((SituationType)startSituation);
        this.startEvent.setSituation(startEventSituation);
        this.stopEvent = eventFactory.createCommonBaseEvent();
        ComponentIdentification stopSourceComponentId = eventFactory.createComponentIdentification();
        stopSourceComponentId.setLocation(localHostIP);
        stopSourceComponentId.setLocationType("IPV4");
        stopSourceComponentId.setComponent("org.eclipse.hyades.logging.commons");
        stopSourceComponentId.setSubComponent("FileLogger");
        stopSourceComponentId.setComponentIdType("Application");
        stopSourceComponentId.setComponentType("ApacheCommonsLog");
        this.stopEvent.setSourceComponentId(stopSourceComponentId);
        StartSituation stopSituation = eventFactory.createStartSituation();
        stopSituation.setReasoningScope("INTERNAL");
        stopSituation.setSituationQualifier("STOP COMPLETED");
        stopSituation.setSuccessDisposition("SUCCESSFUL");
        Situation stopEventSituation = eventFactory.createSituation();
        stopEventSituation.setCategoryName("StopSituation");
        stopEventSituation.setSituationType((SituationType)stopSituation);
        this.stopEvent.setSituation(stopEventSituation);
    }

    private void writeStartEvent() {
        this.startEvent.setCreationTimeAsLong(System.currentTimeMillis());
        this.write(this.convertToXML(this.startEvent));
    }

    private void writeStopEvent() {
        this.stopEvent.setCreationTimeAsLong(System.currentTimeMillis());
        this.write(this.convertToXML(this.stopEvent));
    }

    static {
        try {
            localHostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException u) {
            localHostIP = "127.0.0.1";
        }
    }
}

