/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.analysis;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.analysis.engine.IAnalysisMonitor;
import org.eclipse.hyades.analysis.engine.ILogAnalyzer;
import org.eclipse.hyades.analysis.engine.Incident;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.sdb.analysis.AnalysisEngine;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.preferences.SymptomDBDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.Workbench;

public class LogAnalyzerImpl
implements ILogAnalyzer {
    protected String errorMessage;
    protected Map _analysisEngine = new Hashtable();
    private final String PLATFORM_PREFIX = "platform:/resource";
    private Incident incident = new Incident();

    public String errorMsg() {
        return this.errorMessage;
    }

    private int loadDatabases() {
        Map list = this.getSymptomDBPathList();
        Set keySet = this._analysisEngine.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            AnalysisEngine element = (AnalysisEngine)iter.next();
            if (!this.databaseExists(element.getSymptomDatabasePath())) {
                element.removeSymptomDatabase();
                iter.remove();
                continue;
            }
            String path = element.getSymptomDatabasePath();
            Long value = (Long)list.get(path);
            if (value == null) {
                element.removeSymptomDatabase();
                iter.remove();
                continue;
            }
            if (value != null && value.longValue() != ((Long)this._analysisEngine.get(element)).longValue()) {
                element.removeSymptomDatabase();
                iter.remove();
                continue;
            }
            list.remove(path);
        }
        Set listSet = list.keySet();
        Iterator iter2 = listSet.iterator();
        while (iter2.hasNext()) {
            String path = (String)iter2.next();
            this._analysisEngine.put(AnalysisEngine.getInstance(path), list.get(path));
        }
        return this._analysisEngine.size();
    }

    public void loadDatabase() {
        this.errorMessage = null;
        int engineSize = this.loadDatabases();
        if (engineSize == 0) {
            this.errorMessage = SDbPlugin.getResourceString("STR_NO_SYMPTOM_DB_ERROR");
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (MessageDialog.openQuestion((Shell)Workbench.getInstance().getActiveWorkbenchWindow().getShell(), (String)LogUIPlugin.getResourceString((String)"STR_LOG_MSG"), (String)LogUIPlugin.getResourceString((String)"STR_NO_SYMPTOM_DB_ERROR"))) {
                        SymptomDBDialog dialog = new SymptomDBDialog(Workbench.getInstance().getActiveWorkbenchWindow().getShell(), LogUIPlugin.getResourceString((String)"STR_SYMPTOM_DB_DLG_TITLE"), null);
                        dialog.open();
                        if (dialog.getReturnCode() == 0 && LogAnalyzerImpl.this.loadDatabases() > 0) {
                            LogAnalyzerImpl.this.errorMessage = null;
                        }
                    }
                }
            });
        }
    }

    public void unloadDatabase() {
        Set analysisSet = this._analysisEngine.keySet();
        Iterator iter = analysisSet.iterator();
        while (iter.hasNext()) {
            AnalysisEngine engine = (AnalysisEngine)iter.next();
            engine.removeSymptomDatabase();
        }
        this._analysisEngine.clear();
    }

    protected Map getSymptomDBPathList() {
        HashMap<String, Long> list = new HashMap<String, Long>();
        String symptomdbPath = SDbPlugin.getDefault().getPreferenceStore().getString("symptom_db_path");
        if (symptomdbPath == null || symptomdbPath.equals("")) {
            return list;
        }
        int idx = symptomdbPath.indexOf(";");
        while (idx != -1) {
            String data = symptomdbPath.substring(0, idx);
            int i = data.indexOf(",");
            if (i != -1 && data.substring(i + 1).equals("1")) {
                String path = data.substring(0, i);
                IWorkspace workbench = ResourcesPlugin.getWorkspace();
                Path filePath = new Path(path);
                IResource fres = workbench.getRoot().findMember((IPath)filePath);
                if (fres != null && fres.exists()) {
                    list.put("platform:/resource" + path, new Long(this.getTimestamp(fres)));
                }
            }
            symptomdbPath = symptomdbPath.substring(idx + 1);
            idx = symptomdbPath.indexOf(";");
        }
        int i = symptomdbPath.indexOf(",");
        if (i != -1 && symptomdbPath.substring(i + 1).equals("1")) {
            String path = symptomdbPath.substring(0, i);
            IWorkspace workbench = ResourcesPlugin.getWorkspace();
            Path filePath = new Path(path);
            IResource fres = workbench.getRoot().findMember((IPath)filePath);
            if (fres != null && fres.exists()) {
                list.put("platform:/resource" + path, new Long(this.getTimestamp(fres)));
            }
        }
        return list;
    }

    protected boolean databaseExists(String path) {
        if (path == null) {
            return false;
        }
        path = this.resourcePath(URI.createURI((String)path));
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        IResource res = workbench.getRoot().findMember(path);
        return res != null && res.exists();
    }

    protected String resourcePath(URI uri) {
        String path = uri.path();
        if (path.startsWith("/resource")) {
            return path.substring(9);
        }
        if (path.startsWith("platform:/resource")) {
            return path.substring(18);
        }
        return path;
    }

    public String analyze(Object selection, IAnalysisMonitor monitor) {
        Iterator i = ((List)selection).iterator();
        String[] record = new String[]{"0", String.valueOf(((List)selection).size())};
        int count = 0;
        while (i.hasNext()) {
            Object elem = i.next();
            if (elem instanceof CBECommonBaseEvent) {
                this.analyzeEvent((CBECommonBaseEvent)elem);
            }
            if (monitor == null) continue;
            record[0] = String.valueOf(++count);
            monitor.worked(1);
            monitor.subTask(LogUIPlugin.getResourceString((String)"STR_ANALYZE_RECORD", (String[])record));
            if (!monitor.isCanceled()) continue;
            return "";
        }
        return "";
    }

    protected String analyzeEvent(CBECommonBaseEvent logRecord) {
        String symptomString = this.getSymptomStringFor(logRecord);
        return this.findMatchesFor(logRecord, symptomString);
    }

    protected String getSymptomStringFor(CBECommonBaseEvent logRecord) {
        String symptomString = logRecord.getExtensionName();
        symptomString = logRecord.getMsg();
        return symptomString;
    }

    private String findMatchesFor(CBECommonBaseEvent logRecord, String symptomString) {
        EList directivesList = logRecord.getSymptoms();
        if (!directivesList.isEmpty()) {
            directivesList.clear();
        }
        Set keySet = this._analysisEngine.keySet();
        this.incident.setMessageId(symptomString);
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            AnalysisEngine engine = (AnalysisEngine)iter.next();
            Object[] directives = engine.analyze(this.incident);
            int idx = 0;
            while (idx < directives.length) {
                logRecord.getSymptoms().add(directives[idx]);
                ++idx;
            }
        }
        logRecord.setAnalyzed(true);
        return symptomString;
    }

    private long getTimestamp(IResource resource) {
        long currentTimestamp = 0L;
        IPath path = resource.getLocation();
        if (path != null) {
            currentTimestamp = path.toFile().lastModified();
        }
        return currentTimestamp;
    }
}

