/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.analysis;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.analysis.engine.ISymptomDatabase;
import org.eclipse.hyades.analysis.engine.Incident;
import org.eclipse.hyades.analysis.engine.Solution;
import org.eclipse.hyades.models.internal.sdb.SDBFactory;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;

final class XMISymptomDatabase
implements ISymptomDatabase {
    private SDBRuntime fDatabase = null;
    private String symptomDBPath = null;

    XMISymptomDatabase() {
    }

    public String getPath() {
        return this.symptomDBPath;
    }

    public synchronized boolean load() {
        this.unload();
        this.fDatabase = this.loadDatabase(this.symptomDBPath);
        return this.fDatabase != null;
    }

    public synchronized boolean unload() {
        SDBResourceSetImpl resourceSet = SDBResourceSetImpl.getInstance();
        if (this.fDatabase != null && resourceSet != null) {
            resourceSet.getResources().remove((Object)this.fDatabase.eResource());
        }
        this.fDatabase = null;
        return true;
    }

    public synchronized boolean merge(String symptomDbPath) {
        SDBRuntime newDatabase = this.loadDatabase(symptomDbPath);
        if (newDatabase == null) {
            return false;
        }
        if (this.fDatabase == null) {
            this.fDatabase = newDatabase;
        } else {
            EList symptoms = newDatabase.getSymptoms();
            int idx = 0;
            while (idx < symptoms.size()) {
                SDBSymptom symptom = (SDBSymptom)symptoms.get(idx);
                boolean found = false;
                EList fSymptoms = this.fDatabase.getSymptoms();
                int i = 0;
                while (i < fSymptoms.size()) {
                    SDBSymptom fSymptom = (SDBSymptom)fSymptoms.get(i);
                    if (symptom.getDescription().equals(fSymptom.getDescription())) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    SDBSymptom _symptom = SDBFactory.eINSTANCE.createSDBSymptom();
                    _symptom.setDescription(symptom.getDescription());
                    this.fDatabase.getSymptoms().add((Object)_symptom);
                    EList patterns = symptom.getPatterns();
                    int i2 = 0;
                    while (i2 < patterns.size()) {
                        SDBMatchPattern pattern = (SDBMatchPattern)patterns.get(i2);
                        SDBMatchPattern _pattern = SDBFactory.eINSTANCE.createSDBMatchPattern();
                        _pattern.setName(pattern.getName());
                        _pattern.setValue(pattern.getValue());
                        _symptom.getPatterns().add((Object)_pattern);
                        ++i2;
                    }
                    EList solutions = symptom.getSolutions();
                    int i3 = 0;
                    while (i3 < solutions.size()) {
                        SDBSolution solution = (SDBSolution)solutions.get(i3);
                        SDBSolution _solution = SDBFactory.eINSTANCE.createSDBSolution();
                        _solution.setDescription(solution.getDescription());
                        _symptom.getSolutions().add((Object)_solution);
                        this.fDatabase.getSolutions().add((Object)_solution);
                        ++i3;
                    }
                }
                ++idx;
            }
        }
        return true;
    }

    public Solution[] getSolutions(Incident incident) {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Object[] getDirectives(Incident incident) {
        block8: {
            directives = new ArrayList<SDBSymptom>();
            if (this.fDatabase == null || (incidentId = incident.getMessageId()) == null || incidentId.trim().equals("")) break block8;
            symptoms = this.fDatabase.getSymptoms();
            match = false;
            idx = 0;
            while (idx < symptoms.size()) {
                block9: {
                    block10: {
                        symptom = (SDBSymptom)symptoms.get(idx);
                        if (symptom == null) break block9;
                        patterns = symptom.getPatterns();
                        if (patterns.size() != 0) break block10;
                        match = true;
                        if (!symptom.getDescription().trim().equals("") && incidentId.indexOf(symptom.getDescription()) != -1) ** GOTO lbl-1000
                        match = false;
                        break block9;
                    }
                    numNullString = 0;
                    match = patterns.size() > 0;
                    i = 0;
                    while (i < patterns.size()) {
                        pattern = (SDBMatchPattern)patterns.get(i);
                        if (pattern.getValue().equals("")) {
                            ++numNullString;
                        } else if (incidentId.indexOf(pattern.getValue()) == -1) {
                            match = false;
                            break;
                        }
                        ++i;
                    }
                    if (numNullString != patterns.size()) ** GOTO lbl-1000
                    match = true;
                    if (incidentId.indexOf(symptom.getDescription()) == -1) {
                        match = false;
                    } else if (match) {
                        directives.add(symptom);
                    }
                }
                ++idx;
            }
        }
        return directives.toArray();
    }

    private SDBRuntime loadDatabase(String path) {
        try {
            Resource res = null;
            SDBResourceSetImpl resourceSet = SDBResourceSetImpl.getInstance();
            if (resourceSet != null) {
                res = path.startsWith("platform:/resource") ? resourceSet.getResource(URI.createURI((String)path), true) : resourceSet.getResource(URI.createFileURI((String)path), true);
            }
            Iterator i = res.getContents().iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof SDBRuntime)) continue;
                return (SDBRuntime)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public boolean replace(String symptomDbPath) {
        this.symptomDBPath = symptomDbPath;
        if (this.symptomDBPath == null) {
            return this.unload();
        }
        return this.load();
    }
}

