/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.util.IHyadesExtendedResource;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.internal.sdb.SDBPackage;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.DBResource;
import org.eclipse.hyades.resources.database.internal.Database;
import org.eclipse.hyades.resources.database.internal.InternalDatabase;
import org.eclipse.hyades.resources.database.internal.TypeMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.DBResourceImpl;
import org.eclipse.hyades.resources.database.internal.impl.DatabaseExtensions;
import org.eclipse.hyades.resources.database.internal.impl.PagingListFactory;
import org.eclipse.hyades.resources.database.internal.impl.WeakObjectCache;
import org.eclipse.hyades.resources.database.util.IDatabaseExtensions;

public class DBHyadesResourceExtension
implements IHyadesResourceExtension {
    public static final String DB_NAME = "Hyades";
    protected Map databases = new HashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Database getDatabase(String postfix, Properties properties) throws Exception {
        DatabaseType databaseType = this.getDBType(postfix);
        Database database = (Database)this.databases.get(databaseType);
        if (database != null) {
            if (database.getProperties().equals(properties)) return database;
            database.setProperties(properties);
            database.close();
        } else {
            database = ((IDatabaseExtensions)DatabaseExtensions.getInstance().get(postfix)).createDatabase(DB_NAME, properties);
        }
        if (database == null) {
            return null;
        }
        TypeMap map = database.getTypeMap();
        map.setVarCharLength(databaseType.getVarcharMaxSize());
        this.initDBMap(database);
        database.setCaching(true);
        try {
            database.open(false);
            this.databases.put(databaseType, database);
            return database;
        }
        catch (Exception e) {
            LoadersUtils.log((Throwable)e);
            throw e;
        }
    }

    public IHyadesExtendedResource createResource(URI uri, Properties properties) {
        DBResourceImpl resource = null;
        try {
            String postfix = LoadersUtils.getPostfix((URI)uri);
            Database database = this.getDatabase(postfix, properties);
            resource = new DBResourceImpl(uri, database);
        }
        catch (Exception e) {
            throw new DBCollectedExceptions(e);
        }
        return resource;
    }

    protected DatabaseType getDBType(String postfix) {
        return ((IDatabaseExtensions)DatabaseExtensions.getInstance().get(postfix)).getDBType();
    }

    protected void initDBMap(Database database) {
        ArrayList<Object> packages = new ArrayList<Object>();
        packages.add(EcorePackage.eINSTANCE);
        packages.add(HierarchyPackage.eINSTANCE);
        packages.add(CBEPackage.eINSTANCE);
        packages.add(SDBPackage.eINSTANCE);
        database.setDBMap(packages);
    }

    public EList createPagingList(Class dataClass, EObject owner, int featureID, int inverseFeatureID) {
        return PagingListFactory.INSTANCE.createPagingList(dataClass, owner, featureID, inverseFeatureID);
    }

    public EList createPagingList(Class dataClass, EObject owner, int featureID) {
        return PagingListFactory.INSTANCE.createPagingList(dataClass, owner, featureID);
    }

    public EList createPagingList(EObject owner, EStructuralFeature eStructuralFeature) {
        return PagingListFactory.INSTANCE.createPagingList(owner, eStructuralFeature);
    }

    public int getPagingSize() {
        return PagingListFactory.INSTANCE.getPagingSize();
    }

    public void setPagingSize(int size) {
        PagingListFactory.INSTANCE.setPagingSize(size);
    }

    protected boolean isEnabled(IDatabaseExtensions extension) {
        JDBCHelper jdbcHelper = extension.getJDBCHelper();
        try {
            jdbcHelper.loadJDBCDriver();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public IHyadesExtendedResource createResource(URI uri, Properties properties, Collection notLoaded) {
        DBResource resource = (DBResource)this.createResource(uri, properties);
        if (resource != null) {
            resource.getDefaultLoadOptions().put("NOT_LOADED_CLASSES", notLoaded);
            resource.getDefaultLoadOptions().put("TOP_LEVEL", Boolean.TRUE);
        }
        return resource;
    }

    public String getStoreType(String postfix) {
        return ((IDatabaseExtensions)DatabaseExtensions.getInstance().get(postfix)).getExtensionName();
    }

    public boolean createTables(String storeType, Properties properties) {
        block4: {
            try {
                Database database = this.getDatabase("__" + storeType + ".trcadb", properties);
                if (database == null) break block4;
                try {
                    database.createTables();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return false;
    }

    public boolean dropTables(String storeType, Properties properties) {
        block4: {
            try {
                Database database = this.getDatabase("__" + storeType + ".trcadb", properties);
                if (database == null) break block4;
                try {
                    database.dropTables();
                }
                catch (Exception e) {
                    LoadersUtils.log((Throwable)e);
                    return false;
                }
                return true;
            }
            catch (Exception e1) {
                LoadersUtils.log((Throwable)e1);
            }
        }
        return false;
    }

    public List getSupportedPostfixes() {
        ArrayList prefixes = new ArrayList();
        HashSet processed = new HashSet();
        Iterator iter = DatabaseExtensions.getInstance().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (processed.contains(entry.getKey()) || !(entry.getKey() instanceof String)) continue;
            processed.add(entry.getKey());
            if (!this.isEnabled((IDatabaseExtensions)entry.getValue())) continue;
            prefixes.add(entry.getKey());
        }
        return prefixes;
    }

    public EMap createPagingMap(Class dataClass, EObject owner, int featureID, int inverseFeatureID) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public EMap createPagingMap(Class dataClass, EObject owner, int featureID) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public EMap createPagingMap(EObject owner, EStructuralFeature eStructuralFeature) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public QueryResult executeQuery(Query query, ResourceSet targetResourceSet, Collection notLoadedTypes) {
        QueryResult queryResult = null;
        try {
            String firstURI = (String)query.getSources().get(0);
            InternalDatabase db = this.getInternalDatabase(firstURI);
            if (db == null) {
                this.getDatabase(LoadersUtils.getPostfix((String)firstURI), HyadesResourceExtensions.getInstance().getProperties());
                db = this.getInternalDatabase(firstURI);
            }
            if (db.isCaching()) {
                db.forceUpdates();
            }
            WeakObjectCache cache = db.getObjectCache();
            if (query instanceof TimeBasedCorrelationQuery) {
                DBCommand ssc = DBCommandFactory.INSTANCE.createTimeBaseCorrelationCommand(this.getFirstJDBCHelper(query), this.getFirstDBMap(query), (TimeBasedCorrelationQuery)query, targetResourceSet, cache, notLoadedTypes);
                queryResult = (QueryResult)ssc.execute();
                return queryResult;
            }
            if (!(query instanceof SimpleSearchQuery)) {
                throw new UnsupportedOperationException("not implemented yet");
            }
            DBCommand ssc = DBCommandFactory.INSTANCE.createSimpleSearchCommand(this.getFirstJDBCHelper(query), this.getFirstDBMap(query), (SimpleSearchQuery)query, targetResourceSet, cache, notLoadedTypes);
            queryResult = (QueryResult)ssc.execute();
        }
        catch (Exception e) {
            throw new DBCollectedExceptions(e);
        }
        return queryResult;
    }

    private InternalDatabase getInternalDatabase(String uri) {
        String postfix = LoadersUtils.getPostfix((String)uri);
        DatabaseType databaseType = this.getDBType(postfix);
        Database database = (Database)this.databases.get(databaseType);
        if (database != null) {
            return (InternalDatabase)database;
        }
        return null;
    }

    public QueryResult executeQuery(String queryName, ResourceSet targetResourceSet, Collection notLoadedTypes) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean storeQuery(Query query) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean validateQuery(Query query) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    protected DBMap getFirstDBMap(Query query) {
        if (query == null || query.getSources().size() == 0) {
            return null;
        }
        String url = (String)query.getSources().get(0);
        DatabaseType databaseType = this.getDBType(LoadersUtils.getPostfix((String)url));
        Database database = (Database)this.databases.get(databaseType);
        if (database != null) {
            return database.getDBMap();
        }
        return null;
    }

    protected JDBCHelper getFirstJDBCHelper(Query query) {
        if (query == null || query.getSources().size() == 0) {
            return null;
        }
        String url = (String)query.getSources().get(0);
        DatabaseType databaseType = this.getDBType(LoadersUtils.getPostfix((String)url));
        Database database = (Database)this.databases.get(databaseType);
        if (database != null) {
            return database.getJDBCHelper();
        }
        return null;
    }
}

