/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.ObjectQuery;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.GetURICommand;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.GetByQueryCommand;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;
import org.eclipse.hyades.resources.database.internal.impl.WeakObjectCache;

public class GetObjectQuery
extends GetByQueryCommand {
    protected ObjectQuery query;

    public GetObjectQuery(JDBCHelper helper, DBMap map, DatabaseType type, ObjectQuery query, WeakObjectCache cache) {
        super(helper, map, type, cache);
        this.query = query;
    }

    public Object execute() throws Exception {
        if (this.query.getEClass() == null) {
            return null;
        }
        List ids = this.getIdsForMatchingObjects();
        EObject[] objects = this.getObjects(ids);
        if (this.query.getURI() == null) {
            return objects;
        }
        return this.getObjectsInResource(objects, ids);
    }

    protected EObject[] getObjectsInResource(EObject[] objects, List ids) throws Exception {
        ArrayList<Object> classesAndIds = new ArrayList<Object>();
        classesAndIds.add(this.query.getEClass());
        classesAndIds.add(ids);
        GetURICommand getURIs = new GetURICommand(this.helper, this.dbMap, this.type, classesAndIds);
        String[] uris = (String[])getURIs.execute();
        ArrayList<EObject> objectsInResource = new ArrayList<EObject>();
        int i = 0;
        while (i < uris.length) {
            if (this.query.getURI().toString().equals(uris[i])) {
                objectsInResource.add(objects[i]);
            }
            ++i;
        }
        return this.toArray(objectsInResource);
    }

    protected List getIdsForAllObjects() throws Exception {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        String statement = this.createQueryForAllObjects();
        Statement jdbcStatement = this.helper.createStatement();
        ResultSet result = this.helper.executeQuery(jdbcStatement, statement);
        while (result.next()) {
            int id = result.getInt(1);
            ids.add(new Integer(id));
        }
        result.close();
        jdbcStatement.close();
        return ids;
    }

    protected String createQueryForAllObjects() {
        DBMap.ClassData data = (DBMap.ClassData)this.dbMap.getDBRepresentation((EModelElement)this.query.getEClass());
        Table table = data.getTable();
        RDBHelper rdbHelper = new RDBHelper();
        Column id = rdbHelper.getPrimaryKey(table);
        StringBuffer s = new StringBuffer();
        s.append("SELECT ");
        s.append(this.addQuotes(id.getName()));
        s.append(" FROM ");
        s.append(this.addQuotes(table.getName()));
        return s.toString();
    }

    protected List getIdsForMatchingObjects() throws Exception {
        Map values = this.query.getAttributeValues();
        if (values.isEmpty()) {
            return this.getIdsForAllObjects();
        }
        DBCommand getIds = this.factory.createGetIdsOfMatches(this.helper, this.dbMap, this.type, this.query.getEClass(), values);
        return (List)getIds.execute();
    }

    protected EObject[] getObjects(List ids) throws Exception {
        List objects = this.getObjects(this.query.getEClass(), ids, this.query.isSetReferences(), this.query.getNotLoadedClasses());
        return this.toArray(objects);
    }
}

