/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;

public class InsertReferenceStatement
extends SQLStatement {
    protected Integer sourceId;
    protected Integer targetId;
    protected EReference reference;
    protected int position;
    protected Column source;
    protected Column target;
    protected DBMap.ReferenceData data;

    public InsertReferenceStatement(DatabaseType dbType, DBMap map, Integer sourceId, EReference reference, Integer targetId, int position) {
        super(dbType, map);
        this.sourceId = sourceId;
        this.targetId = targetId;
        this.reference = reference;
        this.position = position;
        this.data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation((EModelElement)reference);
    }

    public String getStatement() {
        StringBuffer buffer = new StringBuffer();
        this.setSourceAndTarget(this.data);
        buffer.append("INSERT INTO ");
        buffer.append(this.addQuotes(this.data.getTable().getName()));
        buffer.append(" ");
        this.addColumnNames(buffer);
        this.addValues(buffer);
        return buffer.toString();
    }

    protected void addColumnNames(StringBuffer buffer) {
        buffer.append("(");
        buffer.append(this.addQuotes(this.source.getName()));
        buffer.append(", ");
        buffer.append(this.addQuotes(this.target.getName()));
        if (this.data.getOrderColumn() != null) {
            buffer.append(", ");
            buffer.append(this.addQuotes(this.data.getOrderColumn().getName()));
        }
        buffer.append(") ");
    }

    protected void addValues(StringBuffer buffer) {
        buffer.append(" VALUES (");
        buffer.append(this.sourceId);
        buffer.append(", ");
        buffer.append(this.targetId);
        if (this.data.getOrderColumn() != null) {
            buffer.append(", ");
            buffer.append(this.position);
        }
        buffer.append(")");
    }

    protected void setSourceAndTarget(DBMap.ReferenceData data) {
        this.source = data.getSourceColumn();
        this.target = data.getTargetColumn();
        if (this.isPrimaryKey(this.target)) {
            Column temp = this.target;
            this.target = this.source;
            this.source = temp;
            Integer temp2 = this.targetId;
            this.targetId = this.sourceId;
            this.sourceId = temp2;
        }
    }

    protected boolean isPrimaryKey(Column column) {
        EList constraints = column.getConstraints();
        int i = 0;
        int l = constraints.size();
        while (i < l) {
            Constraint constraint = (Constraint)constraints.get(i);
            if ("PRIMARYKEY".equals(constraint.getType())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

