/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.DefaultPage;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.editor.action.ActionHandlerListener;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public abstract class TraceViewer
extends ViewPart
implements IMenuListener,
ISelectionListener,
IProfileEventListener,
IDeleteListener {
    protected EObject _mofObject;
    protected boolean _initializedMenu = false;
    protected Hashtable _pages = new Hashtable();
    private PageBook book;
    private IPage currentPage;
    private IPage defaultPage;
    private IDialogSettings settings;
    protected Menu fContextMenu;
    public final String GROUP_ADD_VIEWS = "open.views";
    public final String GROUP_GENERIC = "generic.action";
    protected boolean fRefreshView = false;
    protected boolean fPartVisible = true;
    protected IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref != null && ref.getPart(false) == TraceViewer.this) {
                TraceViewer.this.fPartVisible = true;
                if (TraceViewer.this.fRefreshView) {
                    TraceViewer.this.fRefreshView = false;
                    INavigator navigator = HyadesUtil.getActiveNavigator();
                    if (navigator != null && navigator.isLinkingEnabled()) {
                        TraceViewer.this.refreshVisiblePage();
                    }
                }
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref != null && ref.getPart(false) == TraceViewer.this) {
                TraceViewer.this.fPartVisible = false;
            }
        }
    };
    private int previousSelection = 0;

    public void addViewPage(EObject object, boolean newPage) {
        if (this.book == null) {
            UIPlugin.getDefault().removeSelectionListener(this);
            return;
        }
        this._mofObject = this.getObjectToView(object);
        this.setViewTitle(this._mofObject);
        if (this._mofObject == null) {
            this.showPage(this.defaultPage);
            return;
        }
        TraceViewerPage page = this.getPage(this._mofObject);
        if (this.defaultPage == page) {
            return;
        }
        if (page == null) {
            Enumeration pages = this._pages.elements();
            while (pages.hasMoreElements()) {
                ((IPage)pages.nextElement()).dispose();
            }
            this._pages.clear();
            this.makeActions();
            page = this.createPage(this._mofObject);
            page.createControl((Composite)this.book);
            this._pages.put(this._mofObject, page);
            newPage = true;
        }
        page.update(newPage);
        if (page.isEmpty()) {
            this.showPage(this.defaultPage);
        } else {
            this.showPage((IPage)page);
        }
    }

    public void addViewPage(EObject object) {
        this.addViewPage(object, false);
    }

    public EObject getObjectToView(EObject selObject) {
        return selObject;
    }

    protected IPage createDefaultPage(PageBook book) {
        DefaultPage page = new DefaultPage();
        page.createControl((Composite)book);
        page.setMessage(UIPlugin.getResourceString("STR_NODATA"));
        return page;
    }

    public abstract TraceViewerPage createPage(EObject var1);

    public void createPartControl(Composite parent) {
        this.book = new PageBook(parent, 0);
        this.defaultPage = this.createDefaultPage(this.book);
        this.addViewPage(HyadesUtil.getMofObject());
        UIPlugin.getDefault().addSelectionListener(this);
        UIPlugin.getDefault().addProfileEventListener(this);
        UIPlugin.getDefault().addDeleteListener(this);
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.settings = UIPlugin.getDefault().getDialogSettings();
    }

    public IPage getCurrentPage() {
        if (this.currentPage == null || !(this.currentPage instanceof TraceViewerPage)) {
            return null;
        }
        return this.currentPage;
    }

    public TraceViewerPage getPage(EObject mofObject) {
        Object page;
        if (mofObject != null && (page = this._pages.get(mofObject)) != null) {
            return (TraceViewerPage)((Object)page);
        }
        return null;
    }

    public void dispose() {
        this.settings = null;
        UIPlugin.getDefault().removeSelectionListener(this);
        UIPlugin.getDefault().removeProfileEventListener(this);
        UIPlugin.getDefault().removeDeleteListener(this);
        this.getSite().getPage().removePartListener(this.fPartListener);
        Enumeration pages = this._pages.elements();
        while (pages.hasMoreElements()) {
            ((IPage)pages.nextElement()).dispose();
        }
        this._pages.clear();
        if (this.book != null) {
            this.book.dispose();
            this.book = null;
        }
        if (this.currentPage != null) {
            this.currentPage.dispose();
            this.currentPage = null;
        }
        if (this.defaultPage != null) {
            this.defaultPage.dispose();
            this.defaultPage = null;
        }
        this.fPartListener = null;
        super.dispose();
    }

    public void initializedMenu(boolean init) {
        this._initializedMenu = init;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return true;
    }

    public boolean isInitializedMenu() {
        return this._initializedMenu;
    }

    public boolean isSaveNeeded() {
        return false;
    }

    public void makeActions() {
    }

    protected void refreshPage(Object obj) {
        if (this._pages == null) {
            return;
        }
        if (obj != null) {
            Object page = this._pages.get(obj);
            if (page == null) {
                this.fRefreshView = true;
                return;
            }
            if (page instanceof TraceViewerPage) {
                ((TraceViewerPage)((Object)page)).refreshPage();
                if (((TraceViewerPage)((Object)page)).isEmpty()) {
                    this.showPage(this.defaultPage);
                } else {
                    this.showPage((IPage)((TraceViewerPage)((Object)page)));
                }
            }
        }
    }

    protected void selectionChanged(Object obj) {
        if (obj == null) {
            return;
        }
        Object page = this._pages.get(obj);
        if (page != null && page instanceof TraceViewerPage) {
            ((TraceViewerPage)((Object)page)).selectionChanged();
        }
    }

    public void removePage(Object obj) {
        if (obj == null || !(obj instanceof EObject)) {
            return;
        }
        Object page = this._pages.get(this.getObjectToView((EObject)obj));
        this._pages.remove(obj);
        if (page != null) {
            if (page == this.currentPage) {
                this.showPage(this.defaultPage);
            }
            ((IPage)page).dispose();
        }
    }

    public void setFocus() {
    }

    public void showPage(IPage page) {
        this.book.showPage(page.getControl());
        this.currentPage = page;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.fRefreshView = true;
        boolean openView = ((INavigator)part).isLinkingEnabled();
        if (!this.fPartVisible || part == null || part.getSite().getWorkbenchWindow() != this.getSite().getWorkbenchWindow()) {
            return;
        }
        if (!openView) {
            return;
        }
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            this.addViewPage(null);
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj == null || !(obj instanceof EObject)) {
            this.addViewPage(null);
        } else {
            if (this.previousSelection != obj.hashCode()) {
                this.fRefreshView = true;
                this.previousSelection = obj.hashCode();
            } else {
                this.fRefreshView = false;
            }
            this.addViewPage((EObject)obj);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.enableEditActions();
    }

    public abstract String getViewTitle();

    public void handleProfileEvent(ProfileEvent event) {
        int type = event.getType();
        if (type == 64 || type == 32) {
            if (!this.fPartVisible) {
                this.fRefreshView = true;
                return;
            }
            this.fRefreshView = false;
            if (event.getSource() instanceof EObject) {
                INavigator nav = HyadesUtil.getActiveNavigator();
                if (nav == null || nav.isLinkingEnabled() || this._mofObject == null) {
                    this.refreshPage(this.getObjectToView((EObject)event.getSource()));
                } else {
                    if (this._mofObject != event.getSource()) {
                        ProfileEvent newEvent = UIPlugin.getDefault().getUpdateModelSnapshotEvent(this._mofObject);
                        UIPlugin.getDefault().notifyProfileEventListener(newEvent);
                    }
                    this.refreshPage(this.getObjectToView(this._mofObject));
                }
            }
        }
    }

    protected void setViewTitle(Object selection) {
        if (selection != null && selection instanceof TRCAgentProxy) {
            TRCAgentProxy a = (TRCAgentProxy)selection;
            this.setPartName(this.getViewTitle() + " - " + HyadesUtil.getProcessName(a.getProcessProxy()));
            return;
        }
        this.setPartName(this.getViewTitle());
    }

    public void initializeActionBar() {
    }

    public void setRecordSelection(EObject record, EObject treeSel) {
    }

    public boolean isProcessRefreshEvents() {
        return this.fPartVisible;
    }

    protected void refreshVisiblePage() {
        EObject obj = HyadesUtil.getMofObject();
        this.addViewPage(obj);
        EObject sel = this.getObjectToView(obj);
        this.refreshPage(sel);
        this.selectionChanged(sel);
    }

    public void menuAboutToShow(IMenuManager menu) {
        if (this.getCurrentPage() != null && this.getCurrentPage() instanceof TraceViewerPage) {
            ((TraceViewerPage)this.getCurrentPage()).fillContextMenu(menu);
        }
        menu.add((IContributionItem)new Separator("open.views"));
        menu.add((IContributionItem)new Separator("generic.action"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void deregister(Object obj) {
        this.removePage(obj);
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }
}

