/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.AttachInfoDialog;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.WarningDialog;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class NewSnapshotActionDelegate
extends AbstractListenerActionDelegate {
    public void doAction(Object object) throws Exception {
        if (object == null || !(object instanceof TRCAgentProxy)) {
            return;
        }
        INavigator fViewer = (INavigator)this.getView();
        if (fViewer == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        this.run((TRCAgentProxy)object, fViewer);
    }

    public void run(TRCAgentProxy fAgent, INavigator fViewer) {
        Dialog infodialog;
        if (fAgent.isActive() && fAgent.isAttached() && UIPlugin.getDefault().getPreferenceStore().getBoolean("new_snapshot_tips") && (infodialog = new WarningDialog(UIPlugin.getDefault().getViewer().getShell(), UIPlugin.getResourceString("NEW_SNAPSHOT_TIP_TITLE"), UIPlugin.getResourceString("NEW_SNAPSHOT_WARNING_MESSAGE"), UIPlugin.getResourceString("NEW_SNAPSHOT_WARNING_TEXT"), "new_snapshot_tips")).open() == 1) {
            return;
        }
        if (UIPlugin.getDefault().getPreferenceStore().getBoolean("profile_tips")) {
            infodialog = new AttachInfoDialog(UIPlugin.getDefault().getViewer().getShell(), UIPlugin.getResourceString("PROFILING_TIP_TITLE"));
            infodialog.open();
        }
        try {
            Agent a;
            PDCoreUtil.detachAgent(fAgent);
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource(fAgent);
            event.setType(8);
            UIPlugin.getDefault().notifyProfileEventListener(event);
            TRCProcessProxy process = fAgent.getProcessProxy();
            String hostName = process.getNode().getName();
            Node node = PDCoreUtil.profileConnect(hostName, String.valueOf(process.getNode().getPort()));
            if (node == null) {
                return;
            }
            Object instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)fAgent);
            if (instance != null && instance instanceof Agent && (a = (Agent)instance).isActive()) {
                if (fAgent.isActive()) {
                    PDCoreUtil.detachAgent(fAgent);
                    fAgent.setActive(false);
                }
                TRCAgentProxy fAgentOld = fAgent;
                fAgent = PDCoreUtil.createUniqueAgent(process, a);
                PDCoreUtil.copyAgentProperties(fAgentOld, fAgent);
                PDCoreUtil.doAttach(a, fAgent);
                PDCoreUtil.activate(fAgent);
            }
            event = UIPlugin.getDefault().getProfileEvent();
            event.setSource(fAgent);
            event.setType(4);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    protected boolean isEnabledFor(Object element) {
        return element != null && element instanceof TRCAgentProxy && ((TRCAgentProxy)element).isActive() && ((TRCAgentProxy)element).isAttached();
    }

    protected boolean enableForMultiSelection() {
        return false;
    }

    public void dispose() {
        super.dispose();
    }
}

