/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileAttachDelegate;
import org.eclipse.hyades.trace.ui.internal.util.DoubleCTree;
import org.eclipse.hyades.trace.ui.internal.util.ProcessTreeItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.help.WorkbenchHelp;

public class ProfileAgentsTab
extends AbstractLaunchConfigurationTab {
    private ILaunchConfiguration _conf;
    private DoubleCTree _list;
    private boolean _initialized = false;

    public void createControl(Composite parent) {
        this._initialized = false;
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        content.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(content, 1);
        this._list = new DoubleCTree(content, 0, UIPlugin.getResourceString("STR_LIST_AGENTS"), UIPlugin.getResourceString("STR_LIST_SOURCE"), UIPlugin.getResourceString("STR_LIST_TARGET"));
        this._list.addListener(new Listener(){

            public void handleEvent(Event event) {
                ProfileAgentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button refresh = new Button(content, 8);
        refresh.setText(UIPlugin.getResourceString("RESET_DATA"));
        refresh.setToolTipText(UIPlugin.getResourceString("REINITIALIZE_AGNT_TOOLTIP"));
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileAgentsTab.this._list.initialize();
            }
        });
        WorkbenchHelp.setHelp((Control)this._list.getControl(), (String)(UIPlugin.getPluginId() + ".atlp0002"));
        WorkbenchHelp.setHelp((Control)refresh, (String)(UIPlugin.getPluginId() + ".atlp0000"));
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".atlp0002"));
    }

    public boolean isValid(ILaunchConfiguration conf) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (conf != null && !this._list.treesLoaded()) {
            this.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_AGENTS"));
            return false;
        }
        if (this._list.getSelectedItemsForProfiling().length == 0) {
            this.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_AGENTS"));
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        boolean storedLaunchConfiguration;
        this._conf = conf;
        this._list.initializeLaunchConfiguration(this._conf);
        boolean bl = storedLaunchConfiguration = this._list.getAttributeProcesses().size() > 0;
        if (this.getControl().isVisible() && !this._initialized || !this._initialized && storedLaunchConfiguration) {
            this._list.initialize();
            this._initialized = true;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        if (this._initialized && this._list.treesLoaded()) {
            ArrayList<String> list = new ArrayList<String>();
            Object[] targetItems = this._list.getSelectedItemsForProfiling();
            int i = 0;
            while (i < targetItems.length) {
                list.add(new ProfileAttachDelegate.ProcessAttribute((Process)((ProcessTreeItem)targetItems[i]).getData(), false).getAttributeString());
                ++i;
            }
            wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, list);
        }
    }

    public String getName() {
        return UIPlugin.getResourceString("TAB_NAME_AGENTS");
    }

    public Image getImage() {
        return PDPluginImages.getImage("agent_obj.gif");
    }

    void reset() {
        this._initialized = false;
        this._list.removeAll();
    }
}

