/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.Iterator;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.DefaultPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileAttachDelegate;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.part.PageBook;

public class ProfileOverviewTab {
    private TraceProfileOverviewUI _overviewUI = new TraceProfileOverviewUI();
    private PageBook _book;
    private Composite _ui;
    private Composite _blank;

    public ProfileOverviewTab(ProfileTab pt) {
    }

    public Composite createControl(Composite parent) {
        this._book = new PageBook(parent, 0);
        this._ui = this._overviewUI.createControl((Composite)this._book);
        DefaultPage page = new DefaultPage();
        page.setMessage(UIPlugin.getResourceString("STR_OPTION_IGNORED"));
        page.createControl((Composite)this._book);
        this._blank = (Composite)page.getControl();
        return this._book;
    }

    public void addListener(Listener _listener) {
        this._overviewUI.addListener(_listener);
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        if (ProfileOverviewTab.optionsAllowed(conf)) {
            this._overviewUI.initializeFrom(conf);
            this._book.showPage((Control)this._ui);
        } else {
            this._book.showPage((Control)this._blank);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        this._overviewUI.performApply(wc);
    }

    public boolean isValid(ILaunchConfiguration conf) {
        return this._overviewUI.isValid(conf);
    }

    private static boolean optionsAllowed(ILaunchConfiguration conf) {
        boolean hasJ2EEAgent = false;
        boolean hasNonJ2EEAgent = false;
        Iterator i = ProfileAttachDelegate.getAttributeAgents(conf).iterator();
        while (i.hasNext()) {
            ProfileAttachDelegate.AgentAttribute agent = (ProfileAttachDelegate.AgentAttribute)i.next();
            if (!agent.getType().equals("Profiler")) continue;
            if (agent.getName().equals("J2EE Request Profiler")) {
                hasJ2EEAgent = true;
                continue;
            }
            hasNonJ2EEAgent = true;
        }
        return hasNonJ2EEAgent || !hasJ2EEAgent;
    }
}

