/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.local.control.Variable;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.security.util.ConnectUtil;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.internal.ui.TraceUIManager;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.piclient.PIAttachListener;
import org.eclipse.hyades.trace.ui.internal.piclient.PIProcessListener;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;
import org.eclipse.hyades.trace.ui.internal.util.ProcessMap;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PDCoreUtil {
    public static final Vector attach(String hostName, Vector agents, Vector options, ArrayList filters, String selectedProject, String selectedMonitor) {
        return PDCoreUtil.attach(hostName, agents, options, filters, selectedProject, selectedMonitor, "10002", null, null);
    }

    public static final Vector attach(String hostName, Vector agents, Vector options, ArrayList filters, String selectedProject, String selectedMonitor, String portNumber, String profileFile, ILaunch launch) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        PDCoreUtil.switchPerspective();
        try {
            Node fnode = NodeFactory.createNode((String)hostName);
            hostName = fnode.getInetAddress().getHostName();
        }
        catch (UnknownHostException exc) {
            // empty catch block
        }
        IContainer container = PDCoreUtil.createContainer((IPath)new Path(selectedProject));
        TRCMonitor monitor = PDCoreUtil.createMonitor(container, selectedMonitor);
        TRCNode node = PDCoreUtil.createNode(monitor, hostName, portNumber);
        TRCProcessProxy process = null;
        Vector<TRCAgentProxy> trcAgentList = new Vector<TRCAgentProxy>();
        int idx = 0;
        while (idx < agents.size()) {
            Agent agent = (Agent)agents.elementAt(idx);
            Process pInfo = agent.getProcess();
            final ProcessAdapter adapter = new ProcessAdapter(pInfo, launch, true);
            TraceUIManager.getTraceUIManager().registerLaunchProcess(adapter);
            pInfo.addProcessListener(new ProcessListener(){

                public void processLaunched(Process p) {
                }

                public void processExited(Process p) {
                    TraceUIManager.getTraceUIManager().deregisterLaunchProcess(adapter);
                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)adapter, 8)});
                }
            });
            AgentConfiguration ac = agent.getConfiguration();
            if (ac == null) {
                agent.setConfiguration(new AgentConfiguration());
            }
            agent.getConfiguration().clear();
            if (idx == 0 && profileFile != null && !profileFile.equals("")) {
                agent.setProfileFile(profileFile);
            } else {
                agent.setProfileFile("");
            }
            PDCoreUtil.addDefaultProfileData(agent, filters);
            PDCoreUtil.addDefaultOptionsData(agent, options);
            process = PDCoreUtil.createProcess(node, pInfo);
            ProcessMap.put(process, adapter);
            try {
                TRCAgentProxy agentProxy = PDCoreUtil.createUniqueAgent(process, agent);
                PDCoreUtil.activate(agentProxy);
                PDCoreUtil.doAttach(agent, agentProxy);
                trcAgentList.add(agentProxy);
                final ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource(agentProxy);
                event.setType(4);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        UIPlugin.getDefault().notifyProfileEventListener(event);
                    }
                });
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            ++idx;
        }
        return trcAgentList;
    }

    public static void activate(TRCAgentProxy agentProxy) {
        Iterator iter = agentProxy.getProcessProxy().getAgentProxies().iterator();
        while (iter.hasNext()) {
            TRCAgentProxy element = (TRCAgentProxy)iter.next();
            try {
                if (!agentProxy.getName().equals(element.getName()) || !agentProxy.getType().equals(element.getType())) continue;
                element.setActive(false);
                element.setAttached(false);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        agentProxy.setActive(true);
        agentProxy.setAttached(true);
    }

    public static final void detachAgent(TRCAgentProxy agent) throws InactiveAgentException, InactiveProcessException {
        XMLTraceDataProcessor processor;
        Agent a;
        Object instance;
        TRCProcessProxy process = agent.getProcessProxy();
        String hostName = process.getNode().getName();
        Node node = PDCoreUtil.profileConnect(hostName, String.valueOf(process.getNode().getPort()));
        if (node != null && (instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)agent)) != null && instance instanceof Agent && (a = (Agent)instance).isAttached()) {
            a.detach();
        }
        agent.setMonitored(false);
        agent.setAttached(false);
        LoadersUtils.deregisterDataProcessor((TRCAgentProxy)agent);
        if (agent.isToProfileFile() && (processor = (XMLTraceDataProcessor)LoadersUtils.locateDataProcessor((TRCAgentProxy)agent)) != null) {
            processor.endTrace(processor.getWriter());
            processor.setProfileFileName(null);
            processor.setWriter(null);
        }
    }

    public static TRCAgentProxy createAgent(TRCProcessProxy process, Agent a) {
        TRCAgentProxy agentProxy = PDCoreUtil.createAgent(process, a, "");
        return agentProxy;
    }

    public static TRCAgentProxy getCorrespondingAgent(TRCProcessProxy processProxy, Agent ag, boolean activeProxy) {
        Iterator i = processProxy.getAgentProxies().iterator();
        while (i.hasNext()) {
            TRCAgentProxy agentProxy = (TRCAgentProxy)i.next();
            if (agentProxy.eIsProxy() || agentProxy == null || !agentProxy.getName().equals(ag.getName()) || agentProxy.getRuntimeId() != null && agentProxy.getRuntimeId() != ag.getUUID() || agentProxy.isActive() != activeProxy) continue;
            return agentProxy;
        }
        return null;
    }

    public static TRCAgentProxy createAgent(TRCProcessProxy processProxy, Agent agent, String sessionId) {
        TRCAgentProxy agentProxy = PDCoreUtil.getCorrespondingAgent(processProxy, agent, false);
        if (agentProxy != null) {
            return agentProxy;
        }
        return PDCoreUtil.createAgentNoCheck(processProxy, agent, sessionId);
    }

    public static final IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = UIPlugin.getPluginWorkbench();
        int segCount = path.segmentCount();
        int idx = 0;
        while (idx < segCount) {
            String seg = path.segment(idx);
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    project.open(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                container = project;
            } else {
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    try {
                        folder.create(false, true, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                container = folder;
            }
            ++idx;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException exc) {
            exc.printStackTrace();
        }
        return container;
    }

    public static final TRCMonitor createMonitor(IContainer res, String name) {
        IWorkspace workbench = res.getWorkspace();
        TRCMonitor monitor = null;
        ArrayList monitors = PDContentProvider.getMonitors(res);
        int idx = 0;
        while (idx < monitors.size()) {
            Object mon = monitors.get(idx);
            if (mon instanceof TRCMonitor && ((TRCMonitor)mon).getName().equals(name)) {
                return (TRCMonitor)mon;
            }
            ++idx;
        }
        String monitorName = TString.change(name, " ", "");
        String monitorFileName = monitorName + "." + "trcmxmi";
        IPath filePath = res.getFullPath().append(monitorFileName);
        URI uri = URI.createURI((String)("platform:/resource" + filePath.toString()));
        Resource monDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        monDoc.setModified(true);
        EList monExt = monDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)monDoc);
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        monitor = factory.createTRCMonitor();
        monitor.setName(name);
        monExt.add((Object)monitor);
        PDContentProvider.addMonitor((IResource)res, monitor);
        return monitor;
    }

    public static final TRCNode createNode(TRCMonitor monitor, String name, String portNumber) {
        TRCNode node;
        String ipAddress = "";
        try {
            Node fnode = NodeFactory.createNode((String)name);
            name = fnode.getInetAddress().getHostName();
            ipAddress = fnode.getInetAddress().getHostAddress();
        }
        catch (UnknownHostException exc) {
            // empty catch block
        }
        Object[] nodes = monitor.getNodes().toArray();
        int idx = 0;
        while (idx < nodes.length) {
            node = (TRCNode)nodes[idx];
            if (!node.eIsProxy() && node.getName().equals(name)) {
                node.setPort(Integer.parseInt(portNumber));
                return node;
            }
            ++idx;
        }
        node = null;
        String nodeName = TString.change(monitor.getName(), " ", "") + "_" + TString.change(name, " ", "");
        String nodeFileName = nodeName + "." + "trcnxmi";
        String monPath = monitor.eResource().getURI().toString();
        Path path = new Path(monPath);
        if (path.segmentCount() > 1) {
            monPath = path.removeLastSegments(1).toString();
        }
        IPath filePath = new Path(monPath).append(nodeFileName);
        URI uri = URI.createURI((String)filePath.toString());
        Resource nodeDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        nodeDoc.setModified(true);
        EList nodeExt = nodeDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)nodeDoc);
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        node = factory.createTRCNode();
        node.setName(name);
        node.setIpAddress(ipAddress);
        node.setMonitor(monitor);
        node.setPort(Integer.parseInt(portNumber));
        nodeExt.add((Object)node);
        EList mon_nodes = monitor.getNodes();
        try {
            mon_nodes.add((Object)node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return node;
    }

    public static TRCProcessProxy createProcess(TRCNode node, Process pInfo) {
        try {
            TRCProcessProxy process = null;
            EList processes = node.getProcessProxies();
            Iterator i = processes.iterator();
            while (i.hasNext()) {
                process = (TRCProcessProxy)i.next();
                if (process.eIsProxy() || !String.valueOf(process.getPid()).equals(pInfo.getProcessId())) continue;
                if (process.getRuntimeId() != null && process.getRuntimeId().equals(pInfo.getUUID())) {
                    return process;
                }
                Iterator agents = process.getAgentProxies().iterator();
                while (agents.hasNext()) {
                    TRCAgentProxy agent = (TRCAgentProxy)agents.next();
                    if (agent.eIsProxy() || !agent.isActive()) continue;
                    return process;
                }
            }
            TRCMonitor monitor = node.getMonitor();
            String rID = new Date().toString();
            rID = TString.change(rID, " ", "");
            rID = TString.change(rID, ":", "");
            String processName = monitor.getName() + "_" + node.getName() + "_" + pInfo.getProcessId() + "_" + rID;
            String fileName = processName + "." + "trcpxmi";
            String monPath = node.eResource().getURI().toString();
            Path path = new Path(monPath);
            if (path.segmentCount() > 1) {
                monPath = path.removeLastSegments(1).toString();
            }
            IPath filePath = new Path(monPath).append(fileName);
            URI uri = URI.createURI((String)filePath.toString());
            Resource pDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
            pDoc.setModified(true);
            EList pExt = pDoc.getContents();
            UIPlugin.getDefault().getResourceSet().getResources().add((Object)pDoc);
            HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
            process = factory.createTRCProcessProxy();
            process.setPid(Integer.parseInt(pInfo.getProcessId()));
            process.setRuntimeId(pInfo.getUUID());
            if (pInfo.getName() != null) {
                process.setName(pInfo.getName());
            } else {
                process.setName(pInfo.getExecutable());
            }
            process.setLocation(((ProcessImpl)pInfo).getlocation());
            process.setActive(true);
            process.setLaunchMode(0);
            process.setNode(node);
            pExt.add((Object)process);
            return process;
        }
        catch (InactiveProcessException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static void detachAgents() {
        Iterator e = HierarchyResourceSetImpl.getInstance().getResources().iterator();
        while (e.hasNext()) {
            Resource res = (Resource)e.next();
            EList ext = res.getContents();
            Iterator i = ext.iterator();
            while (i.hasNext()) {
                TRCAgentProxy agent;
                TRCProcessProxy process;
                Object obj = i.next();
                if (!(obj instanceof TRCAgentProxy) || (process = (agent = (TRCAgentProxy)obj).getProcessProxy()) == null || !process.isActive() || !agent.isActive()) continue;
                try {
                    Agent a;
                    Object instance;
                    String hostName = process.getNode().getName();
                    Node node = NodeFactory.createNode((String)hostName);
                    if (!node.isConnected() || (instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)agent)) == null || !(instance instanceof Agent) || (a = (Agent)instance) == null || !a.isAttached()) continue;
                    a.detach();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
    }

    public static void doAttach(Agent agent, TRCAgentProxy agentProxy) throws InactiveAgentException, InactiveProcessException {
        PIProcessListener processListener = (PIProcessListener)LoadersUtils.locateAgentListener((TRCAgentProxy)agentProxy);
        if (processListener == null) {
            processListener = new PIAttachListener(agentProxy.getProcessProxy().getNode(), agentProxy.getProcessProxy());
            LoadersUtils.registerAgentListener((TRCAgentProxy)agentProxy, (Object)processListener);
        }
        processListener.monitor(true);
        processListener.setLaunchMode(0);
        agent.addAgentListener((AgentListener)processListener);
        agent.attach();
    }

    public static final boolean launchTrace(TraceArguments trace, ArrayList filters, Vector options, String selectedProject, String selectedMonitor, ILaunch launch) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        PDCoreUtil.switchPerspective();
        try {
            String agents;
            String nodeName = trace.getHostName();
            Node lhost = PDCoreUtil.profileConnect(nodeName, String.valueOf(trace.getPortNumber()));
            if (lhost == null) {
                return false;
            }
            nodeName = lhost.getName();
            IContainer container = PDCoreUtil.createContainer((IPath)new Path(selectedProject));
            TRCMonitor monitor = PDCoreUtil.createMonitor(container, selectedMonitor);
            TRCNode node = PDCoreUtil.createNode(monitor, nodeName, String.valueOf(trace.getPortNumber()));
            PIProcessListener listener = new PIProcessListener(node);
            listener.monitor(true);
            Process lprocess = ProcessFactory.createProcess((Node)lhost);
            lprocess.setLocation(trace.getLocation());
            lprocess.addProcessListener((ProcessListener)listener);
            listener.setLaunchMode(1);
            listener.setAutoMonitoring(trace.isAutoMonitoring());
            boolean hasProfAgents = false;
            if (store.getBoolean("log_option") && (agents = store.getString("log_agents")) != null && !agents.equals("")) {
                int idx = 0;
                while (idx != -1) {
                    idx = agents.indexOf(",");
                    if (idx != -1) {
                        String agent = agents.substring(0, idx);
                        Agent a = AgentFactory.createAgent((Process)lprocess, (String)agent, (String)"Logging");
                        a.addAgentListener((AgentListener)listener);
                        a.setAutoAttach(true);
                        agents = agents.substring(idx + 1);
                        continue;
                    }
                    Agent a = AgentFactory.createAgent((Process)lprocess, (String)agents, (String)"Logging");
                    a.addAgentListener((AgentListener)listener);
                    a.setAutoAttach(true);
                }
            }
            if (store.getBoolean("prof_option")) {
                hasProfAgents = true;
                Agent a = AgentFactory.createAgent((Process)lprocess, (String)"Java Profiling Agent", (String)"Profiler");
                a.addAgentListener((AgentListener)listener);
                a.setAutoAttach(true);
                AgentConfiguration ac = a.getConfiguration();
                if (ac == null) {
                    a.setConfiguration(new AgentConfiguration());
                }
                a.getConfiguration().clear();
                if (trace.isToProfileFile()) {
                    a.setProfileFile(trace.getProfileFile());
                }
                PDCoreUtil.addDefaultProfileData(a, filters);
                PDCoreUtil.addDefaultOptionsData(a, options);
            }
            String exec = trace.getClassName();
            if (trace.getVMArguments() != null && !trace.getVMArguments().equals("")) {
                exec = trace.getVMArguments() + " " + exec;
            }
            if (trace.getParameters() != null && !trace.getParameters().equals("")) {
                exec = exec + " " + trace.getParameters();
            }
            String param = "";
            if (!hasProfAgents) {
                param = exec;
            }
            if (hasProfAgents) {
                lprocess.setExecutable("java.exe");
                param = "-XrunpiAgent:server=controlled " + exec;
            } else {
                lprocess.setExecutable("java.exe");
                param = exec;
            }
            lprocess.setParameters(param);
            lprocess.addEnvironmentVariable(new Variable("CLASSPATH", TString.stripNewLineChar(trace.getClassPath())));
            lprocess.addEnvironmentVariable(new Variable("UICLASSPATH", trace.getClassPath()));
            listener.getProcessVariableList().add(new Variable("UICLASSPATH", trace.getClassPath()));
            PDCoreUtil.setEnvironmentVariable(lprocess, trace.getEnvironmentVariable(), listener);
            try {
                lprocess.launch();
                final ProcessAdapter adapter = new ProcessAdapter(lprocess, launch, true);
                TraceUIManager.getTraceUIManager().registerLaunchProcess(adapter);
                lprocess.addProcessListener(new ProcessListener(){

                    public void processLaunched(Process p) {
                    }

                    public void processExited(Process p) {
                        TraceUIManager.getTraceUIManager().deregisterLaunchProcess(adapter);
                        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)adapter, 8)});
                    }
                });
                int pID = Integer.parseInt(lprocess.getProcessId());
                Iterator iter = node.getProcessProxies().iterator();
                while (iter.hasNext()) {
                    TRCProcessProxy proxy = (TRCProcessProxy)iter.next();
                    if (pID != proxy.getPid()) continue;
                    ProcessMap.put(proxy, adapter);
                    break;
                }
            }
            catch (Exception e) {
                String text = UIPlugin.getResourceString("PROCESS_LAUNCH_ERRTEXT_INFO_");
                final String msg = TString.change(UIPlugin.getResourceString("PROCESS_LAUNCH_ERROR_"), "%1", trace.getClassName());
                final Status err = new Status(2, "org.eclipse.core.resources", 566, text, null);
                HyadesUIPlugin.logError((Throwable)e);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ErrorDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)msg, (IStatus)err);
                    }
                });
                return false;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public static void setAgentConfiguration(TRCAgentProxy agent, Agent a) {
        Object[] configs;
        AgentConfiguration aconfig = a.getConfiguration();
        aconfig.clear();
        if (agent.getType().equals("Profiler") && (configs = agent.getConfigurations().toArray()).length > 0) {
            TRCConfiguration config = (TRCConfiguration)configs[0];
            Vector v = new Vector();
            Object[] filters = config.getFilters().toArray();
            int idx = 0;
            while (idx < filters.length) {
                TRCFilter filter = (TRCFilter)filters[idx];
                if (filter.getActive().booleanValue()) {
                    AgentConfigurationEntry entry = new AgentConfigurationEntry();
                    if (filter.getOperation().equals("") || filter.getOperation().equals("\"\"")) {
                        entry.setName(filter.getPattern());
                        entry.setType("SETFILTER");
                        entry.setValue(filter.getMode());
                        entry.setEnabled(filter.getActive().booleanValue());
                    } else {
                        entry.setName(filter.getPattern() + ' ' + filter.getOperation());
                        entry.setType("SETMETHODFILTER");
                        entry.setValue(filter.getMode());
                        entry.setEnabled(filter.getActive().booleanValue());
                    }
                    aconfig.addEntry(entry);
                }
                ++idx;
            }
            Object[] options = config.getOptions().toArray();
            int idx2 = 0;
            while (idx2 < options.length) {
                TRCOption option = (TRCOption)options[idx2];
                AgentConfigurationEntry entry = new AgentConfigurationEntry();
                entry.setType("SETOPTION");
                entry.setName(option.getKey());
                entry.setValue(option.getValue());
                aconfig.addEntry(entry);
                ++idx2;
            }
        }
    }

    public static String getDirectoryName(String fName) {
        int i = fName.lastIndexOf(File.separatorChar);
        if (i >= 0) {
            fName = fName.substring(0, i);
        }
        return fName;
    }

    public static Enumeration getNodeConfiguration(String nodeName, int portNumber, boolean showErrorMsgs) {
        try {
            Node node = PDCoreUtil.profileConnect(nodeName, String.valueOf(portNumber), showErrorMsgs);
            if (node == null) {
                return null;
            }
            return node.listProcesses();
        }
        catch (NotConnectedException exc2) {
            exc2.printStackTrace();
            return null;
        }
    }

    public static Enumeration getNodeConfiguration(String nodeName, int portNumber) {
        return PDCoreUtil.getNodeConfiguration(nodeName, portNumber, true);
    }

    public static boolean isPathExists(String fdir) {
        File pf = new File(PDCoreUtil.getDirectoryName(fdir));
        return pf.exists();
    }

    public static boolean isZipFile(InputStream readStream) throws IOException {
        byte[] magic = new byte[2];
        return readStream.read(magic) > 1 && magic[0] == 80 && magic[1] == 75;
    }

    public static boolean isZipFile(String fileName) throws IOException {
        FileInputStream readStream = new FileInputStream(fileName);
        boolean ret = PDCoreUtil.isZipFile(readStream);
        readStream.close();
        readStream = null;
        return ret;
    }

    public static boolean createDirectoryMessage(String fDir, Shell shell) {
        File directory = new File(PDCoreUtil.getDirectoryName(fDir));
        String msg = UIPlugin.getResourceString("STR_FOLDER_CREATION_MSG");
        msg = TString.change(msg, "%1", directory.getPath());
        if (!MessageDialog.openQuestion((Shell)shell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)msg)) {
            return false;
        }
        if (!directory.mkdirs()) {
            String errMsg = UIPlugin.getResourceString("STR_ERROR_FOLDER_CREATION");
            MessageDialog.openError((Shell)shell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)errMsg);
            return false;
        }
        return true;
    }

    public static TRCAgentProxy createUniqueAgent(TRCProcessProxy processProxy, Agent agent) {
        long timeStamp = new Date().getTime();
        double time = (double)timeStamp / 1000.0;
        TRCAgentProxy agentProxy = PDCoreUtil.createAgentNoCheck(processProxy, agent, timeStamp + "");
        LoadersUtils.registerAgentInstance((TRCAgentProxy)agentProxy, (Object)agent);
        LoadersUtils.setSessionStartTime((double)time, (TRCAgentProxy)agentProxy);
        return agentProxy;
    }

    public static Node profileConnect(String host, String port, boolean showErrorMsgs) {
        String text = "";
        if ((host == null || host.trim() == "" || port == null || port.trim() == "") && showErrorMsgs) {
            text = UIPlugin.getResourceString("INVALID_HOST");
            final Status err = new Status(2, "org.eclipse.core.resources", 2, text, null);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("CONNECTION_FAIL_TEXT"), (IStatus)err);
                }
            });
            return null;
        }
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        ConnectUtil util = new ConnectUtil(host, port, store.getString("user_id"), (Application)UIPlugin.getDefault());
        int result = util.connect(showErrorMsgs);
        if (result == 0) {
            store.setValue("user_id", util.getUserId());
            return util.getNode();
        }
        return null;
    }

    public static Node profileConnect(String host, String port) {
        return PDCoreUtil.profileConnect(host, port, true);
    }

    protected static TRCAgentProxy createAgentNoCheck(TRCProcessProxy process, Agent a, String sessionId) {
        String timestamp;
        String rID = timestamp = DateFormat.getDateTimeInstance(0, 0).format(new Date());
        rID = TString.change(rID, " ", "");
        rID = TString.change(rID, ":", "");
        String agentName = process.getNode().getMonitor().getName() + "_" + process.getNode().getName() + "_" + process.getPid() + "_" + rID + "_" + sessionId + "_" + a.getName();
        agentName = TString.change(agentName, " ", "");
        String pPath = process.eResource().getURI().toString();
        Path path = new Path(pPath);
        if (path.segmentCount() > 1) {
            pPath = path.removeLastSegments(1).toString();
        }
        String fileName = agentName + "." + "trcaxmi";
        IPath filePath = new Path(pPath).append(fileName);
        URI uri = URI.createURI((String)filePath.toString());
        Resource agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        EList agExt = agDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)agDoc);
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        TRCAgentProxy agent = factory.createTRCAgentProxy();
        agent.setName(a.getName());
        if (a.getType() != null) {
            agent.setType(a.getType());
        }
        agent.setProcessProxy(process);
        TRCAgent iAgent = factory.createTRCAgent();
        iAgent.setAgentProxy(agent);
        agExt.add((Object)iAgent);
        PDCoreUtil.markModifiedResources((EObject)iAgent, true);
        if (agent.getType().equals("Profiler")) {
            if (agent.getName().equals("J2EE Request Profiler")) {
                agent.setCollectionMode(TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL);
            } else {
                TRCConfiguration config = factory.createTRCConfiguration();
                config.setName(PDCoreUtil.getFilterSetName(a));
                config.setActive(true);
                config.setAgentProxy(agent);
                agent.getConfigurations().add((Object)config);
                AgentConfiguration aconfig = a.getConfiguration();
                boolean collectHeapInfo = false;
                boolean collectHeapInstanceLevelInfo = false;
                boolean collectExecInfo = false;
                boolean collectExecInstanceLevelInfo = false;
                boolean showExecutionFlowFull = false;
                if (aconfig != null) {
                    int idx = 0;
                    while (idx < aconfig.size()) {
                        AgentConfigurationEntry entry = aconfig.getEntryAt(idx);
                        if (entry.getName().equals(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW)) {
                            showExecutionFlowFull = entry.getValue().equalsIgnoreCase("true");
                        } else if (entry.getName().equals(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_INSTANCES)) {
                            collectExecInstanceLevelInfo = entry.getValue().equalsIgnoreCase("true");
                        } else if (entry.getName().equals(IProfileLaunchConfigurationConstants.ATTR_SHOW_HEAP_INSTANCES)) {
                            collectHeapInstanceLevelInfo = entry.getValue().equalsIgnoreCase("true");
                        } else if (entry.getType().equals("SETFILTER")) {
                            TRCFilter filter = factory.createTRCFilter();
                            filter.setMode(entry.getValue());
                            filter.setOperation("");
                            filter.setPattern(entry.getName());
                            filter.setType(entry.getValue());
                            filter.setActive(new Boolean(entry.isEnabled()));
                            filter.setConfiguration(config);
                        } else if (entry.getType().equals("SETMETHODFILTER")) {
                            String criteria = entry.getName();
                            int offset = criteria.indexOf(32);
                            if (offset > 0) {
                                TRCFilter filter = factory.createTRCFilter();
                                filter.setMode(entry.getValue());
                                filter.setPattern(criteria.substring(0, offset));
                                filter.setOperation(criteria.substring(offset + 1, criteria.length()));
                                filter.setType(entry.getValue());
                                filter.setActive(new Boolean(entry.isEnabled()));
                                filter.setConfiguration(config);
                            }
                        } else if (entry.getType().equals("SETOPTION")) {
                            TRCOption opt = factory.createTRCOption();
                            opt.setKey(entry.getName());
                            opt.setValue(entry.getValue());
                            opt.setConfiguration(config);
                            if (entry.getName().equals("TRACE_MODE")) {
                                boolean bl = collectHeapInfo = !entry.getValue().equals("none") && !entry.getValue().equals("noObjectCorrelation");
                            }
                            if (entry.getName().equals("STACK_INFORMATION")) {
                                collectExecInfo = !entry.getValue().equals("none");
                            }
                        }
                        ++idx;
                    }
                }
                if (collectExecInfo) {
                    if (collectHeapInfo) {
                        if (collectHeapInstanceLevelInfo) {
                            if (showExecutionFlowFull) {
                                agent.setCollectionMode(TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL);
                            } else {
                                agent.setCollectionMode(TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL);
                            }
                        } else if (showExecutionFlowFull) {
                            agent.setCollectionMode(TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL);
                        } else {
                            agent.setCollectionMode(TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL);
                        }
                    } else if (!showExecutionFlowFull) {
                        agent.setCollectionMode(TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL);
                    } else if (collectExecInstanceLevelInfo) {
                        agent.setCollectionMode(TRCCollectionMode.EXECUTION_FULL_LITERAL);
                    } else {
                        agent.setCollectionMode(TRCCollectionMode.EXECUTION_NO_INSTANCES_LITERAL);
                    }
                } else if (collectHeapInstanceLevelInfo) {
                    agent.setCollectionMode(TRCCollectionMode.HEAP_FULL_LITERAL);
                } else {
                    agent.setCollectionMode(TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL);
                }
            }
        }
        if (agent.getAgent() != null) {
            agent.getAgent().setCollectionMode(agent.getCollectionMode());
        }
        iAgent.setName(agent.getName());
        iAgent.setRuntimeId(agent.getRuntimeId());
        iAgent.setType(agent.getType());
        iAgent.setCollectionMode(agent.getCollectionMode());
        return agent;
    }

    public static void markModifiedResources(EObject eObject, boolean modifiedState) {
        while (eObject != null) {
            if (eObject instanceof TRCAgent) {
                eObject.eResource().setModified(modifiedState);
                eObject = ((TRCAgent)eObject).getAgentProxy().getProcessProxy();
                continue;
            }
            if (eObject instanceof TRCAgentProxy) {
                eObject.eResource().setModified(modifiedState);
                eObject = ((TRCAgentProxy)eObject).getProcessProxy().getNode();
                continue;
            }
            if (eObject instanceof TRCProcessProxy) {
                eObject.eResource().setModified(modifiedState);
                eObject = ((TRCProcessProxy)eObject).getNode();
                continue;
            }
            if (eObject instanceof TRCNode) {
                eObject.eResource().setModified(modifiedState);
                eObject = ((TRCNode)eObject).getMonitor();
                continue;
            }
            if (!(eObject instanceof TRCMonitor)) break;
            eObject.eResource().setModified(modifiedState);
            break;
        }
    }

    private static void addDefaultOptionsData(Agent a, Vector optionsList) {
        AgentConfiguration config = a.getConfiguration();
        int idx = 0;
        while (idx < optionsList.size()) {
            config.addEntry((AgentConfigurationEntry)optionsList.elementAt(idx));
            ++idx;
        }
    }

    private static void addDefaultProfileData(Agent a, ArrayList filtersList) {
        AgentConfiguration config = a.getConfiguration();
        int idx = 0;
        while (idx < filtersList.size()) {
            FilterTableElement elem = (FilterTableElement)filtersList.get(idx);
            AgentConfigurationEntry entry = new AgentConfigurationEntry();
            if (elem.getMethod().equals("")) {
                entry.setName(elem.getText());
                entry.setType("SETFILTER");
            } else {
                entry.setName(elem.getText() + ' ' + elem.getMethod());
                entry.setType("SETMETHODFILTER");
            }
            entry.setValue(elem.getVisibility().equals(UIPlugin.getResourceString("STR_INCLUDE")) ? "INCLUDE" : "EXCLUDE");
            entry.setEnabled(true);
            config.addEntry(entry);
            ++idx;
        }
    }

    private static void setAgent(TRCAgentProxy agent, Process process, PIProcessListener listener) {
        Agent a = AgentFactory.createAgent((Process)process, (String)agent.getName(), (String)agent.getType());
        a.addAgentListener((AgentListener)listener);
        PDCoreUtil.setAgentConfiguration(agent, a);
    }

    private static void setEnvironmentVariable(Process process, String[] envVariables, PIProcessListener listener) {
        if (envVariables != null && process != null) {
            int i = 0;
            while (i < envVariables.length) {
                try {
                    StringTokenizer tok = new StringTokenizer(envVariables[i], "=");
                    String name = tok.nextToken();
                    String value = tok.nextToken();
                    process.addEnvironmentVariable(new Variable(name, value));
                    listener.getProcessVariableList().add(new Variable(name, value));
                }
                catch (Exception e) {
                    HyadesUIPlugin.logError((Throwable)e);
                }
                ++i;
            }
        }
    }

    public static void copyAgentProperties(TRCAgentProxy fAgentOld, TRCAgentProxy fAgent) {
        fAgent.setCollectionMode(fAgentOld.getCollectionMode());
        fAgent.setProfileFile(fAgentOld.getProfileFile());
        fAgent.getConfigurations().clear();
        Iterator iter = fAgentOld.getConfigurations().iterator();
        while (iter.hasNext()) {
            TRCConfiguration configuration = (TRCConfiguration)iter.next();
            fAgent.getConfigurations().add((Object)EcoreUtil.copy((EObject)configuration));
        }
        TRCProcessProxy process = fAgent.getProcessProxy();
        TRCNode node = process.getNode();
        PDCoreUtil.sendConfigurationToAgent(fAgent, node.getName(), process.getPid());
    }

    private static void sendConfigurationToAgent(TRCAgentProxy agent, String host, int processId) {
        block4: {
            Node node = PDCoreUtil.profileConnect(host, String.valueOf(agent.getProcessProxy().getNode().getPort()));
            if (node == null) {
                return;
            }
            Process p = node.getProcess(String.valueOf(processId));
            if (p == null) break block4;
            try {
                Agent a = p.getAgent(agent.getName());
                a.setProfileFile(agent.getProfileFile());
                PDCoreUtil.setAgentConfiguration(agent, a);
                if (a != null && a.isActive()) {
                    a.publishConfiguration();
                    CustomCommand command = new CustomCommand();
                    command.setData("APPLYFILTERS");
                    a.invokeCustomCommand(command);
                }
            }
            catch (InactiveAgentException aex) {}
        }
    }

    private static void switchPerspective() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    boolean shouldSwitch = HyadesUIPlugin.getInstance().openPerspectiveSwitchDialog(window.getShell(), "org.eclipse.hyades.trace.internal.ui.tracePerspective", UIPlugin.getDefault().getPreferenceStore(), "switch_to_perspective", UIPlugin.getResourceString("CONFIRM_PERSP_SWITCH_MSG"));
                    if (shouldSwitch) {
                        UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                    }
                    if ("org.eclipse.hyades.trace.internal.ui.tracePerspective".equals(window.getActivePage().getPerspective().getId())) {
                        PDProjectExplorer nav = (PDProjectExplorer)UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                        nav.getViewer().refresh();
                    }
                }
                catch (Exception exc) {
                    HyadesUIPlugin.logError((Throwable)exc);
                }
            }
        });
    }

    private static String getFilterSetName(Agent a) {
        AgentConfiguration conf = a.getConfiguration();
        int i = 0;
        while (i < conf.size()) {
            AgentConfigurationEntry e = conf.getEntryAt(i);
            if (IProfileLaunchConfigurationConstants.ATTR_FILTER_SET.equals(e.getName())) {
                return e.getValue();
            }
            ++i;
        }
        return UIPlugin.getResourceString(TraceConstants.DEFAULT_FILTER_SET);
    }
}

