/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.Iterator;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.hyades.trace.ui.internal.wizard.ProfileSetWizardPage1;
import org.eclipse.hyades.trace.ui.internal.wizard.ProfileSetWizardPage2;
import org.eclipse.hyades.trace.ui.internal.wizard.ProfileSetWizardPage3;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;

public abstract class ProfileSetWizard
extends Wizard {
    private ProfileSetWizardPage1 wizPage1;
    private ProfileSetWizardPage2 wizPage2;
    private ProfileSetWizardPage3 wizPage3;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private ProfilingSetsManagerCopy original;
    private ProfilingSetsManagerCopy copy;
    private String _name;
    private IProfilingSet set;
    private TraceProfileOverviewUI _overviewUI;

    public ProfileSetWizard(TraceProfileOverviewUI overviewUI) {
        this.original = overviewUI.getManagerCopy();
        this.copy = this.original.createCopy();
        this._overviewUI = overviewUI;
    }

    public void initializeSet(IProfilingSet profilingSet) {
        this.set = profilingSet;
        this.setProfileSName(this.set.getName());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    protected abstract String getSetId();

    private void setProfileSName(String name) {
        this._name = name;
        if (this.getSetId() == null) {
            this.set.setId(this._name);
        } else {
            this.set.setId(this.getSetId());
        }
        this.set.setName(this._name);
        this.copy.getProfilingSets().put(this.set.getId(), this.set);
        this.copy.setDefaultSet(this.set);
    }

    public boolean profileNameExists(String name) {
        if (this._name != null && name.equals(this._name.trim())) {
            return false;
        }
        Iterator iter = this.copy.getProfilingSets().values().iterator();
        Object otherSetName = null;
        while (iter.hasNext()) {
            if (!name.equals(((IProfilingSet)iter.next()).getName().trim())) continue;
            return true;
        }
        return false;
    }

    public void setProfileSetName(String name) {
        this.copy.getProfilingSets().remove(this.set.getId());
        this.setProfileSName(name);
    }

    public void setProfileSetDescription(String description) {
        this.set.setDescription(description);
    }

    public void setNameToPages() {
        this.wizPage2.setProfilingSetName(this.set.getName());
    }

    public boolean performFinish() {
        this.original.resetFrom(this.copy);
        this.original.applyChanges();
        this._overviewUI.dataChanged();
        this._overviewUI.getTableViewer().refresh(true);
        this._overviewUI.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)this.set));
        return true;
    }

    public ProfilingSetsManagerCopy getProfilingSetsManagerCopy() {
        return this.copy;
    }

    public void addPages() {
        super.addPages();
        this.wizPage1 = new ProfileSetWizardPage1("name", this.set.getName(), this.set.getDescription(), this.copy);
        this.wizPage1.setTitle(UIPlugin.getResourceString("STR_ADD_PROFILINGSET_NAME_DLG"));
        this.wizPage1.setDescription(UIPlugin.getResourceString("STR_ADD_PROFILINGSET_NAME_DESC"));
        this.addPage((IWizardPage)this.wizPage1);
        this.wizPage2 = new ProfileSetWizardPage2("profilingTypes", this.set.getName(), this.copy, this._overviewUI);
        this.wizPage2.setTitle(UIPlugin.getResourceString("STR_EDIT_PROFILINGSET_DLG"));
        this.wizPage2.setDescription(UIPlugin.getResourceString("STR_EDIT_PROFILINGSET_DESC"));
        this.addPage((IWizardPage)this.wizPage2);
        this.wizPage3 = new ProfileSetWizardPage3("filters", this._overviewUI);
        this.wizPage3.setTitle(UIPlugin.getResourceString("STR_EDIT_FILTERSET_DLG"));
        this.wizPage3.setDescription(UIPlugin.getResourceString("STR_EDIT_FILTERSET_DESC"));
        this.addPage((IWizardPage)this.wizPage3);
    }
}

