/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.BasicFrame;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.TimeEvent;
import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.preferences.SDViewPref;
import org.eclipse.hyades.uml2sd.util.TimeEventComparator;

public class Frame
extends BasicFrame {
    protected Lifeline highlightLifeline = null;
    protected int startEvent = 0;
    protected int nbEvent = 0;
    protected IColor highlightColor = null;
    protected List executionOccurrencesWithTime;
    protected LifelineCategories[] lifelineCategories = null;

    protected List getLifelines() {
        return (List)this.nodes.get("Lifeline");
    }

    public int lifeLinesCount() {
        List lifelines = this.getLifelines();
        if (lifelines != null) {
            return lifelines.size();
        }
        return 0;
    }

    public Lifeline getLifeline(int index) {
        if (this.getLifelines() != null && index >= 0 && index < this.lifeLinesCount()) {
            return (Lifeline)this.getLifelines().get(index);
        }
        return null;
    }

    protected List getSyncMessages() {
        return (List)this.nodes.get("SyncMessage");
    }

    public Object[] getSyncMessagesArray() {
        return this.getSyncMessages().toArray();
    }

    public int syncMessageCount() {
        if (this.getSyncMessages() != null) {
            return this.getSyncMessages().size();
        }
        return 0;
    }

    public SyncMessage getSyncMessage(int index) {
        if (this.getSyncMessages() != null && index >= 0 && index < this.getSyncMessages().size()) {
            return (SyncMessage)this.getSyncMessages().get(index);
        }
        return null;
    }

    protected List getAsyncMessages() {
        return (List)this.nodes.get("AsyncMessage");
    }

    public int asyncMessageCount() {
        if (this.getAsyncMessages() != null) {
            return this.getAsyncMessages().size();
        }
        return 0;
    }

    public AsyncMessage getAsyncMessage(int index) {
        if (this.getAsyncMessages() != null && index >= 0 && index < this.getAsyncMessages().size()) {
            return (AsyncMessage)this.getAsyncMessages().get(index);
        }
        return null;
    }

    protected List getSyncMessagesReturn() {
        return (List)this.nodes.get("SyncMessageRet");
    }

    public Object[] getSyncMessagesReturnArray() {
        return this.getSyncMessagesReturn().toArray();
    }

    public int syncMessageReturnCount() {
        if (this.getSyncMessagesReturn() != null) {
            return this.getSyncMessagesReturn().size();
        }
        return 0;
    }

    public SyncMessageReturn getSyncMessageReturn(int index) {
        if (this.getSyncMessagesReturn() != null && index >= 0 && index < this.getSyncMessagesReturn().size()) {
            return (SyncMessageReturn)this.getSyncMessagesReturn().get(index);
        }
        return null;
    }

    protected List getAsyncMessagesReturn() {
        return (List)this.nodes.get("AsyncMessageRet");
    }

    public int asyncMessageReturnCount() {
        if (this.getAsyncMessagesReturn() != null) {
            return this.getAsyncMessagesReturn().size();
        }
        return 0;
    }

    public AsyncMessageReturn getAsyncMessageReturn(int index) {
        if (this.getAsyncMessagesReturn() != null && index >= 0 && index < this.getAsyncMessagesReturn().size()) {
            return (AsyncMessageReturn)this.getAsyncMessagesReturn().get(index);
        }
        return null;
    }

    public void addLifeLine(Lifeline lifeLine) {
        this.computeMinMax = true;
        if (lifeLine == null) {
            return;
        }
        lifeLine.setFrame(this);
        lifeLine.setIndex(this.getNewHorizontalIndex());
        if (lifeLine.hasTimeInfo()) {
            this.timeInfo = true;
        }
        this.addNode(lifeLine);
    }

    public int getFirstVisibleLifeline() {
        if (this.indexes.get("Lifeline") != null) {
            return (Integer)this.indexes.get("Lifeline");
        }
        return 0;
    }

    public int getFirstVisibleSyncMessage() {
        if (this.indexes.get("SyncMessage") != null) {
            return (Integer)this.indexes.get("SyncMessage");
        }
        return 0;
    }

    public int getFirstVisibleSyncMessageReturn() {
        if (this.indexes.get("SyncMessageRet") != null) {
            return (Integer)this.indexes.get("SyncMessageRet");
        }
        return 0;
    }

    public int getFirstVisibleAsyncMessage() {
        if (this.indexes.get("AsyncMessage") != null) {
            return (Integer)this.indexes.get("AsyncMessage");
        }
        return 0;
    }

    public int getFirstVisibleAsyncMessageReturn() {
        if (this.indexes.get("AsyncMessageRet") != null) {
            return (Integer)this.indexes.get("AsyncMessageRet");
        }
        return 0;
    }

    public List getExecutionOccurrencesWithTime() {
        return this.executionOccurrencesWithTime;
    }

    public void insertLifelineAfter(Lifeline toInsert, Lifeline after) {
        int removePoint;
        if (toInsert == null) {
            return;
        }
        if (toInsert == after) {
            return;
        }
        int insertPoint = 0;
        if (after != null) {
            insertPoint = after.getIndex();
        }
        if ((removePoint = toInsert.getIndex() - 1) >= insertPoint) {
            this.getLifelines().remove(removePoint);
        }
        this.getLifelines().add(insertPoint, toInsert);
        if (removePoint < insertPoint) {
            this.getLifelines().remove(removePoint);
        }
        if (removePoint >= insertPoint) {
            toInsert.setIndex(insertPoint + 1);
        } else {
            toInsert.setIndex(insertPoint - 1);
        }
        if (removePoint >= ++insertPoint) {
            int i = insertPoint;
            while (i < this.getLifelines().size()) {
                this.getLifeline(i).setIndex(i + 1);
                ++i;
            }
        } else {
            int i = 0;
            while (i < insertPoint && i < this.getLifelines().size()) {
                this.getLifeline(i).setIndex(i + 1);
                ++i;
            }
        }
    }

    public void insertLifelineBefore(Lifeline toInsert, Lifeline before) {
        int removePoint;
        if (toInsert == null) {
            return;
        }
        if (toInsert == before) {
            return;
        }
        int insertPoint = 0;
        if (before != null) {
            insertPoint = before.getIndex() - 1;
        }
        if ((removePoint = toInsert.getIndex() - 1) >= insertPoint) {
            this.getLifelines().remove(removePoint);
        }
        this.getLifelines().add(insertPoint, toInsert);
        if (removePoint < insertPoint) {
            this.getLifelines().remove(removePoint);
        }
        if (removePoint >= insertPoint) {
            toInsert.setIndex(insertPoint + 1);
        } else {
            toInsert.setIndex(insertPoint - 1);
        }
        if (removePoint >= ++insertPoint) {
            int i = insertPoint;
            while (i < this.getLifelines().size()) {
                this.getLifeline(i).setIndex(i + 1);
                ++i;
            }
        } else {
            int i = 0;
            while (i < insertPoint && i < this.getLifelines().size()) {
                this.getLifeline(i).setIndex(i + 1);
                ++i;
            }
        }
    }

    public Lifeline getCloserLifeline(int x) {
        int dist3;
        Lifeline node3;
        int index = (x - 10 + 23) / Metrics.swimmingLaneWidth() - 1;
        if (index < 0) {
            index = 0;
        }
        if (index >= this.getLifelines().size()) {
            index = this.getLifelines().size() - 1;
        }
        Lifeline node2 = node3 = this.getLifeline(index);
        Lifeline node1 = node3;
        int dist2 = dist3 = Math.abs(node1.getX() + node1.getWidth() / 2 - x);
        int dist1 = dist3;
        if (index > 0) {
            node2 = this.getLifeline(index - 1);
            dist2 = Math.abs(node2.getX() + node2.getWidth() / 2 - x);
        }
        if (index < this.getLifelines().size() - 1) {
            node3 = this.getLifeline(index + 1);
            dist3 = Math.abs(node3.getX() + node3.getWidth() / 2 - x);
        }
        if (dist1 <= dist2 && dist1 <= dist3) {
            return node1;
        }
        if (dist2 <= dist1 && dist2 <= dist3) {
            return node2;
        }
        return node3;
    }

    public void reorder(ArrayList list) {
        int i = 0;
        while (i < list.size()) {
            Lifeline[] temp;
            if (list.get(i) instanceof Lifeline[] && (temp = (Lifeline[])list.get(i)).length == 2) {
                if (temp[1] == null) {
                    this.insertLifelineAfter(temp[0], this.getLifeline(this.lifeLinesCount() - 1));
                } else {
                    this.insertLifelineBefore(temp[0], temp[1]);
                }
            }
            ++i;
        }
    }

    public void resetTimeCompression() {
        this.highlightLifeline = null;
        this.startEvent = 0;
        this.nbEvent = 0;
        this.highlightColor = null;
    }

    protected void computeMinMax() {
        List timeArray = this.buildTimeArray();
        int i = 0;
        while (i < timeArray.size() - 1) {
            block8: {
                TimeEvent m2;
                TimeEvent m1;
                block7: {
                    m1 = (TimeEvent)timeArray.get(i);
                    m2 = (TimeEvent)timeArray.get(i + 1);
                    if (!SDViewPref.getInstance().excludeExternalTime() || !(m1.getGraphNode() instanceof BaseMessage) || !(m2.getGraphNode() instanceof BaseMessage)) break block7;
                    BaseMessage mes1 = (BaseMessage)((Object)m1.getGraphNode());
                    BaseMessage mes2 = (BaseMessage)((Object)m2.getGraphNode());
                    if (mes2.startLifeline == null || mes1.endLifeline == null) break block8;
                }
                if (this.computeMinMax) {
                    this.maxTime = this.minTime = m2.getTime() - m1.getTime();
                    this.computeMinMax = false;
                }
                if (m2.getTime() - m1.getTime() < this.minTime) {
                    this.minTime = m2.getTime() - m1.getTime();
                }
                if (m2.getTime() - m1.getTime() > this.maxTime) {
                    this.maxTime = m2.getTime() - m1.getTime();
                }
            }
            ++i;
        }
    }

    public boolean findDateBounds(double dateToFind, ITimeRange[] bounds) {
        if (this.hasTimeInfo()) {
            List timeArray = this.buildTimeArray();
            bounds[0] = null;
            bounds[1] = null;
            int i = 0;
            while (i < timeArray.size()) {
                TimeEvent m = (TimeEvent)timeArray.get(i);
                if (m.getTime() > dateToFind) {
                    bounds[1] = m.getGraphNode();
                    if (i > 0) {
                        bounds[0] = ((TimeEvent)timeArray.get(i - 1)).getGraphNode();
                        return true;
                    }
                    return false;
                }
                ++i;
            }
            bounds[0] = ((TimeEvent)timeArray.get(timeArray.size() - 1)).getGraphNode();
        }
        return false;
    }

    protected void setHasTimeInfo(boolean value) {
        this.timeInfo = value;
    }

    public boolean hasTimeInfo() {
        return this.timeInfo;
    }

    public void highlightTimeCompression(Lifeline lifeline, int startEvent, int nbEvent, IColor color) {
        this.highlightLifeline = lifeline;
        this.startEvent = startEvent;
        this.nbEvent = nbEvent;
        this.highlightColor = color;
    }

    public void setLifelineCategories(LifelineCategories[] categories) {
        this.lifelineCategories = categories;
    }

    public LifelineCategories[] getLifelineCategories() {
        return this.lifelineCategories;
    }

    public void addMessage(BaseMessage message) {
        this.addNode(message);
    }

    public void draw(IGC context) {
        int lifeLineDrawIndex;
        this.drawFrame(context);
        if (this.highlightLifeline != null) {
            int lifeLineDrawIndex2 = (Integer)this.indexes.get("Lifeline");
            IColor backupColor = context.getBackground();
            context.setBackground(Frame.getUserPref().getTimeCompressionSelectionColor());
            int gy = this.highlightLifeline.getY() + this.highlightLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.startEvent;
            context.fillRectangle(11, gy, this.highlightLifeline.getX() + Metrics.getLifelineWidth() / 2 - 10, (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.nbEvent);
            context.setBackground(backupColor);
        }
        super.draw(context, false);
        int lifelineArryStep = 1;
        if ((float)Metrics.swimmingLaneWidth() * context.getZoom() < 10.0f) {
            lifelineArryStep = Math.round(10.0f / ((float)Metrics.swimmingLaneWidth() * context.getZoom()));
        }
        if (this.indexes.size() == 0) {
            return;
        }
        int i = lifeLineDrawIndex = ((Integer)this.indexes.get("Lifeline")).intValue();
        while (i < ((List)this.nodes.get("Lifeline")).size()) {
            Lifeline toDraw = (Lifeline)((List)this.nodes.get("Lifeline")).get(i);
            if (toDraw.getX() - 22 > context.getContentsX() + context.getVisibleWidth()) break;
            toDraw.drawName(context);
            if (this.highlightLifeline != null) {
                if (toDraw == this.highlightLifeline) {
                    toDraw.highlightExecOccurrenceRegion(context, this.startEvent, this.nbEvent, this.highlightColor);
                } else if (toDraw.getIndex() < this.highlightLifeline.getIndex() || toDraw.getIndex() < this.highlightLifeline.getIndex()) {
                    int acIndex;
                    int index = acIndex = toDraw.getExecOccurrenceDrawIndex();
                    while (index < toDraw.getExecutions().size()) {
                        BasicExecutionOccurrence exec = (BasicExecutionOccurrence)toDraw.getExecutions().get(index);
                        int tempEvent = this.startEvent;
                        int j = 0;
                        while (j < this.nbEvent) {
                            if (tempEvent >= exec.startOccurrence && tempEvent <= exec.endOccurrence && tempEvent + 1 >= exec.startOccurrence && tempEvent + 1 <= exec.endOccurrence) {
                                toDraw.highlightExecOccurrenceRegion(context, tempEvent, 1, Frame.getUserPref().getTimeCompressionSelectionColor());
                            }
                            ++tempEvent;
                            ++j;
                        }
                        if (exec.getY() > this.getY()) break;
                        ++index;
                    }
                }
            }
            i += lifelineArryStep;
        }
    }

    protected List buildTimeArray() {
        try {
            Object[] temp;
            List<Object> timeArray = super.buildTimeArray();
            this.executionOccurrencesWithTime = null;
            if (this.getLifelines() != null) {
                int i = 0;
                while (i < ((List)this.nodes.get("Lifeline")).size()) {
                    Lifeline l = (Lifeline)((List)this.nodes.get("Lifeline")).get(i);
                    if (l.hasTimeInfo()) {
                        Iterator j = l.executionOccurrences.iterator();
                        while (j.hasNext()) {
                            ExecutionOccurrence eo;
                            Object o = j.next();
                            if (!(o instanceof ExecutionOccurrence) || !(eo = (ExecutionOccurrence)o).hasTimeInfo()) continue;
                            int event = eo.getStartOccurrence();
                            double time = eo.getFirstTime();
                            TimeEvent f = new TimeEvent(time, event, eo);
                            timeArray.add(f);
                            if (this.executionOccurrencesWithTime == null) {
                                this.executionOccurrencesWithTime = new ArrayList();
                            }
                            this.executionOccurrencesWithTime.add(f);
                            event = eo.getEndOccurrence();
                            time = eo.getLastTime();
                            f = new TimeEvent(time, event, eo);
                            timeArray.add(f);
                            this.executionOccurrencesWithTime.add(f);
                        }
                    }
                    ++i;
                }
            }
            if (this.executionOccurrencesWithTime != null) {
                temp = this.executionOccurrencesWithTime.toArray();
                Arrays.sort(temp, new TimeEventComparator());
                this.executionOccurrencesWithTime = Arrays.asList(temp);
            }
            temp = timeArray.toArray();
            Arrays.sort(temp, new TimeEventComparator());
            timeArray = Arrays.asList(temp);
            return timeArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected GraphNode getCloserLeavingMessage(Lifeline lifeline, BaseMessage message, List list, boolean smallerEvent) {
        if (list == null) {
            return null;
        }
        if (!smallerEvent) {
            int event = 0;
            if (message != null) {
                event = message.getEventOccurrence();
            }
            int i = 0;
            while (i < list.size()) {
                AsyncMessage asyncNode;
                SyncMessage syncNode;
                GraphNode node = (GraphNode)list.get(i);
                if (node instanceof SyncMessage ? (syncNode = (SyncMessage)node).getEventOccurrence() > event && syncNode.getStartLifeline() == lifeline && !syncNode.isSameAs(message) : node instanceof AsyncMessage && (asyncNode = (AsyncMessage)node).getStartOccurrence() > event && asyncNode.getStartLifeline() == lifeline && !asyncNode.isSameAs(message)) {
                    return node;
                }
                ++i;
            }
        } else {
            int event = this.getMaxEventOccurrence();
            if (message != null) {
                event = message instanceof AsyncMessage ? ((AsyncMessage)message).getStartOccurrence() : message.getEventOccurrence();
            }
            int i = list.size() - 1;
            while (i >= 0) {
                AsyncMessage asyncNode;
                SyncMessage syncNode;
                GraphNode node = (GraphNode)list.get(i);
                if (node instanceof SyncMessage ? (syncNode = (SyncMessage)node).getEventOccurrence() < event && syncNode.getStartLifeline() == lifeline && !syncNode.isSameAs(message) : node instanceof AsyncMessage && (asyncNode = (AsyncMessage)node).getStartOccurrence() < event && asyncNode.getStartLifeline() == lifeline && !asyncNode.isSameAs(message)) {
                    return node;
                }
                --i;
            }
        }
        return null;
    }

    protected GraphNode getCloserEnteringMessage(Lifeline lifeline, BaseMessage message, List list, boolean smallerEvent) {
        if (list == null) {
            return null;
        }
        if (!smallerEvent) {
            int event = 0;
            if (message != null) {
                event = message.getEventOccurrence();
            }
            int i = 0;
            while (i < list.size()) {
                AsyncMessage asyncNode;
                SyncMessage syncNode;
                GraphNode node = (GraphNode)list.get(i);
                if (node instanceof SyncMessage ? (syncNode = (SyncMessage)node).getEventOccurrence() > event && syncNode.getEndLifeline() == lifeline && !syncNode.isSameAs(message) : node instanceof AsyncMessage && (asyncNode = (AsyncMessage)node).getStartOccurrence() > event && asyncNode.getEndLifeline() == lifeline && !asyncNode.isSameAs(message)) {
                    return node;
                }
                ++i;
            }
        } else {
            int event = this.getMaxEventOccurrence();
            if (message != null) {
                event = message instanceof AsyncMessage ? ((AsyncMessage)message).getStartOccurrence() : message.getEventOccurrence();
            }
            int i = list.size() - 1;
            while (i >= 0) {
                AsyncMessage asyncNode;
                SyncMessage syncNode;
                GraphNode node = (GraphNode)list.get(i);
                if (node instanceof SyncMessage ? (syncNode = (SyncMessage)node).getEventOccurrence() < event && syncNode.getEndLifeline() == lifeline && !syncNode.isSameAs(message) : node instanceof AsyncMessage && (asyncNode = (AsyncMessage)node).getStartOccurrence() < event && asyncNode.getEndLifeline() == lifeline && !asyncNode.isSameAs(message)) {
                    return node;
                }
                --i;
            }
        }
        return null;
    }

    private int distanceFromEvent(GraphNode node, int event) {
        int distance = 0;
        if (node instanceof SyncMessage) {
            distance = ((SyncMessage)node).getEventOccurrence() - event;
        } else if (node instanceof AsyncMessage) {
            int end;
            int start = ((AsyncMessage)node).getStartOccurrence();
            distance = start - event < (end = ((AsyncMessage)node).getEndOccurrence()) - event ? start - event : start - event;
        }
        return Math.abs(distance);
    }

    private GraphNode getCloserToEvent(GraphNode node1, GraphNode node2, int event) {
        if (node1 != null && node2 != null) {
            if (this.distanceFromEvent(node1, event) < this.distanceFromEvent(node2, event)) {
                return node1;
            }
            return node2;
        }
        if (node1 != null) {
            return node1;
        }
        if (node2 != null) {
            return node2;
        }
        return null;
    }

    public GraphNode getCalledMessage(BaseMessage StartMessage) {
        int event = 0;
        GraphNode result = null;
        Lifeline lifeline = null;
        if (StartMessage != null) {
            event = StartMessage.getEventOccurrence();
            lifeline = StartMessage.getEndLifeline();
            if (lifeline == null) {
                lifeline = StartMessage.getStartLifeline();
            }
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode message = this.getCloserLeavingMessage(lifeline, StartMessage, this.getSyncMessages(), false);
        GraphNode messageReturn = this.getCloserLeavingMessage(lifeline, StartMessage, this.getSyncMessagesReturn(), false);
        result = this.getCloserToEvent(message, messageReturn, event);
        message = this.getCloserLeavingMessage(lifeline, StartMessage, this.getAsyncMessages(), false);
        result = this.getCloserToEvent(result, message, event);
        messageReturn = this.getCloserLeavingMessage(lifeline, StartMessage, this.getAsyncMessagesReturn(), false);
        result = this.getCloserToEvent(result, messageReturn, event);
        return result;
    }

    public GraphNode getCallerMessage(BaseMessage StartMessage) {
        int event = this.getMaxEventOccurrence();
        GraphNode result = null;
        Lifeline lifeline = null;
        if (StartMessage != null) {
            event = StartMessage.getEventOccurrence();
            lifeline = StartMessage.getStartLifeline();
            if (lifeline == null) {
                lifeline = StartMessage.getEndLifeline();
            }
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode message = this.getCloserEnteringMessage(lifeline, StartMessage, this.getSyncMessages(), true);
        GraphNode messageReturn = this.getCloserEnteringMessage(lifeline, StartMessage, this.getSyncMessagesReturn(), true);
        result = this.getCloserToEvent(message, messageReturn, event);
        message = this.getCloserEnteringMessage(lifeline, StartMessage, this.getAsyncMessages(), true);
        result = this.getCloserToEvent(result, message, event);
        messageReturn = this.getCloserEnteringMessage(lifeline, StartMessage, this.getAsyncMessagesReturn(), true);
        result = this.getCloserToEvent(result, messageReturn, event);
        return result;
    }

    public GraphNode getNextLifelineMessage(Lifeline lifeline, BaseMessage StartMessage) {
        int event = 0;
        if (StartMessage != null) {
            event = StartMessage.getEventOccurrence();
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode message = this.getCloserLeavingMessage(lifeline, StartMessage, this.getSyncMessages(), false);
        GraphNode messageReturn = this.getCloserLeavingMessage(lifeline, StartMessage, this.getSyncMessagesReturn(), false);
        GraphNode result = this.getCloserToEvent(message, messageReturn, event);
        message = this.getCloserLeavingMessage(lifeline, StartMessage, this.getAsyncMessages(), false);
        result = this.getCloserToEvent(result, message, event);
        messageReturn = this.getCloserLeavingMessage(lifeline, StartMessage, this.getAsyncMessagesReturn(), false);
        result = this.getCloserToEvent(result, messageReturn, event);
        return result;
    }

    public GraphNode getPrevLifelineMessage(Lifeline lifeline, BaseMessage StartMessage) {
        int event = this.getMaxEventOccurrence();
        if (StartMessage != null) {
            event = StartMessage instanceof AsyncMessage ? ((AsyncMessage)StartMessage).getStartOccurrence() : StartMessage.getEventOccurrence();
        }
        if (lifeline == null) {
            return null;
        }
        GraphNode message = this.getCloserLeavingMessage(lifeline, StartMessage, this.getSyncMessages(), true);
        GraphNode messageReturn = this.getCloserLeavingMessage(lifeline, StartMessage, this.getSyncMessagesReturn(), true);
        GraphNode result = this.getCloserToEvent(message, messageReturn, event);
        message = this.getCloserLeavingMessage(lifeline, StartMessage, this.getAsyncMessages(), true);
        result = this.getCloserToEvent(result, message, event);
        messageReturn = this.getCloserLeavingMessage(lifeline, StartMessage, this.getAsyncMessagesReturn(), true);
        result = this.getCloserToEvent(result, messageReturn, event);
        return result;
    }
}

