/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.load;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.WorkbenchWindow;

public class BackgroundLoader {
    private boolean debug = false;
    private static BackgroundLoader instance;
    private Thread thread;
    private IProgressMonitor monitor;
    private List taskList = new LinkedList();
    private static Image image;

    private void addTask(IRunnableWithProgress task) {
        this.taskList.add(task);
    }

    private IRunnableWithProgress getNextTask() {
        if (!this.taskList.isEmpty()) {
            return (IRunnableWithProgress)this.taskList.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRunnableWithProgress consumeTask() {
        List list = this.taskList;
        synchronized (list) {
            IRunnableWithProgress task = this.getNextTask();
            if (task != null) {
                this.taskList.remove(0);
            }
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTasks() {
        List list = this.taskList;
        synchronized (list) {
            this.taskList.clear();
        }
    }

    public static synchronized BackgroundLoader getInstance() {
        if (instance == null) {
            instance = new BackgroundLoader();
        }
        return instance;
    }

    public synchronized void newTask(IRunnableWithProgress task) {
        this.addTask(task);
        if (this.debug) {
            System.err.println("newTask(): Adding " + task);
        }
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    IRunnableWithProgress task = BackgroundLoader.this.getNextTask();
                    if (BackgroundLoader.this.debug) {
                        // empty if block
                    }
                    while (task != null) {
                        Object var4_3;
                        try {
                            try {
                                BackgroundLoader.this.cancelIt(false);
                                this.runIt(task);
                                BackgroundLoader.this.consumeTask();
                                BackgroundLoader.this.cancelIt(false);
                            }
                            catch (Exception e) {
                                BackgroundLoader.this.clearTasks();
                                BackgroundLoader.this.cancelIt(true);
                                if (BackgroundLoader.this.debug) {
                                    e.printStackTrace();
                                }
                                var4_3 = null;
                            }
                            var4_3 = null;
                        }
                        catch (Throwable throwable) {
                            var4_3 = null;
                            throw throwable;
                        }
                        task = BackgroundLoader.this.getNextTask();
                        if (!BackgroundLoader.this.debug) continue;
                    }
                }

                private void runIt(IRunnableWithProgress task) throws InvocationTargetException, InterruptedException {
                    task.run(BackgroundLoader.this.monitor);
                }
            });
            this.thread.setName("Sequence Diagram Background Loader");
            this.thread.start();
        } else {
            this.cancelIt(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelIt(boolean b) {
        IProgressMonitor iProgressMonitor = this.monitor;
        synchronized (iProgressMonitor) {
            this.monitor.setCanceled(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSubsequentTask(IRunnableWithProgress task) {
        this.addTask(task);
        if (this.getNextTask() == task) {
            if (this.debug) {
                System.err.println("newSubsequentTask(): Calling newTask because no current task is executed");
            }
            this.newTask(task);
        } else {
            BackgroundLoader backgroundLoader = this;
            synchronized (backgroundLoader) {
                if (this.debug) {
                    System.err.println("newSubsequentTask(): Adding " + task);
                }
            }
        }
    }

    public synchronized void cancelTask() {
        this.cancelIt(true);
        if (this.thread.isAlive()) {
            this.thread.destroy();
        }
        this.clearTasks();
    }

    public static void shutdown() {
        if (instance != null && BackgroundLoader.instance.monitor != null && !BackgroundLoader.instance.monitor.isCanceled()) {
            BackgroundLoader.instance.monitor.setCanceled(true);
        }
        instance = null;
        image.dispose();
    }

    private BackgroundLoader() {
        this.monitor = new CancelProgressMonitor();
    }

    static /* synthetic */ Image access$700() {
        return image;
    }

    static {
        image = SDViewerPlugin.getResourceImage("sequencediagram_co.gif").createImage();
    }

    public class CancelProgressMonitor
    implements IProgressMonitor {
        private volatile boolean canceled = false;
        private volatile String taskName;

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean canceled_) {
            this.canceled = canceled_;
            if (canceled_ && this.taskName != null && BackgroundLoader.this.debug) {
                System.err.println("Canceled task \"" + this.taskName + "\"");
            }
        }

        public void beginTask(String name, int totalWork) {
            this.setTaskName(name);
            if (BackgroundLoader.this.debug) {
                System.err.println("Starting task \"" + this.taskName + "\"...");
            }
        }

        public void done() {
            if (BackgroundLoader.this.debug) {
                System.err.println((this.canceled ? "Done normally " : "Done with canceled ") + "task \"" + this.taskName + "\"");
            }
            this.setTaskName(null);
        }

        public void internalWorked(double work) {
        }

        public void setTaskName(String name) {
            this.taskName = name;
            Display.getDefault().syncExec(new Runnable(this){
                private final /* synthetic */ CancelProgressMonitor this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    block2: {
                        try {
                            StatusLineManager stm = ((WorkbenchWindow)SDViewerPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()).getStatusLineManager();
                            stm.setMessage((Image)(CancelProgressMonitor.access$600(this.this$1) != null ? BackgroundLoader.access$700() : null), CancelProgressMonitor.access$600(this.this$1));
                        }
                        catch (Exception e) {
                            if (!BackgroundLoader.access$100(CancelProgressMonitor.access$800(this.this$1))) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            });
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }

        static /* synthetic */ String access$600(CancelProgressMonitor x0) {
            return x0.taskName;
        }

        static /* synthetic */ BackgroundLoader access$800(CancelProgressMonitor x0) {
            return x0.BackgroundLoader.this;
        }
    }
}

