/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.hyades.statistical.ui.editor.internal.ZipStringBuffer;

public class ColumnPrinter {
    private int header_rowcount = 1;
    private int column_count = 0;
    private String[][] headers = new String[this.column_count][this.header_rowcount];
    private ZipStringBuffer[] columns = new ZipStringBuffer[this.column_count];
    private String cell_prefix = "";
    private String cell_postfix = "";
    private String cell_empty = "";

    private int getHeaderRowCount() {
        return this.header_rowcount;
    }

    private int getColumnCount() {
        return this.column_count;
    }

    private void addHeaderRow() {
        int i = 0;
        while (i < this.column_count) {
            String[] tmp = new String[this.header_rowcount + 1];
            if (this.headers[i].length > 0) {
                System.arraycopy(this.headers[i], 0, tmp, 1, this.header_rowcount);
            }
            this.headers[i] = tmp;
            ++i;
        }
        ++this.header_rowcount;
    }

    public void setHeaderText(int col, int row, String val) {
        while (this.getHeaderRowCount() <= row) {
            this.addHeaderRow();
        }
        while (this.getColumnCount() <= col) {
            this.addColumn();
        }
        this.headers[col][this.header_rowcount - ++row] = val;
    }

    private void addColumn() {
        String[][] tmp = new String[this.column_count + 1][this.header_rowcount];
        System.arraycopy(this.headers, 0, tmp, 0, this.column_count);
        this.headers = tmp;
        ZipStringBuffer[] tmp2 = new ZipStringBuffer[this.column_count + 1];
        System.arraycopy(this.columns, 0, tmp2, 0, this.column_count);
        this.columns = tmp2;
        ++this.column_count;
    }

    public void setColumnText(int col, String val) {
        while (this.getColumnCount() <= col) {
            this.addColumn();
        }
        this.columns[col] = new ZipStringBuffer(val);
    }

    public void appendColumnText(int col, String val) {
        while (this.getColumnCount() <= col) {
            this.addColumn();
        }
        if (this.columns[col] == null) {
            this.setColumnText(col, val);
        } else {
            this.columns[col].append(val);
        }
    }

    public void setCellPrefix(String val) {
        this.cell_prefix = val;
    }

    public void setCellPostfix(String val) {
        this.cell_postfix = val;
    }

    public void setCellEmpty(String val) {
        this.cell_empty = val;
    }

    public void printTo(OutputStream out) throws IOException {
        byte[] prefix = this.cell_prefix.getBytes();
        byte[] postfix = this.cell_postfix.getBytes();
        byte[] empty = this.cell_empty.getBytes();
        int r = 0;
        while (r < this.header_rowcount) {
            int c = 0;
            while (c < this.column_count) {
                out.write(prefix);
                if (this.headers[c][r] != null) {
                    out.write(this.headers[c][r].getBytes());
                } else {
                    out.write(empty);
                }
                out.write(postfix);
                ++c;
            }
            out.write(13);
            out.write(10);
            ++r;
        }
        boolean moreToGo = true;
        int[] indexes = new int[this.column_count];
        Arrays.fill(indexes, 0);
        StringBuffer row = new StringBuffer();
        while (moreToGo) {
            moreToGo = false;
            row.setLength(0);
            int c = 0;
            while (c < this.column_count) {
                row.append(this.cell_prefix);
                if (indexes[c] != -1) {
                    if (this.columns[c] != null) {
                        int index = this.indexOf(this.columns[c], '\n', indexes[c]);
                        if (index == -1) {
                            row.append(this.columns[c].substring(indexes[c]));
                            indexes[c] = -1;
                        } else {
                            row.append(this.columns[c].substring(indexes[c], index));
                            indexes[c] = index + 1;
                        }
                        moreToGo = true;
                    }
                } else {
                    row.append(this.cell_empty);
                }
                row.append(this.cell_postfix);
                ++c;
            }
            if (!moreToGo) continue;
            out.write(row.toString().getBytes());
            out.write(13);
            out.write(10);
        }
    }

    public int indexOf(ZipStringBuffer sb, char c, int index) {
        while (index < sb.length()) {
            if (sb.charAt(index) == c) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String toString() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.printTo(bout);
            return new String(bout.toByteArray());
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    private byte[] compress(byte[] dat) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GZIPOutputStream gzout = new GZIPOutputStream(bout);
        gzout.write(dat, 0, dat.length);
        gzout.finish();
        gzout.close();
        return bout.toByteArray();
    }

    private byte[] decompress(byte[] dat) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        GZIPInputStream gzin = new GZIPInputStream(bin);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n = 0;
        while (n != -1) {
            n = gzin.read(buf, 0, 1024);
            if (n <= 0) continue;
            bout.write(buf, 0, n);
        }
        return bout.toByteArray();
    }
}

