/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.text.DecimalFormat;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GraphTableDialog
extends Dialog
implements SelectionListener {
    DecimalFormat df = new DecimalFormat("###########################################.########################################");
    String[] plotting_types = new String[]{EditorPlugin.getString("PLOTTING_TYPE_AVERAGE"), EditorPlugin.getString("PLOTTING_TYPE_MAX"), EditorPlugin.getString("PLOTTING_TYPE_MIN"), EditorPlugin.getString("PLOTTING_TYPE_SUM"), EditorPlugin.getString("PLOTTING_TYPE_COUNT"), EditorPlugin.getString("PLOTTING_TYPE_NEAREST"), EditorPlugin.getString("PLOTTING_TYPE_MAX_MIN"), EditorPlugin.getString("PLOTTING_TYPE_AVG_MAX_MIN"), EditorPlugin.getString("PLOTTING_TYPE_STDDEV"), EditorPlugin.getString("PLOTTING_TYPE_STDDEV_AVG"), EditorPlugin.getString("PLOTTING_TYPE_GRADIENT")};
    Image image;
    Graph graph;
    RGB rgb_black;
    Shell shell;
    Composite main_panel;
    Label error_img;
    Label error_label;
    Group color_panel;
    RGB color = this.rgb_black = new RGB(0, 0, 0);
    Label color_label;
    Button color_set;
    Group plotting_panel;
    Combo plotting_choice;
    Group period_panel;
    Composite period_millis;
    Button period_millis_set;
    Text period_millis_value;
    Label period_millis_label;
    Composite period_ticks;
    Button period_ticks_set;
    Text period_ticks_value;
    Label period_ticks_label;
    Composite period_pixels;
    Button period_pixels_set;
    Text period_pixels_value;
    Label period_pixels_label;
    Group nodata_panel;
    Button nodata_nothing;
    Button nodata_drawzero;
    Button nodata_drawprevious;
    Group offset_panel;
    Composite xoffset_panel;
    Text xoffset_set;
    Label xoffset_label;
    Button xoffset_snap;
    Composite yoffset_panel;
    Text yoffset_set;
    Label yoffset_label;
    Composite multiplier_panel;
    Text multiplier_set;
    Label multiplier_label;
    Composite button_panel;
    Button button_ok;
    Button button_cancel;

    public GraphTableDialog(Shell shell) {
        super(shell);
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
        this.readFromGraph();
    }

    private void redoColorImage() {
        Image tmpimage = this.image;
        PaletteData palettedat = new PaletteData(new RGB[]{this.color, this.color});
        ImageData imgdat = new ImageData(30, 30, 1, palettedat);
        this.image = new Image((Device)Display.getDefault(), imgdat);
        try {
            this.color_label.setImage(this.image);
            this.main_panel.redraw();
            this.color_label.redraw();
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            EditorPlugin.DBG.warning("error setting color image", e);
        }
        if (tmpimage != null) {
            tmpimage.dispose();
        }
    }

    public Object open() {
        int WIDTH = 300;
        int HEIGHT = 300;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67696);
        this.shell.setText(EditorPlugin.getString("CONFIGURE_GRAPH"));
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setBounds(0, 0, WIDTH, HEIGHT);
        this.initGraphics();
        this.initEventHandling();
        this.shell.pack();
        this.readFromGraph();
        Rectangle r = parent.getBounds();
        Rectangle z = this.shell.getBounds();
        if (z.width < WIDTH) {
            z.width = WIDTH;
        }
        if (z.height < HEIGHT) {
            z.height = HEIGHT;
        }
        this.shell.setBounds(r.x + r.width / 2 - z.width / 2, r.y + r.height / 2 - z.height / 2, z.width, z.height);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.graph;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o == this.button_ok) {
            try {
                this.writeToGraph();
                this.shell.dispose();
            }
            catch (Exception x) {
                this.error_label.setText(EditorPlugin.getString("ERROR_LABEL") + x.getMessage());
                this.error_img.setImage(EditorPlugin.img.getImage("error_st_obj.gif"));
                this.main_panel.layout(true);
                this.error_label.redraw();
                this.error_img.redraw();
            }
        } else if (o == this.button_cancel) {
            this.shell.dispose();
        } else if (o == this.color_set) {
            ColorDialog dialog = new ColorDialog(this.shell);
            dialog.setRGB(this.color);
            dialog.open();
            this.color = dialog.getRGB();
            this.redoColorImage();
        } else if (o == this.xoffset_snap) {
            double tmax = this.graph.getGraphSource().getMax();
            double tnow = System.currentTimeMillis();
            this.xoffset_set.setText(this.df.format((long)(tnow - tmax)));
        }
    }

    private void initEventHandling() {
        this.button_ok.addSelectionListener((SelectionListener)this);
        this.button_cancel.addSelectionListener((SelectionListener)this);
        this.color_set.addSelectionListener((SelectionListener)this);
        this.xoffset_snap.addSelectionListener((SelectionListener)this);
    }

    private void initGraphics() {
        this.main_panel = new Composite((Composite)this.shell, 0);
        this.main_panel.setLayout((Layout)new GridLayout(2, false));
        String DEF_TEXT = "               ";
        int groupHints = 16;
        this.error_img = new Label(this.main_panel, 0);
        this.error_label = new Label(this.main_panel, 0);
        this.error_label.setText("");
        this.color_panel = new Group(this.main_panel, groupHints);
        this.color_panel.setText(EditorPlugin.getString("GRAPH_COLOR_PANEL_TITLE"));
        this.color_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 2, 1, 4, 4));
        this.color_panel.setLayout((Layout)new RowLayout(256));
        this.color_label = new Label((Composite)this.color_panel, 0);
        this.redoColorImage();
        this.color_label.setImage(this.image);
        this.color_set = new Button((Composite)this.color_panel, 8);
        this.color_set.setText(EditorPlugin.getString("SET_COLOR"));
        this.plotting_panel = new Group(this.main_panel, groupHints);
        this.plotting_panel.setText(EditorPlugin.getString("GRAPH_PLOTTING_PANEL_TITLE"));
        this.plotting_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 2, 1, 4, 4));
        this.plotting_panel.setLayout((Layout)new RowLayout(256));
        this.plotting_choice = new Combo((Composite)this.plotting_panel, 2048);
        this.plotting_choice.setItems(this.plotting_types);
        this.period_panel = new Group(this.main_panel, groupHints);
        this.period_panel.setText(EditorPlugin.getString("GRAPH_PERIOD_PANEL_TITLE"));
        this.period_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 2, 1, 4, 4));
        this.period_panel.setLayout((Layout)new GridLayout(2, false));
        this.period_millis_set = new Button((Composite)this.period_panel, 16);
        this.period_millis = new Composite((Composite)this.period_panel, 0);
        this.period_millis.setLayout((Layout)new RowLayout(256));
        this.period_millis_value = new Text(this.period_millis, 2048);
        this.period_millis_value.setText(DEF_TEXT);
        this.period_millis_label = new Label(this.period_millis, 0);
        this.period_millis_label.setText("  " + EditorPlugin.getString("AVG_MILLIS"));
        this.period_ticks_set = new Button((Composite)this.period_panel, 16);
        this.period_ticks = new Composite((Composite)this.period_panel, 0);
        this.period_ticks.setLayout((Layout)new RowLayout(256));
        this.period_ticks_value = new Text(this.period_ticks, 2048);
        this.period_ticks_value.setText(DEF_TEXT);
        this.period_ticks_label = new Label(this.period_ticks, 0);
        this.period_ticks_label.setText("  " + EditorPlugin.getString("AVG_TICKS"));
        this.period_pixels_set = new Button((Composite)this.period_panel, 16);
        this.period_pixels = new Composite((Composite)this.period_panel, 0);
        this.period_pixels.setLayout((Layout)new RowLayout(256));
        this.period_pixels_value = new Text(this.period_pixels, 2048);
        this.period_pixels_value.setText(DEF_TEXT);
        this.period_pixels_label = new Label(this.period_pixels, 0);
        this.period_pixels_label.setText("  " + EditorPlugin.getString("AVG_PIXELS"));
        this.nodata_panel = new Group(this.main_panel, groupHints);
        this.nodata_panel.setText(EditorPlugin.getString("GRAPH_NODATA_PANEL_TITLE"));
        this.nodata_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 2, 1, 4, 4));
        this.nodata_panel.setLayout((Layout)new GridLayout(1, false));
        this.nodata_drawzero = new Button((Composite)this.nodata_panel, 16);
        this.nodata_drawzero.setText(EditorPlugin.getString("NODATA_DRAWZERO"));
        this.nodata_nothing = new Button((Composite)this.nodata_panel, 16);
        this.nodata_nothing.setText(EditorPlugin.getString("NODATA_DONOTHING"));
        this.nodata_drawprevious = new Button((Composite)this.nodata_panel, 16);
        this.nodata_drawprevious.setText(EditorPlugin.getString("NODATA_DRAWPREVIOUS"));
        this.offset_panel = new Group(this.main_panel, groupHints);
        this.offset_panel.setText(EditorPlugin.getString("GRAPH_OFFSET_PANEL_TITLE"));
        this.offset_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 2, 1, 4, 4));
        this.offset_panel.setLayout((Layout)new GridLayout(1, false));
        this.xoffset_panel = new Composite((Composite)this.offset_panel, 0);
        this.xoffset_panel.setLayout((Layout)new RowLayout(256));
        this.xoffset_set = new Text(this.xoffset_panel, 2048);
        this.xoffset_label = new Label(this.xoffset_panel, 0);
        this.xoffset_label.setText(EditorPlugin.getString("XOFFSET_LABEL"));
        this.xoffset_snap = new Button(this.xoffset_panel, 8);
        this.xoffset_snap.setText(EditorPlugin.getString("XOFFSET_SNAP"));
        this.yoffset_panel = new Composite((Composite)this.offset_panel, 0);
        this.yoffset_panel.setLayout((Layout)new RowLayout(256));
        this.yoffset_set = new Text(this.yoffset_panel, 2048);
        this.yoffset_label = new Label(this.yoffset_panel, 0);
        this.yoffset_label.setText(EditorPlugin.getString("YOFFSET_LABEL"));
        this.multiplier_panel = new Composite((Composite)this.offset_panel, 0);
        this.multiplier_panel.setLayout((Layout)new RowLayout(256));
        this.multiplier_set = new Text(this.multiplier_panel, 2048);
        this.multiplier_label = new Label(this.multiplier_panel, 0);
        this.multiplier_label.setText(EditorPlugin.getString("MULTIPLIER_LABEL"));
        this.button_panel = new Composite(this.main_panel, 0);
        this.button_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 2, 1, 4, 4));
        this.button_panel.setLayout((Layout)new GridLayout(1, true));
        Composite bptmp = new Composite(this.button_panel, 0);
        bptmp.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 2, 2));
        bptmp.setLayout((Layout)new GridLayout(2, true));
        this.button_ok = new Button(bptmp, 8);
        this.button_ok.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 4, 2));
        this.button_ok.setText(EditorPlugin.getString("OK"));
        this.button_cancel = new Button(bptmp, 8);
        this.button_cancel.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 4, 2));
        this.button_cancel.setText(EditorPlugin.getString("CANCEL"));
    }

    public Graph getGraph() {
        return this.graph;
    }

    private void readFromGraph() {
        try {
            if (this.graph != null) {
                this.color = this.graph.getForeground().getRGB();
            }
            this.redoColorImage();
            int ptype = this.graph.getPlottingType();
            if (ptype == 0) {
                this.plotting_choice.select(0);
            } else if (ptype == 2) {
                this.plotting_choice.select(1);
            } else if (ptype == 1) {
                this.plotting_choice.select(2);
            } else if (ptype == 5) {
                this.plotting_choice.select(3);
            } else if (ptype == 7) {
                this.plotting_choice.select(4);
            } else if (ptype == 6) {
                this.plotting_choice.select(5);
            } else if (ptype == 3) {
                this.plotting_choice.select(6);
            } else if (ptype == 4) {
                this.plotting_choice.select(7);
            } else if (ptype == 8) {
                this.plotting_choice.select(8);
            } else if (ptype == 9) {
                this.plotting_choice.select(9);
            } else if (ptype == 10) {
                this.plotting_choice.select(10);
            }
            this.period_millis_value.setText(this.df.format((long)this.graph.getPlottingPeriodValue()));
            this.period_pixels_value.setText(this.df.format((long)this.graph.getPlottingPeriodValue()));
            this.period_ticks_value.setText(this.df.format((long)this.graph.getPlottingPeriodValue()));
            int period_type = this.graph.getPlottingPeriodType();
            if (period_type == 1) {
                this.period_millis_set.setSelection(true);
            } else if (period_type == 2) {
                this.period_pixels_set.setSelection(true);
            } else if (period_type == 0) {
                this.period_ticks_set.setSelection(true);
            }
            int nodata_type = this.graph.getNoDataBehaviour();
            if (nodata_type == 0) {
                this.nodata_nothing.setSelection(true);
            } else if (nodata_type == 2) {
                this.nodata_drawprevious.setSelection(true);
            } else if (nodata_type == 1) {
                this.nodata_drawzero.setSelection(true);
            }
            this.xoffset_set.setText(this.df.format((long)this.graph.getXOffset()));
            this.yoffset_set.setText(this.df.format((long)this.graph.getYOffset()));
            this.multiplier_set.setText(this.df.format(this.graph.getStaticScaling()));
        }
        catch (NullPointerException e) {
        }
        catch (SWTException e) {}
    }

    private void writeToGraph() throws InvalidDataException {
        try {
            this.graph.setForeground(new Color((Device)Display.getDefault(), this.color));
            int pchoice = this.plotting_choice.getSelectionIndex();
            int ptype = this.graph.getPlottingType();
            if (pchoice == 0) {
                ptype = 0;
            } else if (pchoice == 1) {
                ptype = 2;
            } else if (pchoice == 2) {
                ptype = 1;
            } else if (pchoice == 3) {
                ptype = 5;
            } else if (pchoice == 4) {
                ptype = 7;
            } else if (pchoice == 5) {
                ptype = 6;
            } else if (pchoice == 6) {
                ptype = 3;
            } else if (pchoice == 7) {
                ptype = 4;
            } else if (pchoice == 8) {
                ptype = 8;
            } else if (pchoice == 9) {
                ptype = 9;
            } else if (pchoice == 10) {
                ptype = 10;
            }
            this.graph.setPlottingType(ptype);
            try {
                if (this.period_millis_set.getSelection()) {
                    this.graph.setPlottingPeriod(1, Double.parseDouble(this.period_millis_value.getText()));
                } else if (this.period_pixels_set.getSelection()) {
                    this.graph.setPlottingPeriod(2, Double.parseDouble(this.period_pixels_value.getText()));
                } else if (this.period_ticks_set.getSelection()) {
                    this.graph.setPlottingPeriod(0, Double.parseDouble(this.period_ticks_value.getText()));
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidDataException(EditorPlugin.getString("ERROR_BAD_PERIOD"));
            }
            if (this.nodata_nothing.getSelection()) {
                this.graph.setNoDataBehaviour(0);
            } else if (this.nodata_drawprevious.getSelection()) {
                this.graph.setNoDataBehaviour(2);
            } else if (this.nodata_drawzero.getSelection()) {
                this.graph.setNoDataBehaviour(1);
            }
            try {
                this.graph.setXOffset(Double.parseDouble(this.xoffset_set.getText()));
            }
            catch (NumberFormatException e) {
                throw new InvalidDataException(EditorPlugin.getString("ERROR_BAD_XOFFSET"));
            }
            try {
                this.graph.setYOffset(Double.parseDouble(this.yoffset_set.getText()));
            }
            catch (NumberFormatException e) {
                throw new InvalidDataException(EditorPlugin.getString("ERROR_BAD_YOFFSET"));
            }
            try {
                this.graph.setStaticScaling(Double.parseDouble(this.multiplier_set.getText()));
            }
            catch (NumberFormatException e) {
                throw new InvalidDataException(EditorPlugin.getString("ERROR_BAD_MULTIPLIER"));
            }
        }
        catch (NullPointerException e) {
        }
        catch (SWTException e) {}
    }

    class InvalidDataException
    extends Exception {
        public InvalidDataException(String s) {
            super(s);
        }
    }
}

