/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.table.internal;

import org.eclipse.hyades.statistical.ui.widgets.table.internal.DoubleVerifyListener;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.FloatVerifyListener;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.InvalidTableValueException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class TableAdapter
extends Composite
implements IStructuredContentProvider,
ITableLabelProvider,
ICellModifier {
    public static final int LABEL = 0;
    public static final int TEXT = 1;
    public static final int CHOICE = 2;
    public static final int INTEGER = 3;
    public static final int BOOLEAN = 4;
    public static final int FLOAT = 5;
    public static final int DOUBLE = 6;
    public static final int COLOR = 7;
    public static final int CUSTOM = 8;
    public static int EXTRA_COLUMN_WIDTH = 23;
    int[] columnWidths = new int[0];
    protected boolean[] autoSizeOnContents = new boolean[0];
    protected boolean[] enforceMinWidths = new boolean[0];
    protected boolean[] columnExpands = new boolean[0];
    protected int[] columnTypes = new int[0];
    protected TableViewer viewer;
    boolean resized = false;
    TableAdapterControlListener controlListener = new TableAdapterControlListener();

    public TableAdapter(Composite parent) {
        super(parent, 2048);
        this.setLayout((Layout)new FillLayout());
        this.setBackground(parent.getBackground());
        this.viewer = new TableViewer(new Table((Composite)this, 98308));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setLabelProvider((IBaseLabelProvider)this);
        this.viewer.setCellModifier((ICellModifier)this);
        this.addControlListener((ControlListener)this.controlListener);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void configure() {
        this.viewer.setInput((Object)"");
        GC gc = new GC((Drawable)this);
        int i = 0;
        while (i < this.viewer.getTable().getColumnCount()) {
            int w = gc.stringExtent((String)this.viewer.getTable().getColumn((int)i).getText()).x + EXTRA_COLUMN_WIDTH;
            if (w > this.columnWidths[i]) {
                this.columnWidths[i] = w;
            }
            if (this.autoSizeOnContents[i] && (w = gc.stringExtent((String)this.getLongestText((int)i)).x + this.getMaxImageWidth(i) + EXTRA_COLUMN_WIDTH) > this.columnWidths[i]) {
                this.columnWidths[i] = w;
            }
            this.viewer.getTable().getColumn(i).setWidth(this.columnWidths[i]);
            ++i;
        }
        gc.dispose();
        this.resized = false;
    }

    protected String getLongestText(int columnIndex) {
        String longestString = "";
        int maxStringLength = 0;
        Object[] elements = this.getElements(null);
        int i = 0;
        while (i < elements.length) {
            String columnText = this.getColumnText(elements[i], columnIndex);
            if (columnText.length() > maxStringLength) {
                maxStringLength = columnText.length();
                longestString = columnText;
            }
            ++i;
        }
        return longestString;
    }

    protected int getMaxImageWidth(int columnIndex) {
        int maxImageWidth = 0;
        Object[] elements = this.getElements(null);
        int i = 0;
        while (i < elements.length) {
            Image image = this.getColumnImage(elements[i], columnIndex);
            if (image != null && image.getImageData().width > maxImageWidth) {
                maxImageWidth = image.getImageData().width;
            }
            ++i;
        }
        return maxImageWidth;
    }

    public void setColumnNames(String[] columnNames) {
        this.viewer.setColumnProperties(columnNames);
        TableColumn[] columns = new TableColumn[columnNames.length];
        this.autoSizeOnContents = new boolean[columnNames.length];
        this.enforceMinWidths = new boolean[columnNames.length];
        this.columnWidths = new int[columnNames.length];
        this.columnExpands = new boolean[columnNames.length];
        this.columnTypes = new int[columnNames.length];
        int i = 0;
        while (i < columns.length) {
            columns[i] = new TableColumn(this.viewer.getTable(), 16384);
            columns[i].setText(columnNames[i]);
            this.columnWidths[i] = 23;
            this.enforceMinWidths[i] = true;
            this.columnExpands[i] = true;
            this.autoSizeOnContents[i] = false;
            this.columnTypes[i] = 0;
            columns[i].addControlListener((ControlListener)this.controlListener);
            ++i;
        }
        this.resized = false;
    }

    public String[] getColumnNames() {
        String[] columnNames = new String[this.viewer.getColumnProperties().length];
        int i = 0;
        while (i < columnNames.length) {
            columnNames[i] = (String)this.viewer.getColumnProperties()[i];
            ++i;
        }
        return columnNames;
    }

    public void setColumnEditor(CellEditor editor, int column) {
        CellEditor[] editors = this.viewer.getCellEditors();
        editors[column] = editor;
        this.viewer.setCellEditors(editors);
    }

    public void setColumnTypes(int[] columnTypes) {
        this.columnTypes = columnTypes;
        CellEditor[] editors = new CellEditor[columnTypes.length];
        int i = 0;
        while (i < columnTypes.length) {
            switch (columnTypes[i]) {
                case 0: {
                    editors[i] = new TextCellEditor((Composite)this.viewer.getTable());
                    break;
                }
                case 1: {
                    editors[i] = new TextCellEditor((Composite)this.viewer.getTable());
                    break;
                }
                case 2: {
                    editors[i] = new ComboBoxCellEditor((Composite)this.viewer.getTable(), this.getComboChoices(null, i));
                    int w = editors[i].getControl().computeSize((int)-1, (int)-1).x;
                    if (w <= this.columnWidths[i]) break;
                    this.columnWidths[i] = w;
                    break;
                }
                case 3: {
                    editors[i] = new TextCellEditor((Composite)this.viewer.getTable());
                    ((Text)editors[i].getControl()).addVerifyListener(new VerifyListener(){

                        public void verifyText(VerifyEvent e) {
                            if (e.text.length() == 0) {
                                e.doit = true;
                            } else {
                                try {
                                    Integer.parseInt(e.text);
                                    e.doit = true;
                                }
                                catch (NumberFormatException ex) {
                                    e.doit = false;
                                }
                            }
                        }
                    });
                    break;
                }
                case 5: {
                    editors[i] = new TextCellEditor((Composite)this.viewer.getTable());
                    ((Text)editors[i].getControl()).addVerifyListener((VerifyListener)new FloatVerifyListener((Text)editors[i].getControl()));
                    break;
                }
                case 6: {
                    editors[i] = new TextCellEditor((Composite)this.viewer.getTable());
                    ((Text)editors[i].getControl()).addVerifyListener((VerifyListener)new DoubleVerifyListener((Text)editors[i].getControl()));
                    break;
                }
                case 4: {
                    editors[i] = new CheckboxCellEditor((Composite)this.viewer.getTable());
                    break;
                }
                case 7: {
                    editors[i] = new ColorCellEditor((Composite)this.viewer.getTable());
                }
            }
            ++i;
        }
        this.viewer.setCellEditors(editors);
    }

    public String[] getComboChoices(Object element, int columnIndex) {
        return new String[0];
    }

    public abstract Object[] getElements(Object var1);

    public int getRow(Object element) {
        Object[] elements = this.getElements(null);
        int i = 0;
        while (i < elements.length) {
            if (element == elements[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getColumn(String property) {
        int i = 0;
        while (i < this.viewer.getColumnProperties().length) {
            if (property.equals(this.viewer.getColumnProperties()[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        return element.toString() + "[" + columnIndex + "]";
    }

    public RGB getColumnRGB(Object element, int columnIndex) {
        return null;
    }

    public String appendFloat(String text) {
        if (text.charAt(text.length() - 1) == '.') {
            text = text + "0";
        }
        return text;
    }

    public Object getValue(Object element, String property) {
        int column = this.getColumn(property);
        switch (this.columnTypes[column]) {
            case 0: 
            case 1: 
            case 3: {
                return this.getColumnText(element, column);
            }
            case 5: 
            case 6: {
                return this.appendFloat(this.getColumnText(element, column));
            }
            case 2: {
                String[] choices = this.getComboChoices(element, column);
                int j = 0;
                while (j < choices.length) {
                    if (this.getColumnText(element, column).equals(choices[j])) {
                        return new Integer(j);
                    }
                    ++j;
                }
                return new Integer(0);
            }
            case 4: {
                return new Boolean(this.viewer.getTable().getItem(this.getRow(element)).getChecked());
            }
            case 7: {
                return this.getColumnRGB(element, column);
            }
            case 8: {
                return element;
            }
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        int column = this.getColumn(property);
        int possibleNewType = this.getColumnType(element, column);
        if (possibleNewType != this.columnTypes[column]) {
            this.columnTypes[column] = possibleNewType;
            this.setColumnTypes(this.columnTypes);
        }
        switch (this.columnTypes[column]) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 3: {
                return true;
            }
            case 2: {
                ((ComboBoxCellEditor)this.viewer.getCellEditors()[column]).setItems(this.getComboChoices(element, column));
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected int getColumnType(Object element, int column) {
        return this.columnTypes[column];
    }

    public void modify(Object element, String property, Object value) {
        int column = this.getColumn(property);
        try {
            switch (this.columnTypes[column]) {
                case 0: 
                case 1: {
                    this.valueChanged(((TableItem)element).getData(), column, (String)value);
                    break;
                }
                case 3: {
                    if (((String)value).equals("")) break;
                    this.valueChanged(((TableItem)element).getData(), column, new Integer((String)value));
                    break;
                }
                case 2: {
                    this.valueChanged(((TableItem)element).getData(), column, (Integer)value);
                    break;
                }
                case 4: {
                    this.valueChanged(((TableItem)element).getData(), column, (Boolean)value);
                    break;
                }
                case 5: {
                    if (((String)value).equals("")) break;
                    this.valueChanged(((TableItem)element).getData(), column, new Float((String)value));
                    break;
                }
                case 6: {
                    if (((String)value).equals("")) break;
                    this.valueChanged(((TableItem)element).getData(), column, new Double((String)value));
                    break;
                }
                case 7: {
                    if (value == null) break;
                    this.valueChanged(((TableItem)element).getData(), column, (RGB)value);
                    break;
                }
                case 8: {
                    if (value == null) break;
                    this.valueChanged(((TableItem)element).getData(), column);
                }
            }
            this.viewer.update(((TableItem)element).getData(), null);
        }
        catch (InvalidTableValueException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Cannot Update Value", (String)("Could not change " + property + " value.\n\n" + e.getClass().getName() + "\n" + e.getMessage()));
        }
    }

    public void valueChanged(Object element, int column, String newValue) throws InvalidTableValueException {
    }

    public void valueChanged(Object element, int column, Float newValue) throws InvalidTableValueException {
    }

    public void valueChanged(Object element, int column, Double newValue) throws InvalidTableValueException {
    }

    public void valueChanged(Object element, int column, Boolean newValue) throws InvalidTableValueException {
    }

    public void valueChanged(Object element, int column, Integer newValue) throws InvalidTableValueException {
    }

    public void valueChanged(Object element, int column, RGB rgb) throws InvalidTableValueException {
    }

    public void valueChanged(Object element, int column) throws InvalidTableValueException {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void dispose() {
    }

    public void expandColumns() {
        int i;
        int i2 = 0;
        while (i2 < this.viewer.getTable().getColumnCount()) {
            this.viewer.getTable().getColumn(i2).removeControlListener((ControlListener)this.controlListener);
            ++i2;
        }
        int fixedColumnWidths = 0;
        int expandableColumnWidths = 0;
        int expandableColumnCount = 0;
        int i3 = 0;
        while (i3 < this.viewer.getTable().getColumnCount()) {
            if (this.columnExpands[i3]) {
                expandableColumnWidths += this.viewer.getTable().getColumn(i3).getWidth();
                ++expandableColumnCount;
            } else {
                fixedColumnWidths += this.viewer.getTable().getColumn(i3).getWidth();
            }
            ++i3;
        }
        int diff = this.getSize().x - 4 - (expandableColumnWidths + fixedColumnWidths);
        if (!(diff <= 0 && this.resized || expandableColumnCount <= 0)) {
            i = 0;
            while (i < this.viewer.getTable().getColumnCount()) {
                int extra = diff;
                if (expandableColumnCount > 0) {
                    extra = diff / expandableColumnCount;
                }
                if (this.columnExpands[i]) {
                    int newWidth = this.viewer.getTable().getColumn(i).getWidth() + extra;
                    if (this.enforceMinWidths[i] && newWidth < this.columnWidths[i]) {
                        --expandableColumnCount;
                        diff -= this.columnWidths[i] - newWidth;
                        newWidth = this.columnWidths[i];
                    }
                    this.viewer.getTable().getColumn(i).setWidth(newWidth);
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.viewer.getTable().getColumnCount()) {
            this.viewer.getTable().getColumn(i).addControlListener((ControlListener)this.controlListener);
            ++i;
        }
    }

    class TableAdapterControlListener
    extends ControlAdapter {
        TableAdapterControlListener() {
        }

        public void controlResized(ControlEvent event) {
            Object source = event.getSource();
            if (source == TableAdapter.this) {
                TableAdapter.this.expandColumns();
            } else {
                int i = 0;
                while (i < TableAdapter.this.viewer.getTable().getColumnCount()) {
                    if (source == TableAdapter.this.viewer.getTable().getColumn(i)) {
                        TableAdapter.this.resized = true;
                        TableAdapter.this.columnWidths[i] = TableAdapter.this.viewer.getTable().getColumn(i).getWidth();
                        break;
                    }
                    ++i;
                }
            }
        }
    }
}

