/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.ui.popup.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.probekit.ui.IProbeCompileActionDelegateFactory;
import org.eclipse.hyades.probekit.ui.ProbekitUI;
import org.eclipse.hyades.probekit.ui.popup.actions.DefaultProbeCompileObjectActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ProbekitUICompileAction
implements IObjectActionDelegate {
    public static final String extensionPointID = "probekitCompileAction";
    static boolean hasCheckedForExtender = false;
    static IProbeCompileActionDelegateFactory extenderFactory = null;
    IObjectActionDelegate delegate = this.getActionDelegate();

    public static IObjectActionDelegate getDefaultActionDelegate() {
        return new DefaultProbeCompileObjectActionDelegate();
    }

    IObjectActionDelegate getActionDelegate() {
        if (!hasCheckedForExtender) {
            hasCheckedForExtender = true;
            String idString = ProbekitUI.getDefault().getBundle().getSymbolicName() + "." + extensionPointID;
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(idString);
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension e = extensions[i];
                    IConfigurationElement[] configElements = e.getConfigurationElements();
                    boolean anyCompilerElements = false;
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement ce = configElements[j];
                        if (ce.getName().equals("compileActionFactory")) {
                            Object extensionClass;
                            anyCompilerElements = true;
                            try {
                                extensionClass = ce.createExecutableExtension("class");
                            }
                            catch (CoreException ex) {
                                extensionClass = null;
                            }
                            if (extensionClass != null) {
                                if (extensionClass instanceof IProbeCompileActionDelegateFactory) {
                                    extenderFactory = (IProbeCompileActionDelegateFactory)extensionClass;
                                    break;
                                }
                                Status status = new Status(4, "org.eclipse.hyades.probekit", 0, ProbekitUI.getResourceString("UIFactory.ExtenderError") + this.getPrintableExtenderName(e) + ProbekitUI.getResourceString("UIFactory.DoesNotImplementIObjectActionDelegate"), null);
                                ProbekitUI.getDefault().getLog().log((IStatus)status);
                            }
                        }
                        ++j;
                    }
                    if (extenderFactory != null) break;
                    if (!anyCompilerElements) {
                        Status status = new Status(4, "org.eclipse.hyades.probekit", 0, ProbekitUI.getResourceString("UIFactory.ExtenderError") + this.getPrintableExtenderName(e) + ProbekitUI.getResourceString("UIFactory.NoFactoryElements"), null);
                        ProbekitUI.getDefault().getLog().log((IStatus)status);
                    }
                    ++i;
                }
            }
        }
        if (extenderFactory != null) {
            return extenderFactory.create();
        }
        return ProbekitUICompileAction.getDefaultActionDelegate();
    }

    private String getPrintableExtenderName(IExtension e) {
        String extenderLabel = e.getLabel();
        String extenderId = e.getUniqueIdentifier();
        String extenderName = "\"" + extenderLabel + "\" (" + extenderId + ")";
        return extenderName;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.delegate.setActivePart(action, targetPart);
    }

    public void run(IAction action) {
        this.delegate.run(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.delegate.selectionChanged(action, selection);
    }
}

