/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.datacollection;

import java.util.Hashtable;
import org.eclipse.hyades.internal.config.generator.Agent;
import org.eclipse.hyades.internal.config.generator.AgentControllerEnvironment;
import org.eclipse.hyades.internal.config.generator.Application;
import org.eclipse.hyades.internal.config.generator.ConfigUtility;
import org.eclipse.hyades.internal.config.generator.HashUtility;
import org.eclipse.hyades.internal.config.generator.Logger;
import org.eclipse.hyades.internal.config.generator.Option;
import org.eclipse.hyades.internal.config.generator.PlatformObject;
import org.eclipse.hyades.internal.config.generator.PluginConfig;
import org.eclipse.hyades.internal.config.generator.SetConfigSkeleton;
import org.eclipse.hyades.internal.config.generator.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetConfig
extends SetConfigSkeleton {
    public static String TAG = "org.eclipse.hyades.datacollection";

    public SetConfig() {
        super(TAG);
        Logger.out("SetConfig constructor called");
    }

    public void init(Hashtable hashtable) {
        String string = HashUtility.getValue(hashtable, "RASERVER_HOME");
        this.setFileName(string + SetConfigSkeleton.sr + "plugins" + SetConfigSkeleton.sr + TAG + SetConfigSkeleton.sr + "config" + SetConfigSkeleton.sr + "pluginconfig.xml");
    }

    public void askUser() {
        if (SetConfigSkeleton.silent) {
            if (this.configFile.getValue("JBOSS_HOME") == null) {
                this.configFile.setValue("JBOSS_HOME", "");
            }
        } else if (this.configFile.getValue("JBOSS_HOME") == null) {
            this.configFile.setValue("JBOSS_HOME", this.promptJBossHome(""));
        } else {
            this.configFile.setValue("JBOSS_HOME", this.promptJBossHome(this.configFile.getValue("JBOSS_HOME")));
        }
        if (this.configFile.getValue("JBOSS_HOME") == null || this.configFile.getValue("JBOSS_HOME").equals("")) {
            this.configFile.setValue("JBOSS_HOME", "null");
        }
        if (SetConfigSkeleton.silent) {
            if (this.configFile.getValue("JONAS_HOME") == null) {
                this.configFile.setValue("JONAS_HOME", "");
            }
        } else if (this.configFile.getValue("JONAS_HOME") == null) {
            this.configFile.setValue("JONAS_HOME", this.promptJOnASHome(""));
        } else {
            this.configFile.setValue("JONAS_HOME", this.promptJOnASHome(this.configFile.getValue("JONAS_HOME")));
        }
        if (this.configFile.getValue("JONAS_HOME") == null || this.configFile.getValue("JONAS_HOME").equals("")) {
            this.configFile.setValue("JONAS_HOME", "null");
        }
    }

    private String promptJBossHome(String string) {
        System.out.println(this.getString("Config.Prompt.JBOSS_HOME.Tag"));
        System.out.print("  " + this.getString("Config.Prompt.Default") + "\"" + string + "\"");
        System.out.print(" (");
        System.out.print(this.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        System.out.print("  " + this.getString("Config.Prompt.NewValue"));
        return ConfigUtility.askUser(string);
    }

    private String promptJOnASHome(String string) {
        System.out.println(this.getString("Config.Prompt.JONAS_HOME.Tag"));
        System.out.print("  " + this.getString("Config.Prompt.Default") + "\"" + string + "\"");
        System.out.print(" (");
        System.out.print(this.getString("Config.Prompt.DefaultAccept"));
        System.out.println(")");
        System.out.print("  " + this.getString("Config.Prompt.NewValue"));
        return ConfigUtility.askUser(string);
    }

    public void generateConfiguration() {
        Document document = this.configFile.getDoc();
        if (document == null) {
            return;
        }
        Element element = document.createElement(PluginConfig.TAG);
        Element element2 = this.configFile.getHolder();
        element2.appendChild(element);
        Element element3 = document.createElement(AgentControllerEnvironment.TAG);
        AgentControllerEnvironment.setConfiguration(element3, "default");
        element.appendChild(element3);
        Element element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "JBOSS_HOME");
        Variable.setPosition(element4, "replace");
        Variable.setValue(element4, this.configFile.getValue("JBOSS_HOME"));
        element3.appendChild(element4);
        element4 = document.createElement(Variable.TAG);
        Variable.setName(element4, "JONAS_HOME");
        Variable.setPosition(element4, "replace");
        Variable.setValue(element4, this.configFile.getValue("JONAS_HOME"));
        element3.appendChild(element4);
        if (PlatformObject.name.startsWith("Windows")) {
            Element element5 = document.createElement(Application.TAG);
            Application.setConfiguration(element5, "default");
            Application.setExecutable(element5, "PerfmonAgent");
            Application.setLocation(element5, "%RASERVER_HOME%" + SetConfigSkeleton.sr + "bin");
            Application.setPath(element5, "%RASERVER_HOME%" + SetConfigSkeleton.sr + "bin" + SetConfigSkeleton.sr + "PerfmonAgent" + PlatformObject.exeExt);
            element.appendChild(element5);
        }
        Element element6 = document.createElement(Agent.TAG);
        Agent.setConfiguration(element6, "default");
        Agent.setName(element6, "Java Profiling Agent");
        Agent.setClient(element6, "DYNAMIC");
        if (PlatformObject.name.startsWith("Windows")) {
            Agent.setDataChannelSize(element6, "64M");
        } else {
            Agent.setDataChannelSize(element6, "30M");
        }
        Agent.setType(element6, "Profiler");
        element.appendChild(element6);
        Element element7 = document.createElement(Option.TAG);
        Option.setName(element7, "Thread Analysis Agent");
        Option.setType(element7, "Profiler");
        Option.setValue(element7, "hcthread");
        element.appendChild(element7);
        element7 = document.createElement(Option.TAG);
        Option.setName(element7, TAG);
        Option.setType(element7, "version");
        Option.setValue(element7, this.getString("Config.Plugin.Version"));
        element.appendChild(element7);
        this.configFile.saveToFile();
    }

    public void printHelp() {
    }

    public void printExamples() {
    }
}

