#!/bin/sh
# USAGE:  runregex.sh
# PURPOSE:  Illustrates the functional capabilities of the Generic Log Adapter (GLA) run-time using an example adapter file and sample log file.
# INSTRUCTIONS:  When executing in a GLA run-time environment, change the value of the $GLA_HOME environment variable to the absolute path of the unzipped GLA run-time.
# NOTE:  When executing in a plug-in (e.g. Eclipse) run-time environment, create a temporary working directory and change the value of the $GLA_HOME environment variable to the 
#        absolute path of the new temporary working directory.  Furthermore, create a $GLA_HOME/config directory and copy the contents of the org.eclipse.hyades.logging.adapter.config 
#        plug-in to the new $GLA_HOME/config directory.  Finally, create a $GLA_HOME/lib directory and copy the following JAR files to the new $GLA_HOME/lib directory:
#                    Plug-in                 |     JAR
#        ---------------------------------------------------
#        org.eclipse.hyades.logging.adapter  |  hgla.jar
#        org.eclipse.hyades.logging.core     |  hlcbe101.jar
#        org.eclipse.hyades.logging.core     |  hlcore.jar
#        org.eclipse.hyades.execution.remote |  hexr.jar
#        org.eclipse.emf.ecore               |  ecore.jar
#        org.eclipse.emf.common              |  common.jar

GLA_HOME=/home/eclipse/GenericLogAdapter
export GLA_HOME

CONFIG_FILE="$GLA_HOME/config/XML/CommonBaseEvent/v1.0.1/regex_example.adapter"
export CONFIG_FILE

CUR_DIR=`pwd`
export CUR_DIR

cd "$GLA_HOME/config/XML/CommonBaseEvent/v1.0.1"

java -DGLA_HOME="$GLA_HOME" -classpath "$GLA_HOME/lib/hgla.jar:$GLA_HOME/lib/hexr.jar:$GLA_HOME/lib/hlcbe101.jar:$GLA_HOME/lib/ecore.jar:$GLA_HOME/lib/common.jar:$GLA_HOME/lib/hlcore.jar" org.eclipse.hyades.logging.adapter.Adapter -ac "$CONFIG_FILE" -cc "$CONFIG_FILE"

cd "$CUR_DIR"

