/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;

import java.util.Properties;

import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This factory allows you to obtain a Database object. There is only one
 * factory object that you obtain by using the INSTANCE field.
 */
public interface DatabaseFactory {
	/**
	 * Creates a database object given the name of the database and the type of
	 * database. The database object that is obtained is always created, even
	 * though it may not be possible to open a connection to the database.
	 * 
	 * @param name
	 *            The database name
	 * @param properties
	 *            The database connection properties (username and password)
	 * @param type
	 *            The type of database
	 * @return A Database instance.
	 */
	Database createDatabase(String name, Properties properties, DatabaseType type);

	//  /**
	//   * Use this field to access an instance of the DatabaseFactory.
	//   */
	//  DatabaseFactory INSTANCE = new DatabaseFactoryImpl();
} // DatabaseFactory
