/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;

import org.eclipse.emf.common.util.URI;
/**
 * This exception is thrown if you get a resource but the resource with the
 * given URI is not in the database.
 */
public class ResourceNotFoundException extends Exception {
	protected URI uri;

	/**
	 * Constructor for ResourceNotFoundException.
	 */
	public ResourceNotFoundException(URI uri) {
		super("ResourceNotFoundException: "+uri.toString());
		this.uri = uri;
	}

	/**
	 * The URI of the resource that was not found.
	 */
	public URI getURI() {
		return uri;
	}
} // ResourceNotFoundException
