/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;

import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class counts the number of referenced objects for the object with the
 * given id and reference.
 */
public class GetCommpressedPathByURICommand extends GetIdByURICommand {
	public GetCommpressedPathByURICommand(JDBCHelper helper, DBMap map, String uri) {
		super(helper, map,uri);
	}

	/**
	 * Return an array of EObjects, or null.
	 */
	public Object execute() throws Exception {
		String commpressedPath = "";
		currentFragmentIndex=0;
		getRootObjectId();
		if(fragment==null)
		{
			return currentSourceId+"/";
		}
		else if(currentTargetReference!=null)
		{
			do {
				StatementFactory factory = StatementFactory.INSTANCE;
				QueryStatement query = factory.createGetTargetIdStatement(helper, dbMap, currentSourceId, currentTargetReference, currentTargetIndex);
				PerfUtil p = new PerfUtil("GetCommpressedPathByURICommand.execute() 1 statement="+query.getStatement(),true);
				ResultSet rs =null;
				Statement statement = helper.createStatement();
				try {
					rs = helper.executeQuery(statement, query.getStatement());
				} catch (Exception e) {
					p.stopAndPrintStatus(e.getLocalizedMessage());
					throw e;
				}
				p.stopAndPrintStatus();

				while (rs.next())
					currentSourceId = rs.getInt(1);
				rs.close();
				statement.close();
	
				commpressedPath = +currentSourceId + "/";
			} while (processNextObject());
		}	
		return commpressedPath;
	}

} // GetCommpressedPathByURICommand
