/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;

import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class gets the largest database id by looking it up in the id table.
 */
public class GetLargestDatabaseIdCommand extends DBCommand {
	public GetLargestDatabaseIdCommand(JDBCHelper helper, DBMap map) {
		super(helper, map);
	}

	public Object execute() throws Exception {
		if (dbMap.getIdTable() == null)
			return null;

		String query = createIdTableQuery(dbMap.getIdTable());
		Statement statement = helper.createStatement();
		ResultSet rs = helper.executeQuery(statement, query);
		int max = getInt(rs);
		rs.close();
		statement.close();
		return new Integer(max);
	}

	protected int getInt(ResultSet rs) throws Exception {
		if (rs.next())
			return rs.getInt(1);
		else
			return 0;
	}

	protected String createIdTableQuery(Table idTable) {
		StringBuffer query = new StringBuffer();
		String idColumn = ((Column) idTable.getColumns().get(0)).getName();
		query.append("SELECT ");
		query.append(addQuotes(idColumn));
		query.append(" FROM ");
		query.append(addQuotes(idTable.getName()));
		return query.toString();
	}
} // GetLargestDatabaseIdCommand
