/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This class generates an SQL SELECT statement that returns the positions of
 * the objects with the given targetId in the reference for the object with the
 * given sourceId.
 */
public class IndexQuery extends QueryStatement {
	protected Integer sourceId, targetId;
	protected Column source, target, order;

	public IndexQuery(DatabaseType type, DBMap map, Integer sourceId, EReference reference, Integer targetId) {
		super(type, map, reference);
		this.sourceId = sourceId;
		this.targetId = targetId;
		DBMap.ReferenceData data;
		data = (DBMap.ReferenceData) dbMap.getDBRepresentation(reference);
		source = data.getSourceColumn();
		target = data.getTargetColumn();
		order = data.getOrderColumn();
	}

	public String getStatement() {
		if (statement.length() != 0)
			return statement.toString();

		statement.append("SELECT ");
		statement.append(addQuotes(order.getName()));
		statement.append(" FROM ");
		statement.append(addQuotes(table.getName()));

		createWhereClause();
		return statement.toString();
	}

	protected void createWhereClause() {
		statement.append(" WHERE ");
		statement.append(addQuotes(source.getName()));
		statement.append(" = ");
		statement.append(sourceId);
		statement.append(" AND ");
		statement.append(addQuotes(target.getName()));
		statement.append(" = ");
		statement.append(targetId);
	}

	public EClass getEClass() {
		return null;
	}

	public String getKeyName() {
		return null;
	}
} // IndexQuery
