/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.PreparedStatement;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This class generates an SQL statement that inserts attribute values into an
 * attribute table.
 */
public class InsertAttributeValues extends InsertStatement {
	protected EAttribute attribute;
	protected int type;
	protected Object value;
	protected int position;
	protected DBMap.AttributeData data;

	public InsertAttributeValues(DBMap map, DatabaseType dbType, Map objectsToIds, EAttribute attribute, int type) {
		super(map, dbType, objectsToIds);
		this.attribute = attribute;
		this.type = type;
		data = (DBMap.AttributeData) dbMap.getDBRepresentation(attribute);
	}

	protected Table getTable() {
		return data.getTable();
	}

	protected List getColumns() {
		List columns = new ArrayList();
		columns.add(data.getIdColumn());
		columns.add(data.getValueColumn());
		columns.add(data.getOrderColumn());
		return columns;
	}

	protected void createRows(EObject object, boolean first) throws Exception {
		List values = (List) object.eGet(attribute);

		for (int i = 0, l = values.size(); i < l; i++) {
			value = values.get(i);
			position = i;
			addRow(object, first);

			if (first)
				first = false;
		}
	}

	protected void addRow(EObject object, boolean first) throws Exception {
		StringBuffer row = createRow(object);
		addRowToStatement(row, first);
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.impl.InsertStatement#createRow(EObject)
	 */
	protected StringBuffer createRow(EObject object) throws Exception {
		StringBuffer row = new StringBuffer();
		row.append("(");
		Integer id = (Integer) objectsToIds.get(object);
		row.append(id.toString());
		row.append(", ");
		appendValue(row, value, type);
		row.append(", ");
		row.append(position);
		row.append(")");
		return row;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.resources.database.internal.impl.InsertStatement#addBatchedRow(java.sql.PreparedStatement, org.eclipse.emf.ecore.EObject)
	 */
	protected void addBatchedRow(PreparedStatement ps, EObject object) throws Exception {
		int colPos=1;
		Integer id = (Integer) objectsToIds.get(object);
		appendBatchedValue(ps,colPos++, id,Types.INTEGER);
		appendBatchedValue(ps,colPos++, value,type);
		appendBatchedValue(ps,colPos++, new Integer(position),Types.INTEGER);
		ps.addBatch();
	}

	protected void addBatchedRows(PreparedStatement ps,EObject object) throws Exception {
		List values = (List) object.eGet(attribute);

		for (int i = 0, l = values.size(); i < l; i++) {
			value = values.get(i);
			position = i;
			if (debugPreparedStatement)
				statement.append("\nps_row="+(rowNr++)+"\n");
			addBatchedRow(ps,object);
		}
	}
	
} // InsertAttributeValues
