/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;
import java.sql.PreparedStatement;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This class generates an SQL insert statement that adds rows to association
 * tables.
 */
public class InsertReferences extends InsertStatement {
	protected EReference reference, opposite;
	protected boolean sourceOrder, isMany;
	protected Set proxies;
	protected InternalEObject refObject;
	protected int position;
	protected DBMap.ReferenceData data;
	public InsertReferences(DatabaseType type, EReference reference, DBMap map, Map objectsToIds, Set proxies) {
		super(map, type, objectsToIds);
		this.reference = reference;
		this.proxies = proxies;
		isMany = reference.isMany();
		data = (DBMap.ReferenceData) dbMap.getDBRepresentation(reference);
	}
	protected Table getTable() {
		return data.getTable();
	}
	/**
	 * Compute the columns in the reference table, based on the reference
	 * properties.
	 */
	protected List getColumns() {
		List columns = new ArrayList();
		columns.add(data.getSourceColumn());
		columns.add(data.getTargetColumn());
		if (data.getOrderColumn() != null)
			columns.add(data.getOrderColumn());
		opposite = reference.getEOpposite();
		if (opposite != null && opposite.isMany()) {
			DBMap.ReferenceData oppositeData = (DBMap.ReferenceData) dbMap.getDBRepresentation(opposite);
			if (oppositeData != null && oppositeData.getOrderColumn() != null) {
				sourceOrder = true;
				columns.add(oppositeData.getOrderColumn());
			}
		}
		return columns;
	}
	protected void createRows(EObject object, boolean first) throws Exception {
		if (!isMany) {
			refObject = (InternalEObject) object.eGet(reference);
			position = -1;
			addRow(object, first);
		} else {
			InternalEList list = (InternalEList) object.eGet(reference);
			Iterator it = list.basicIterator();
			position = 0;
			while (it.hasNext()) {
				refObject = (InternalEObject) it.next();
				addRow(object, first);
				if (first)
					first = false;
				++position;
			}
		}
	}
	protected void addRow(EObject object, boolean first) throws Exception {
		StringBuffer row = createRow(object);
		if (row != null)
			addRowToStatement(row, first);
	}
	/**
	 * @see org.eclipse.hyades.resources.database.internal.impl.InsertStatement#createRow(EObject)
	 */
	protected StringBuffer createRow(EObject object) throws Exception {
		Integer targetId = (Integer) objectsToIds.get(refObject);
		if (targetId == null)
			return null;
		StringBuffer row = new StringBuffer();
		row.append("(");
		Integer sourceId = (Integer) objectsToIds.get(object);
		row.append(sourceId.toString());
		row.append(", ");
		row.append(targetId.toString());
		if (position >= 0) {
			row.append(", ");
			row.append(position);
		}
		if (sourceOrder) {
			row.append(", ");
			if (!proxies.contains(refObject)) {
				List opposites = (List) refObject.eGet(opposite);
				row.append(opposites.indexOf(object));
			} else
				row.append("-1");
		}
		row.append(")");
		return row;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.resources.database.internal.impl.InsertStatement#addBatchedRow(java.sql.PreparedStatement,
	 *      org.eclipse.emf.ecore.EObject)
	 */
	protected void addBatchedRow(PreparedStatement ps, EObject object) throws Exception {
		Integer targetId = (Integer) objectsToIds.get(refObject);
		if (targetId == null)
			return;
		int colPos = 1;
		Integer sourceId = (Integer) objectsToIds.get(object);
		appendBatchedValue(ps, colPos++, sourceId, Types.INTEGER);
		appendBatchedValue(ps, colPos++, targetId, Types.INTEGER);
		if (position >= 0) {
			appendBatchedValue(ps, colPos++, new Integer(position), Types.INTEGER);
		}
		if (sourceOrder) {
			if (!proxies.contains(refObject)) {
				List opposites = (List) refObject.eGet(opposite);
				appendBatchedValue(ps, colPos++, new Integer(opposites.indexOf(object)), Types.INTEGER);
			} else
				appendBatchedValue(ps, colPos++, new Integer(-1), Types.INTEGER);
		}
		ps.addBatch();
	}
	protected void addBatchedRows(PreparedStatement ps, EObject object) throws Exception {
		if (!isMany) {
			refObject = (InternalEObject) object.eGet(reference);
			position = -1;
			if (debugPreparedStatement)
				statement.append("ps_total_rows=1\n");
			addBatchedRow(ps, object);
		} else {
			InternalEList list = (InternalEList) object.eGet(reference);
			Iterator it = list.basicIterator();
			position = 0;

			while (it.hasNext()) {
				refObject = (InternalEObject) it.next();
				if (debugPreparedStatement)
					statement.append("\nps_row="+(rowNr++)+"\n");
				addBatchedRow(ps, object);
				++position;
			}
		}
	}
} // InsertReferences
