/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.Statement;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class sets the given attribute to the given value for the object with
 * the given id.
 */
public class SetAttributeCommand extends DBCommand {
	protected Integer id;
	protected EAttribute attribute;
	protected Object value;

	public SetAttributeCommand(JDBCHelper helper, DBMap map, Integer id, EAttribute attribute, Object value) {
		super(helper, map);
		this.id = id;
		this.attribute = attribute;
		this.value = value;
	}

	public Object execute() throws Exception {
		SQLStatement sql = StatementFactory.INSTANCE.createSetAttributeStatement(dbType,dbMap, id, attribute, value);
		Statement statement = helper.createStatement();
		String sqlString = sql.getStatement();

		if (debug)
			System.out.println(sqlString);

		helper.execute(statement, sqlString);
		statement.close();
		return null;
	}
} // SetAttributeCommand
