/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.internal.util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.outputters.CBEFileOutputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
/**
 * @author smith
 *
 * This Outputter writes CBE's to a file but creates a new file if it
 * can't write to an existing file.
 * 
 */
public class AdapterLogFileOutputter extends CBEFileOutputter implements IOutputter
{
	/**
	 * Prepare the file for the log CBE output
	 */
	protected void prepareFile() throws AdapterInvalidConfig 
	{
		/* If the directory does not end with the proper file
		 * separator then we need to add one.  RKD:  We probably
		 * need to make sure we convert incorrect path separators
		 * to the proper platform.
		 */
		String pathSeparator=System.getProperty("file.separator");
		if(getDirectory().endsWith(pathSeparator)) {
			rawLogFileName = getDirectory() + getFileName();
		}
		else {
			rawLogFileName = getDirectory() + pathSeparator + getFileName();
		}
	}
	
	/**
	 * Set the FileWriter for this File Outputter
	 */
	protected void setFileWriter() throws AdapterException
	{

		File hglaLogFile = new File(rawLogFileName);
		
		if (hglaLogFile.exists() && !hglaLogFile.canWrite()) {
			/* If the gla log file specified in the adapter exists but cannot be  
			 * written to then create a new log file name using a random number. 
			 */
			String fileExt = (new Double(Math.random())).toString();
			setFileName(getFileName() + fileExt.substring(1));
			String pathSeparator=System.getProperty("file.separator");
			if(getDirectory().endsWith(pathSeparator)) {
				rawLogFileName = getDirectory() + getFileName();
			}
			else {
				rawLogFileName = getDirectory() + pathSeparator + getFileName();
			}
		}

		try {
			fw = new FileWriter(rawLogFileName);
		}
		catch (IOException ioe) {
		    
		    CommonBaseEvent event = getEventFactory().createCommonBaseEvent();
		    
		    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Create_ERROR_");
		    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{getUniqueID(),rawLogFileName});							    

		    event.setSeverity(CommonBaseEvent.SEVERITY_FATAL);

		    log(event);

			/* Throw an exception if we cannot create the file writer.
			 */
			throw new AdapterException(Messages.getString("HyadesGA_CBE_File_Outputter_Create_ERROR_", getUniqueID(),rawLogFileName));
		}
	}	
}
