package org.eclipse.hyades.logging.adapter.internal.util;


import org.eclipse.hyades.logging.adapter.AdapterPlugin;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.Messages;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
public class ComponentLoaderUtil
{
	/**
	 * Instatiate an object and guarantee its class.
	 * @param className The name of the class to instantiate.
	 * @param impls The name of the class it subclases.
	 **/
	public static Object instantiate(String className, String impls) throws PreparationException  {
	    try	{
	        /* First we will assume we are running inside of Eclipse. Look at our extensions to see 
			 * if anyone has provided this class in another plugin.
			 */
	        IComponent component = AdapterPlugin.getComponent(className);
			
			if(component != null){
			    return component;
			}
		}
		catch(Throwable  e) {
		}
		
		Class c;
		try {
		    c = Class.forName(impls);
		}
		catch(ClassNotFoundException eprime) {
			throw new PreparationException(Messages.getString("HyadesGAClassLoad_ERROR_", impls));
		}
		
		try {
				
			Class o = Class.forName(className);
			Object res = null;
			
			try {
			    
			    //Attempt to create an instance of the class using the no-argument constructor:
			    res = o.newInstance();
            } 
			catch (Throwable t) {
			    
			    //If the no-argument constructor of the class is privatized, attempt 
			    //to retrieve the reference to the singleton instance of the class:
			    res = o.getMethod("getInstance", null).invoke(null, null);
            }
						
			if (c.isInstance(res)) {
				return res;
			}
			else {
				throw new PreparationException(className + " is not an instance of " + impls);
			}
		}
		catch(ClassNotFoundException eprime) {
			throw new PreparationException(Messages.getString("HyadesGAClassLoad_ERROR_", className));
		}
		catch (IllegalAccessException eprime) {
			throw new PreparationException(Messages.getString("HyadesGAAccess_ERROR_", className));
		}
		catch (Throwable eprime) {
			throw new PreparationException(Messages.getString("HyadesGAInstantiation_ERROR_", className),eprime);
		}
	}
}