/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.outputters;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
/**
 * CBEstdoutOutputter is a sample outputter that takes the given CBEs and
 * outputs them to standard out.
 *
 */
public class CBEstdoutOutputter extends ProcessUnit implements IOutputter
{
	public Object[] processEventItems(Object[] msgs)
	{
		if (msgs == null)
		return msgs;
		else
		return processCBEs((CommonBaseEvent[]) msgs);
	}
	private CommonBaseEvent[] processCBEs(CommonBaseEvent[] events)
	{
		for (int i = 0; i < events.length; i++)
		{
			if (events[i] != null) {
				System.out.println(EventFormatter.toCanonicalXMLString(events[i],false));
				incrementItemsProcessedCount();
			}
		}
		return events;
	}
	public Object[] testEventInterface(Object[] msgs) throws AdapterInvalidConfig
	{
		return testProcessCBEs((CommonBaseEvent[]) msgs);
	}
	private CommonBaseEvent[] testProcessCBEs(CommonBaseEvent[] events)
	{
		return events;
	}
}
