/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.util;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * This class migrates a pre 1.3 sensor configuration to a 1.3 
 * sensor configuration.
 */
public class SensorMigrator implements IComponentMigrator {
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.logging.adapter.util.IComponentMigrator#migrate(org.w3c.dom.Element)
	 */
	public Element migrate(Element oldSensorConfiguration) throws AdapterMigrationException {
		boolean migrated = false;
		Element newSensorConfiguration = null;
		Document doc;
		try {
			doc = oldSensorConfiguration.getOwnerDocument();

			newSensorConfiguration = (Element)oldSensorConfiguration.cloneNode(false);
			
			// Remove the type attribute		
			if (newSensorConfiguration.hasAttribute(Messages.getString("HyadesGAtypeAttributeName"))) {
				newSensorConfiguration.removeAttribute(Messages.getString("HyadesGAtypeAttributeName"));
				migrated = true;
			}
			
			Element sensorNode;
			Element sensorProperty;
			
			String propertyValue;
			String propertyName;
				
			// Get the sensor children (should only be one sensor type instance)
			NodeList sensorNodes = oldSensorConfiguration.getChildNodes();
			for (int k = 0; k < sensorNodes.getLength(); k++) {
				if (sensorNodes.item(k).getNodeType() == Node.ELEMENT_NODE) {
					sensorNode = (Element) sensorNodes.item(k);
					// Process the sensor type instance attributes
					if (sensorNode.getTagName().equals(Messages.getString("HyadesGAStaticParserSensorTagName")) ||
						sensorNode.getTagName().equals(Messages.getString("HyadesGASingleFileSensorTagName"))) {

						// Get the sensor type attributes and convert them to properties
						NamedNodeMap sensorTypeAttributeList = sensorNode.getAttributes();
						int sensorTypeAttributeCount = sensorTypeAttributeList.getLength();
						String converter;
				
						for(int j = 0; j < sensorTypeAttributeCount; ++j)
						{
							Node sensorTypeAttribute = sensorTypeAttributeList.item(j);
							propertyName = sensorTypeAttribute.getNodeName();
							propertyValue = sensorTypeAttribute.getNodeValue();
							
							sensorProperty = doc.createElement(Messages.getString("HyadesGAPropertyElementTagName"));
							sensorProperty.setAttribute(Messages.getString("HyadesGAPropertyValueAttributeName"), propertyValue);
							sensorProperty.setAttribute(Messages.getString("HyadesGAPropertyNameAttributeName"), propertyName);
							newSensorConfiguration.appendChild(sensorProperty);

						}
							
						// Get the sensor properties for this sensor type instance and create new property elements for the new configuration
						NodeList sensorPropertyList = sensorNode.getElementsByTagName(Messages.getString("HyadesGASensorPropertyElementTagName"));
						int sensorPropertyCount = sensorPropertyList.getLength();
						for(int j = 0; j < sensorPropertyCount; ++j)
						{
							Element oldSensorProperty = (Element)sensorPropertyList.item(j);
							sensorProperty = doc.createElement(Messages.getString("HyadesGAPropertyElementTagName"));
							propertyName = oldSensorProperty.getAttribute(Messages.getString("HyadesGASensorPropertyNameAttributeName"));
							propertyValue = oldSensorProperty.getAttribute(Messages.getString("HyadesGASensorPropertyValueAttributeName"));
							sensorProperty.setAttribute(Messages.getString("HyadesGAPropertyValueAttributeName"), propertyValue);
							sensorProperty.setAttribute(Messages.getString("HyadesGAPropertyNameAttributeName"), propertyName);
							newSensorConfiguration.appendChild(sensorProperty);
						}

						if (sensorTypeAttributeCount > 0 || sensorPropertyCount > 0)
							migrated = true;
					}
				}
			}			
		}
		catch (Exception e) {
			throw new AdapterMigrationException("bad error", e);
		}
		
		// If we didn't migrate anything then don't return the new configuration	
		if (!migrated)
			newSensorConfiguration = null;
				
		return newSensorConfiguration;
	}

}
