/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Enumeration;
import java.util.Vector;


public class OverallThreadPool
{

   public OverallThreadPool( DumpData d )
   {
      _d = d;
   }

   private OverallThreadPool()
   {

   }


   public Object[] getTosGridHeaders()
   {
	   return new Object[] { TAUtils.getNLSValue("ta.string.Method", "Method"),
							 TAUtils.getNLSValue("ta.string.Same", "#Same"),
							 TAUtils.getNLSValue("ta.string.PctOfTotal", "Pct Of Total"),
							 TAUtils.getNLSValue("ta.string.Weight", "Weight")
						   };
   }

   public TaGridElement[][] getTosGrid()
   {

      TaGridElement[][] ga = null;

      if( _d._threadsByTOS != null )
      {
         int poolSize = 0;
         Enumeration e = _d._threadsByTOS.keys();
         Vector gridElements = new Vector();
         //if( ! e.hasMoreElements() )
         //{
         //   System.err.println( "-->No TOS keys!??" );
         //}

         while( e.hasMoreElements() )
         {
            String tosKey = (String)e.nextElement();
            //System.err.println( "TOSKey--> " + tosKey );
            Vector v  = (Vector)_d._threadsByTOS.get( tosKey );
            int sameTos = 0;
            int weightFactor = 0;

            TaGridElement[] ge = null;

            for( int i = 0; i < v.size(); ++i )
            {

               Thd thd = (Thd)v.elementAt( i );
               //System.err.println( "\t--> " + thd.getName() );
               ++sameTos;
               ++poolSize;
               weightFactor += ( (thd.waitingForWebWork() || thd.waitingForOrbWork() ) ? 0 : 1 );
            }

            if( sameTos > 0 )
            {
               //System.out.println( "--> creating grid element line for " + tosKey );
               String tosInfo = null;
               try
               {
                  _d._tosTrans.getString( tosKey );
               }
               catch( Exception ex )
               {
               }
               ge = new TaGridElement[4];
//               ge[ 0 ] = new TaTosWeightGridElement( weightFactor * sameTos, "Higher weight factors may indicate a need to review the code path and/or resource utilization." );
               ge[ 0 ] = new TaTosNameGridElement( tosKey , (tosInfo != null ? tosInfo : TAUtils.getNLSValue("ta.msg.NoMoreInfo", "no additional information") ));
               ge[ 1 ] = new TaTosThdCountGridElement( sameTos, TAUtils.getNLSValue("ta.msg.SystemFunctions", "System functions *may* show high associated thread counts when waiting for work.  Careful analysis is required.") );
               ge[ 2 ] = new TaTosPctPoolGridElement( 0 /* don't know yet*/ , (tosInfo != null ? tosInfo : TAUtils.getNLSValue("ta.msg.NoMoreInfo", "no additional information") ));
               ge[ 3 ] = new TaTosWeightGridElement( weightFactor, TAUtils.getNLSValue("ta.msg.HigherWeightFactors", "Higher weight factors may indicate a need to review the code path and/or resource utilization.") );
               gridElements.add( ge );
            }
         }

         //System.err.println( "--> gridelements: " + gridElements.size() );

         if( gridElements.size() > 0 )
         {
            ga = new TaGridElement[ gridElements.size() ][ 4 ];
            for( int i = 0; i < gridElements.size(); ++i )
            {
               TaGridElement gea[] = null;
               gea = (TaGridElement[])gridElements.elementAt( i );
               for( int j = 0; j < gea.length; ++j )
               {
                  ga[ i ][ j ] = gea[ j ];
               }
            }
            int totPct = 0; 
            TaTosPctPoolGridElement greatestElem = null;
            int greatestPct = 0;
            for( int i = 0; i < ga.length; ++i )
            {
               TaTosPctPoolGridElement tmp = (TaTosPctPoolGridElement)ga[ i ][ 2 ];
               TaTosThdCountGridElement thdCountElem = (TaTosThdCountGridElement)ga[ i ][ 1 ];
               int pct = (int)(Math.round((double)thdCountElem.getThdCount()/(double)poolSize * 100));
               totPct += pct;
               tmp.setPctOfPool( pct );
               if( pct > greatestPct )
               {
                  greatestPct = pct;
                  greatestElem = tmp;
               }
            }
            sort( ga, 2 );
            int errPct = totPct - 100;
            int loopCt = 10;
            while( errPct != 0 && loopCt > 0 )
            {
               for( int i = 0; i < ga.length; ++i )
               {
                  TaTosPctPoolGridElement tmp = (TaTosPctPoolGridElement)ga[ i ][ 2 ];
                  //System.out.println( "Pct = " + tmp.getPctOfPool() );
                  if( errPct == 0 )
                     break;
                  if( errPct > 0 && tmp.getPctOfPool() > 1 )
                  {                     
                     tmp.setPctOfPool( tmp.getPctOfPool() - 1 );
                     --errPct;
                  }
                  else if( errPct < 0 )
                  {
                     tmp.setPctOfPool( tmp.getPctOfPool() + 1 );
                     ++errPct;
                  }
               }
            }
            sort( ga, 3 );
         }

      }
      return ga;
   }

   protected void sort( TaGridElement[][] gea, int sortCol ) 
   {
      int elements = gea.length;
      if( elements > 0 )
      {
         int width = gea[ 0 ].length;
         for( int i = 0; i < elements; ++i )
            for( int j = 0; j < elements-1; ++j )
            {
               TaGridElement e1 = gea[ j ][ sortCol ];
               TaGridElement e2 = gea[ j+1 ][ sortCol ];
               if( e1.compareTo( e2 ) > 0 )
               {
                  TaGridElement[] tmp = gea[j];
                  gea[ j ] = gea[ j+1 ];
                  gea[ j+1 ] = tmp;
               }


            }
      }
   }

   private DumpData _d = null;
}
