/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;

//B import com.ibm.ws.performance.threadanalyzer.tagui.TaGUI;

public class TAProject implements Externalizable
{
   private int _version = -1;
   private static int _curVersion = 3;

   public TAProject()
   {
      _version = _curVersion;
      _myDumpDatas = new Vector();
      _description = new String("");
      _uniqueId = 0;
   }

   public String getDescription()
   {
      return _description;
   }

   public int getUniqueId()
   {
      return ++_uniqueId;
   }


   public void setDescription( String description )
   {
      if(!(description.equals(_description)))
      {
         modified = true;
      }

      _description = description;

   }


   public Enumeration getDumps()
   {
      return _myDumpDatas.elements();
   }

   public void addDump(DumpData dump)
   {
      _myDumpDatas.add(dump);
      modified = true;
   }

   public DumpData getDump(int i)
   {
      if(i < _myDumpDatas.size())
      {
         return(DumpData)_myDumpDatas.elementAt(i);
      }
      return null;
   }


   public void deleteDump(String dumpName)
   {
      int found = -1;
      for(int i = 0; i < _myDumpDatas.size(); i++)
      {
         if(((DumpData)_myDumpDatas.elementAt(i)).getDisplayName().equals(dumpName))
         {
            found = i;
         }
      }
      if(found != -1)
      {
         deleteDump(found);
         modified = true;
      }

   }

   public void changeName(String old, String newName)
   {
      int found = -1;
      for(int i = 0; i < _myDumpDatas.size(); i++)
      {
         if(((DumpData)_myDumpDatas.elementAt(i)).getDisplayName().equals(old))
         {
            found = i;
         }
      }
      if(found != -1)
      {
         ((DumpData)_myDumpDatas.elementAt(found)).setDisplayName(newName);            
         modified = true;
      }


   }

   public String getDumpDescrip(String old)
   {
      int found = -1;
      for(int i = 0; i < _myDumpDatas.size(); i++)
      {
         if(((DumpData)_myDumpDatas.elementAt(i)).getDisplayName().equals(old))
         {
            found = i;
         }
      }
      if(found != -1)
      {
         return((DumpData)_myDumpDatas.elementAt(found)).getDescription();            

      }

      return "";

   }

   public void setDumpDescrip(String old, String descrip)
   {
      int found = -1;
      for(int i = 0; i < _myDumpDatas.size(); i++)
      {
         if(((DumpData)_myDumpDatas.elementAt(i)).getDisplayName().equals(old))
         {
            found = i;
         }
      }
      if(found != -1)
      {
         ((DumpData)_myDumpDatas.elementAt(found)).setDescription(descrip);            
         modified = true;
      }


   }




   public boolean doesNameExist(String dumpName)
   {
      int found = -1;
      for(int i = 0; i < _myDumpDatas.size(); i++)
      {
         if(((DumpData)_myDumpDatas.elementAt(i)).getDisplayName().equals(dumpName))
         {
            found = i;
         }
      }
      if(found == -1)
      {
         return false;
      }
      return true;
   }

   public int numNames(String dumpName)
   {
      int found = 0;
      String origName = null;
      for(int i = 0; i < _myDumpDatas.size(); i++)
      {
         origName = ((DumpData)_myDumpDatas.elementAt(i)).getDisplayName();
         if(origName.indexOf("- #") != -1)
         {
            origName = origName.substring(0,origName.indexOf("- #"));
         }
         if(origName.equals(dumpName))
         {
            found++;
         }
      }
      return found;

   }

   public void deleteDump(int i)
   {
      if(i < _myDumpDatas.size())
      {
         _myDumpDatas.remove(i);
      }
   }

   public void writeTo( String fileName ) throws Exception
   {
      try
      {
         FileOutputStream fo = new FileOutputStream( fileName );
         ObjectOutputStream so = new ObjectOutputStream( fo );
         writeExternal( so );            
         so.flush();
         so.close();
      }
      catch( Exception e )
      {
         e.printStackTrace();
         throw e;
      }
   }

   public static TAProject readFrom( String fileName ) throws Exception
   {
      TAProject cnew = new TAProject();
      try
      {
//B      TaGUI.getOpenExistingDialog().append( "\r\nReading binary data\r\n" );
         FileInputStream fi = new FileInputStream( fileName );
         ObjectInputStream si = new ObjectInputStream( fi );  
         cnew.readExternal( si );
         si.close();
      }
      catch( Exception e )
      {
         e.printStackTrace();
         throw e;
      }

      return cnew;

   }

   public void writeExternal( ObjectOutput out ) throws IOException
   {

      out.writeInt( _curVersion );
      //out.writeObject( _myDumpDatas );
      DumpData myDumpData = null;
      int dumpCount = _myDumpDatas.size();
      out.writeInt( dumpCount );
      for(int i = 0; i < dumpCount; i++)
      {
         myDumpData = (DumpData)_myDumpDatas.elementAt(i);
         myDumpData.writeExternal( out );
      }

      // writing out version 2 data
      out.writeObject( _description );
      // write out version 3 data
      out.writeInt( _uniqueId );
   }

   public void readExternal( ObjectInput in ) throws IOException, ClassNotFoundException
   {
      _version = in.readInt();
      //_myDumpDatas = (Vector)in.readObject();
      DumpData myDumpData = null;
      _myDumpDatas = new Vector();
      int dumpCount = in.readInt();
      for(int i = 0; i < dumpCount; i++)
      {
         myDumpData = new DumpData();
         myDumpData.readExternal( in );
         _myDumpDatas.add( myDumpData );
      }
      if(_version >= 2)
      {
         _description = (String)in.readObject();
      }
      if( _version >= 3 )
      {
         _uniqueId = (int)in.readInt();
      }
      // always set current version
      _version = _curVersion;
   }


   public void initSetup()
   {
      DumpData myDumpData = null;

      for(int i = 0; i < _myDumpDatas.size(); i++)
      {
         myDumpData = (DumpData)_myDumpDatas.elementAt(i);
         myDumpData.initAnalysis();
      }
   }

   public int getNumDumps()
   {
      return _myDumpDatas.size();
   }

   public boolean isModified()
   {
      return modified;
   }

   public void setModified(boolean mod)
   {
      modified = mod;
   }

   //private String dummyStreamTestVar = null;

   private Vector _myDumpDatas = null;
   // end of version 1 data
   // place version 2 data below 
   protected String _description = null;
   // end of version 2 data
   // place version 3 data below 
   protected int _uniqueId = 0;


   //
   // static and transient data should be placed here
   //
   transient boolean modified = false;


}

