/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.datacollection;

import java.util.Hashtable;

import org.eclipse.hyades.internal.config.generator.*;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetConfig extends SetConfigSkeleton {
	public static String TAG = "org.eclipse.hyades.datacollection";

	public SetConfig() {
		super(TAG);
		Logger.out("SetConfig constructor called");
	}

	public void init(Hashtable hash) {
		String home = HashUtility.getValue(hash, "RASERVER_HOME");
		setFileName(home + sr + "plugins" + sr + TAG + sr + "config" + sr + "pluginconfig.xml");
	}

	public void askUser() {
		// Bug 74089 begins
		// JBOSS_HOME
		if(silent) {
			if (configFile.getValue("JBOSS_HOME") == null) {
				configFile.setValue("JBOSS_HOME", "");
			}
		}
		else {
			if (configFile.getValue("JBOSS_HOME") == null) {
				configFile.setValue("JBOSS_HOME", promptJBossHome(""));
			}
			else {
				configFile.setValue("JBOSS_HOME", promptJBossHome(configFile.getValue("JBOSS_HOME")));
			}
		}
		// Bug 74706
		if((configFile.getValue("JBOSS_HOME") == null) || (configFile.getValue("JBOSS_HOME").equals(""))) {
			configFile.setValue("JBOSS_HOME", "null");
		}
	
		// JONAS_HOME
		if(silent) {
			if (configFile.getValue("JONAS_HOME") == null) {
				configFile.setValue("JONAS_HOME", "");
			}
		}
		else {
			if (configFile.getValue("JONAS_HOME") == null) {
				configFile.setValue("JONAS_HOME", promptJOnASHome(""));
			}
			else {
				configFile.setValue("JONAS_HOME", promptJOnASHome(configFile.getValue("JONAS_HOME")));
			}
		}
		// Bug 74706
		if((configFile.getValue("JONAS_HOME") == null) || (configFile.getValue("JONAS_HOME").equals(""))) {
			configFile.setValue("JONAS_HOME", "null");
		}
		// Bug 74089 ends
	}

	private String promptJBossHome(String defaultValue) {
		System.out.println(getString("Config.Prompt.JBOSS_HOME.Tag"));
		System.out.print("  " + getString("Config.Prompt.Default") + "\"" + defaultValue + "\"");
		System.out.print(" (");
		System.out.print(getString("Config.Prompt.DefaultAccept"));
		System.out.println(")");
		System.out.print("  " + getString("Config.Prompt.NewValue"));
		return ConfigUtility.askUser(defaultValue);
	}

	private String promptJOnASHome(String defaultValue) {
		System.out.println(getString("Config.Prompt.JONAS_HOME.Tag"));
		System.out.print("  " + getString("Config.Prompt.Default") + "\"" + defaultValue + "\"");
		System.out.print(" (");
		System.out.print(getString("Config.Prompt.DefaultAccept"));
		System.out.println(")");
		System.out.print("  " + getString("Config.Prompt.NewValue"));
		return ConfigUtility.askUser(defaultValue);
	}

	public void generateConfiguration() {
		Document doc;
		Element holder;
		Element pConfig;

		Element aEnv;
		Element agent;
		Element app;
		Element option;
		Element var;

		//
		// Standard initializer 
		//
		doc = configFile.getDoc();
		if(doc == null) {
			return;
		}

		pConfig = doc.createElement(PluginConfig.TAG);
		holder = configFile.getHolder();
		holder.appendChild(pConfig);

		//
		// Plugin specific information
		//
		// Bug 74089 begins
		aEnv = doc.createElement(AgentControllerEnvironment.TAG);
		AgentControllerEnvironment.setConfiguration(aEnv, "default");
		pConfig.appendChild(aEnv);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "JBOSS_HOME");
		Variable.setPosition(var, "replace");
		Variable.setValue(var, configFile.getValue("JBOSS_HOME"));
		aEnv.appendChild(var);

		var = doc.createElement(Variable.TAG);
		Variable.setName(var, "JONAS_HOME");
		Variable.setPosition(var, "replace");
		Variable.setValue(var, configFile.getValue("JONAS_HOME"));
		aEnv.appendChild(var);
		// Bug 74089 ends

		if(PlatformObject.name.startsWith("Windows")) {
			app = doc.createElement(Application.TAG);
			Application.setConfiguration(app, "default");
			Application.setExecutable(app, "PerfmonAgent");
			Application.setLocation(app, "%RASERVER_HOME%" + sr + "bin");
			Application.setPath(app, "%RASERVER_HOME%" + sr + "bin" + sr + "PerfmonAgent" + PlatformObject.exeExt);
			pConfig.appendChild(app);
		}

		agent = doc.createElement(Agent.TAG);
		Agent.setConfiguration(agent, "default");
		Agent.setName(agent, "Java Profiling Agent");
		Agent.setClient(agent, "DYNAMIC");
		if(PlatformObject.name.startsWith("Windows")) {
			Agent.setDataChannelSize(agent, "64M");
		}
		else {
			Agent.setDataChannelSize(agent, "30M");
		}
		Agent.setType(agent, "Profiler");
		pConfig.appendChild(agent);

		option = doc.createElement(Option.TAG);
		Option.setName(option, "Thread Analysis Agent");
		Option.setType(option, "Profiler");
		Option.setValue(option, "hcthread");
		pConfig.appendChild(option);

		//
		// The following can be reused for other plugins
		//
		option = doc.createElement(Option.TAG);
		Option.setName(option, TAG);
		Option.setType(option, "version");
		Option.setValue(option, getString("Config.Plugin.Version"));
		pConfig.appendChild(option);

		configFile.saveToFile();
	}

	public void printHelp() {
	}

	public void printExamples() {
	}

}
