/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.internal.config.generator;

import org.w3c.dom.Element;

public class AgentControllerConfig extends ConfigElement {
	public final static String TAG = ConfigUtility.getString("Config.AgentControllerConfig.Tag");

	public static void setActiveConfiguration(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.ActiveConfig.Tag"), value);
	}

	public static void setJvm(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.Jvm.Tag"), value);
	}

	public static void setLoggingDetail(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.LoggingDetail.Tag"), value);
	}

	public static void setLoggingLevel(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.LoggingLevel.Tag"), value);
	}

	public static void setPort(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.Port.Tag"), value);
	}

	public static void setSecuredPort(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.SecurePort.Tag"), value);
	}

	public static void setVersion(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.Version.Tag"), value);
	}

	 // Bug 60082
	public static void setFilePort(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.FilePort.Tag"), value);
	}

	// Bug 59316
	public static void setProcessPolling(Element elem, String value) {
		elem.setAttribute(ConfigUtility.getString("Config.AgentControllerConfig.ProcessPolling.Tag"), value);
	}
}
