/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.internal.config.generator;

import java.util.Hashtable;
import java.util.MissingResourceException;

public abstract class SetConfigSkeleton {
	public ConfigFile configFile = null; // the actual config file object
	public static String sr = PlatformObject.sr; // separator char for this platform
	public static String pr = PlatformObject.pr;
	public static boolean silent = false; // run the generator silently
	public static boolean overwrite = false; // overwrite existing config file
	public static boolean verify = true;
	private String pluginName = null;
	private String fileName = null; // FQ file name
	private ClassLoader loader = null; // class loader for this class

	public abstract void init(Hashtable hash);
	public abstract void askUser();
	public abstract void generateConfiguration();
	public abstract void printHelp();
	public abstract void printExamples();

	public void run(Hashtable hash) {
		run(hash, false, false);
	}

	public void run(Hashtable hash, boolean bSilent, boolean bOverwrite) {
		silent = bSilent;
		overwrite = bOverwrite;

		if(fileName != null) {
			configFile = new ConfigFile(fileName);
			configFile.init(hash);

			askUser();
			generateConfiguration();
		}
	}

	public SetConfigSkeleton() {
		this(null);
	}

	public SetConfigSkeleton(String pluginName) {
		if(pluginName != null) {
			this.pluginName = pluginName;
		}
	}

	public void setLoader(ClassLoader _loader) {
		loader = _loader;
	}

	public ClassLoader getLoader() {
		return loader;
	}

	/**
	 * Return the resource string associated with the class
	 * @param tag The tag of the string
	 * @return The resolved string 
	 */
	public String getString(String tag) {
		String rc = null;

		if(loader == null) {
			rc = ConfigUtility.getString(tag);
		}
		else {
			try {
				Logger.out("Looking for resource under: " + pluginName + ".SetConfig");
				rc = ConfigUtility.getString(loader, pluginName + ".SetConfig", tag);
			} catch(MissingResourceException e) {
				rc = ConfigUtility.getString(tag);
			}
		}
		return rc;
	}

	/**
	 * Trimming off the leading and trailing while spaces
	 * @param str String to be trimmed
	 * @return The resulting string
	 */
	public String trim(String str) {
		if((str == null) || (str.length() == 0)) {
			return null;
		}
		else {
			int start = 0; // position of the first non-quote and non-space char
			int end = str.length() - 1; // position of the last non-quote and non-space char

			while((start < end) && ((str.charAt(start) == ' ') || (str.charAt(start) == '\"') || (str.charAt(start) == '\''))) {
				start++;
			}

			while((end > start) && ((str.charAt(end) == ' ') || (str.charAt(end) == '\"') || (str.charAt(end) == '\''))) {
				end--;
			}

			if(start != end) {
				return str.substring(start, end + 1);
			}
			else {
				return null;
			}
		}
	}

	/**
	 * @param fileName The fileName to set.
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
}
