/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: SimpleBinaryExpression.java,v 1.6 2004/11/25 23:21:06 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Simple Binary Expression</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getRightOperand <em>Right Operand</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getOperator <em>Operator</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getSearchQuery <em>Search Query</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getInstanceQuery <em>Instance Query</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getOperand <em>Operand</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getSimpleBinaryExpression()
 * @model 
 * @generated
 */
public interface SimpleBinaryExpression extends EObject{
	/**
	 * Returns the value of the '<em><b>Right Operand</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Right Operand</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Right Operand</em>' attribute.
	 * @see #setRightOperand(Object)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getSimpleBinaryExpression_RightOperand()
	 * @model 
	 * @generated
	 */
	Object getRightOperand();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getRightOperand <em>Right Operand</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Right Operand</em>' attribute.
	 * @see #getRightOperand()
	 * @generated
	 */
	void setRightOperand(Object value);

	/**
	 * Returns the value of the '<em><b>Operator</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operator</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operator</em>' attribute.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators
	 * @see #setOperator(RelationalOperators)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getSimpleBinaryExpression_Operator()
	 * @model 
	 * @generated
	 */
	RelationalOperators getOperator();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getOperator <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operator</em>' attribute.
	 * @see org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators
	 * @see #getOperator()
	 * @generated
	 */
	void setOperator(RelationalOperators value);

	/**
	 * Returns the value of the '<em><b>Search Query</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getWhereExpressions <em>Where Expressions</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Search Query</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Search Query</em>' container reference.
	 * @see #setSearchQuery(SimpleSearchQuery)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getSimpleBinaryExpression_SearchQuery()
	 * @see org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery#getWhereExpressions
	 * @model opposite="whereExpressions"
	 * @generated
	 */
	SimpleSearchQuery getSearchQuery();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getSearchQuery <em>Search Query</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Search Query</em>' container reference.
	 * @see #getSearchQuery()
	 * @generated
	 */
	void setSearchQuery(SimpleSearchQuery value);

	/**
	 * Returns the value of the '<em><b>Instance Query</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery#getConditions <em>Conditions</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Instance Query</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Instance Query</em>' container reference.
	 * @see #setInstanceQuery(InstanceQuery)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getSimpleBinaryExpression_InstanceQuery()
	 * @see org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery#getConditions
	 * @model opposite="conditions" required="true"
	 * @generated
	 */
	InstanceQuery getInstanceQuery();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getInstanceQuery <em>Instance Query</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Instance Query</em>' container reference.
	 * @see #getInstanceQuery()
	 * @generated
	 */
	void setInstanceQuery(InstanceQuery value);

	/**
	 * Returns the value of the '<em><b>Operand</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operand</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operand</em>' reference.
	 * @see #setOperand(LeftOperand)
	 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage#getSimpleBinaryExpression_Operand()
	 * @model 
	 * @generated
	 */
	LeftOperand getOperand();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression#getOperand <em>Operand</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operand</em>' reference.
	 * @see #getOperand()
	 * @generated
	 */
	void setOperand(LeftOperand value);

} // SimpleBinaryExpression
