/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: OrderByElementImpl.java,v 1.6 2004/11/25 23:21:06 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.LeftOperand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Order By Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.OrderByElementImpl#getOperator <em>Operator</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.OrderByElementImpl#getOperand <em>Operand</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.OrderByElementImpl#getSearchQuery <em>Search Query</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class OrderByElementImpl extends EObjectImpl implements OrderByElement {
	/**
	 * The default value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected static final OrderByOperators OPERATOR_EDEFAULT = OrderByOperators.ASC_LITERAL;

	/**
	 * The cached value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected OrderByOperators operator = OPERATOR_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOperand() <em>Operand</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperand()
	 * @generated
	 * @ordered
	 */
	protected LeftOperand operand = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrderByElementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ExtensionsPackage.eINSTANCE.getOrderByElement();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OrderByOperators getOperator() {
		return operator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperator(OrderByOperators newOperator) {
		OrderByOperators oldOperator = operator;
		operator = newOperator == null ? OPERATOR_EDEFAULT : newOperator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.ORDER_BY_ELEMENT__OPERATOR, oldOperator, operator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LeftOperand getOperand() {
		return operand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOperand(LeftOperand newOperand, NotificationChain msgs) {
		LeftOperand oldOperand = operand;
		operand = newOperand;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND, oldOperand, newOperand);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperand(LeftOperand newOperand) {
		if (newOperand != operand) {
			NotificationChain msgs = null;
			if (operand != null)
				msgs = ((InternalEObject)operand).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND, null, msgs);
			if (newOperand != null)
				msgs = ((InternalEObject)newOperand).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND, null, msgs);
			msgs = basicSetOperand(newOperand, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND, newOperand, newOperand));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SimpleSearchQuery getSearchQuery() {
		if (eContainerFeatureID != ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY) return null;
		return (SimpleSearchQuery)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSearchQuery(SimpleSearchQuery newSearchQuery) {
		if (newSearchQuery != eContainer || (eContainerFeatureID != ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY && newSearchQuery != null)) {
			if (EcoreUtil.isAncestor(this, newSearchQuery))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSearchQuery != null)
				msgs = ((InternalEObject)newSearchQuery).eInverseAdd(this, ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS, SimpleSearchQuery.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newSearchQuery, ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY, newSearchQuery, newSearchQuery));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND:
					return basicSetOperand(null, msgs);
				case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
					return eBasicSetContainer(null, ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
					return ((InternalEObject)eContainer).eInverseRemove(this, ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS, SimpleSearchQuery.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERATOR:
				return getOperator();
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND:
				return getOperand();
			case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
				return getSearchQuery();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERATOR:
				setOperator((OrderByOperators)newValue);
				return;
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND:
				setOperand((LeftOperand)newValue);
				return;
			case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
				setSearchQuery((SimpleSearchQuery)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERATOR:
				setOperator(OPERATOR_EDEFAULT);
				return;
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND:
				setOperand((LeftOperand)null);
				return;
			case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
				setSearchQuery((SimpleSearchQuery)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERATOR:
				return operator != OPERATOR_EDEFAULT;
			case ExtensionsPackage.ORDER_BY_ELEMENT__OPERAND:
				return operand != null;
			case ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY:
				return getSearchQuery() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (operator: ");
		result.append(operator);
		result.append(')');
		return result.toString();
	}

} //OrderByElementImpl
