/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: QueryImpl.java,v 1.7 2004/11/29 21:08:05 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.LeftOperand;
import org.eclipse.hyades.models.hierarchy.extensions.Query;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Query</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#getSources <em>Sources</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#isDistinct <em>Distinct</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#isCount <em>Count</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#getOutputElements <em>Output Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.QueryImpl#getSubQuery <em>Sub Query</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class QueryImpl extends EObjectImpl implements Query {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSources() <em>Sources</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSources()
	 * @generated
	 * @ordered
	 */
	protected EList sources = null;

	/**
	 * The default value of the '{@link #isDistinct() <em>Distinct</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDistinct()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DISTINCT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDistinct() <em>Distinct</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDistinct()
	 * @generated
	 * @ordered
	 */
	protected boolean distinct = DISTINCT_EDEFAULT;

	/**
	 * The default value of the '{@link #isCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isCount()
	 * @generated
	 * @ordered
	 */
	protected static final boolean COUNT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isCount()
	 * @generated
	 * @ordered
	 */
	protected boolean count = COUNT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOutputElements() <em>Output Elements</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutputElements()
	 * @generated
	 * @ordered
	 */
	protected EList outputElements = null;

	/**
	 * The cached value of the '{@link #getSubQuery() <em>Sub Query</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubQuery()
	 * @generated
	 * @ordered
	 */
	protected EList subQuery = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ExtensionsPackage.eINSTANCE.getQuery();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.QUERY__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSources() {
		if (sources == null) {
			sources = new EDataTypeUniqueEList(String.class, this, ExtensionsPackage.QUERY__SOURCES);
		}
		return sources;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isDistinct() {
		return distinct;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDistinct(boolean newDistinct) {
		boolean oldDistinct = distinct;
		distinct = newDistinct;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.QUERY__DISTINCT, oldDistinct, distinct));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isCount() {
		return count;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCount(boolean newCount) {
		boolean oldCount = count;
		count = newCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.QUERY__COUNT, oldCount, count));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOutputElements() {
		if (outputElements == null) {
			outputElements = new EObjectContainmentWithInverseEList(LeftOperand.class, this, ExtensionsPackage.QUERY__OUTPUT_ELEMENTS, ExtensionsPackage.LEFT_OPERAND__QUERY);
		}
		return outputElements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSubQuery() {
		if (subQuery == null) {
			subQuery = new EObjectContainmentEList(Query.class, this, ExtensionsPackage.QUERY__SUB_QUERY);
		}
		return subQuery;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.QUERY__OUTPUT_ELEMENTS:
					return ((InternalEList)getOutputElements()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.QUERY__OUTPUT_ELEMENTS:
					return ((InternalEList)getOutputElements()).basicRemove(otherEnd, msgs);
				case ExtensionsPackage.QUERY__SUB_QUERY:
					return ((InternalEList)getSubQuery()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.QUERY__NAME:
				return getName();
			case ExtensionsPackage.QUERY__SOURCES:
				return getSources();
			case ExtensionsPackage.QUERY__DISTINCT:
				return isDistinct() ? Boolean.TRUE : Boolean.FALSE;
			case ExtensionsPackage.QUERY__COUNT:
				return isCount() ? Boolean.TRUE : Boolean.FALSE;
			case ExtensionsPackage.QUERY__OUTPUT_ELEMENTS:
				return getOutputElements();
			case ExtensionsPackage.QUERY__SUB_QUERY:
				return getSubQuery();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.QUERY__NAME:
				setName((String)newValue);
				return;
			case ExtensionsPackage.QUERY__SOURCES:
				getSources().clear();
				getSources().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.QUERY__DISTINCT:
				setDistinct(((Boolean)newValue).booleanValue());
				return;
			case ExtensionsPackage.QUERY__COUNT:
				setCount(((Boolean)newValue).booleanValue());
				return;
			case ExtensionsPackage.QUERY__OUTPUT_ELEMENTS:
				getOutputElements().clear();
				getOutputElements().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.QUERY__SUB_QUERY:
				getSubQuery().clear();
				getSubQuery().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.QUERY__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ExtensionsPackage.QUERY__SOURCES:
				getSources().clear();
				return;
			case ExtensionsPackage.QUERY__DISTINCT:
				setDistinct(DISTINCT_EDEFAULT);
				return;
			case ExtensionsPackage.QUERY__COUNT:
				setCount(COUNT_EDEFAULT);
				return;
			case ExtensionsPackage.QUERY__OUTPUT_ELEMENTS:
				getOutputElements().clear();
				return;
			case ExtensionsPackage.QUERY__SUB_QUERY:
				getSubQuery().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.QUERY__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ExtensionsPackage.QUERY__SOURCES:
				return sources != null && !sources.isEmpty();
			case ExtensionsPackage.QUERY__DISTINCT:
				return distinct != DISTINCT_EDEFAULT;
			case ExtensionsPackage.QUERY__COUNT:
				return count != COUNT_EDEFAULT;
			case ExtensionsPackage.QUERY__OUTPUT_ELEMENTS:
				return outputElements != null && !outputElements.isEmpty();
			case ExtensionsPackage.QUERY__SUB_QUERY:
				return subQuery != null && !subQuery.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", sources: ");
		result.append(sources);
		result.append(", distinct: ");
		result.append(distinct);
		result.append(", count: ");
		result.append(count);
		result.append(')');
		return result.toString();
	}

} //QueryImpl
