/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: SimpleSearchQueryImpl.java,v 1.7 2004/11/29 21:08:05 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Simple Search Query</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl#getMaxElements <em>Max Elements</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl#getOrderByExpresions <em>Order By Expresions</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.SimpleSearchQueryImpl#getWhereExpressions <em>Where Expressions</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SimpleSearchQueryImpl extends QueryImpl implements SimpleSearchQuery {
	/**
	 * The default value of the '{@link #getMaxElements() <em>Max Elements</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxElements()
	 * @generated
	 * @ordered
	 */
	protected static final int MAX_ELEMENTS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getMaxElements() <em>Max Elements</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxElements()
	 * @generated
	 * @ordered
	 */
	protected int maxElements = MAX_ELEMENTS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOrderByExpresions() <em>Order By Expresions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOrderByExpresions()
	 * @generated
	 * @ordered
	 */
	protected EList orderByExpresions = null;

	/**
	 * The cached value of the '{@link #getWhereExpressions() <em>Where Expressions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWhereExpressions()
	 * @generated
	 * @ordered
	 */
	protected EList whereExpressions = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SimpleSearchQueryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ExtensionsPackage.eINSTANCE.getSimpleSearchQuery();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getMaxElements() {
		return maxElements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMaxElements(int newMaxElements) {
		int oldMaxElements = maxElements;
		maxElements = newMaxElements;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.SIMPLE_SEARCH_QUERY__MAX_ELEMENTS, oldMaxElements, maxElements));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getOrderByExpresions() {
		if (orderByExpresions == null) {
			orderByExpresions = new EObjectContainmentWithInverseEList(OrderByElement.class, this, ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS, ExtensionsPackage.ORDER_BY_ELEMENT__SEARCH_QUERY);
		}
		return orderByExpresions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getWhereExpressions() {
		if (whereExpressions == null) {
			whereExpressions = new EObjectContainmentWithInverseEList(SimpleBinaryExpression.class, this, ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSIONS, ExtensionsPackage.SIMPLE_BINARY_EXPRESSION__SEARCH_QUERY);
		}
		return whereExpressions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.SIMPLE_SEARCH_QUERY__OUTPUT_ELEMENTS:
					return ((InternalEList)getOutputElements()).basicAdd(otherEnd, msgs);
				case ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS:
					return ((InternalEList)getOrderByExpresions()).basicAdd(otherEnd, msgs);
				case ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSIONS:
					return ((InternalEList)getWhereExpressions()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.SIMPLE_SEARCH_QUERY__OUTPUT_ELEMENTS:
					return ((InternalEList)getOutputElements()).basicRemove(otherEnd, msgs);
				case ExtensionsPackage.SIMPLE_SEARCH_QUERY__SUB_QUERY:
					return ((InternalEList)getSubQuery()).basicRemove(otherEnd, msgs);
				case ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS:
					return ((InternalEList)getOrderByExpresions()).basicRemove(otherEnd, msgs);
				case ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSIONS:
					return ((InternalEList)getWhereExpressions()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__NAME:
				return getName();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__SOURCES:
				return getSources();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__DISTINCT:
				return isDistinct() ? Boolean.TRUE : Boolean.FALSE;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__COUNT:
				return isCount() ? Boolean.TRUE : Boolean.FALSE;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__OUTPUT_ELEMENTS:
				return getOutputElements();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__SUB_QUERY:
				return getSubQuery();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__MAX_ELEMENTS:
				return new Integer(getMaxElements());
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS:
				return getOrderByExpresions();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSIONS:
				return getWhereExpressions();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__NAME:
				setName((String)newValue);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__SOURCES:
				getSources().clear();
				getSources().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__DISTINCT:
				setDistinct(((Boolean)newValue).booleanValue());
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__COUNT:
				setCount(((Boolean)newValue).booleanValue());
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__OUTPUT_ELEMENTS:
				getOutputElements().clear();
				getOutputElements().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__SUB_QUERY:
				getSubQuery().clear();
				getSubQuery().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__MAX_ELEMENTS:
				setMaxElements(((Integer)newValue).intValue());
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS:
				getOrderByExpresions().clear();
				getOrderByExpresions().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSIONS:
				getWhereExpressions().clear();
				getWhereExpressions().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__SOURCES:
				getSources().clear();
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__DISTINCT:
				setDistinct(DISTINCT_EDEFAULT);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__COUNT:
				setCount(COUNT_EDEFAULT);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__OUTPUT_ELEMENTS:
				getOutputElements().clear();
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__SUB_QUERY:
				getSubQuery().clear();
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__MAX_ELEMENTS:
				setMaxElements(MAX_ELEMENTS_EDEFAULT);
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS:
				getOrderByExpresions().clear();
				return;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSIONS:
				getWhereExpressions().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__SOURCES:
				return sources != null && !sources.isEmpty();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__DISTINCT:
				return distinct != DISTINCT_EDEFAULT;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__COUNT:
				return count != COUNT_EDEFAULT;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__OUTPUT_ELEMENTS:
				return outputElements != null && !outputElements.isEmpty();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__SUB_QUERY:
				return subQuery != null && !subQuery.isEmpty();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__MAX_ELEMENTS:
				return maxElements != MAX_ELEMENTS_EDEFAULT;
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__ORDER_BY_EXPRESIONS:
				return orderByExpresions != null && !orderByExpresions.isEmpty();
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY__WHERE_EXPRESSIONS:
				return whereExpressions != null && !whereExpressions.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (maxElements: ");
		result.append(maxElements);
		result.append(')');
		return result.toString();
	}

} //SimpleSearchQueryImpl
