/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ExtensionsSwitch.java,v 1.7 2004/11/29 21:08:05 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.util;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;
import org.eclipse.hyades.models.hierarchy.extensions.InstanceQuery;
import org.eclipse.hyades.models.hierarchy.extensions.LeftOperand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage
 * @generated
 */
public class ExtensionsSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static ExtensionsPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ExtensionsSwitch() {
		if (modelPackage == null) {
			modelPackage = ExtensionsPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch((EClass)eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case ExtensionsPackage.SIMPLE_SEARCH_QUERY: {
				SimpleSearchQuery simpleSearchQuery = (SimpleSearchQuery)theEObject;
				Object result = caseSimpleSearchQuery(simpleSearchQuery);
				if (result == null) result = caseQuery(simpleSearchQuery);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExtensionsPackage.INSTANCE_QUERY: {
				InstanceQuery instanceQuery = (InstanceQuery)theEObject;
				Object result = caseInstanceQuery(instanceQuery);
				if (result == null) result = caseQuery(instanceQuery);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExtensionsPackage.ORDER_BY_ELEMENT: {
				OrderByElement orderByElement = (OrderByElement)theEObject;
				Object result = caseOrderByElement(orderByElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExtensionsPackage.QUERY_RESULT: {
				QueryResult queryResult = (QueryResult)theEObject;
				Object result = caseQueryResult(queryResult);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExtensionsPackage.SIMPLE_BINARY_EXPRESSION: {
				SimpleBinaryExpression simpleBinaryExpression = (SimpleBinaryExpression)theEObject;
				Object result = caseSimpleBinaryExpression(simpleBinaryExpression);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExtensionsPackage.LEFT_OPERAND: {
				LeftOperand leftOperand = (LeftOperand)theEObject;
				Object result = caseLeftOperand(leftOperand);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExtensionsPackage.RESULT_ENTRY: {
				ResultEntry resultEntry = (ResultEntry)theEObject;
				Object result = caseResultEntry(resultEntry);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ExtensionsPackage.TIME_BASED_CORRELATION_QUERY: {
				TimeBasedCorrelationQuery timeBasedCorrelationQuery = (TimeBasedCorrelationQuery)theEObject;
				Object result = caseTimeBasedCorrelationQuery(timeBasedCorrelationQuery);
				if (result == null) result = caseCorrelationQuery(timeBasedCorrelationQuery);
				if (result == null) result = caseSimpleSearchQuery(timeBasedCorrelationQuery);
				if (result == null) result = caseQuery(timeBasedCorrelationQuery);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Query</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Query</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseQuery(Query object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Simple Search Query</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Simple Search Query</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSimpleSearchQuery(SimpleSearchQuery object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Instance Query</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Instance Query</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseInstanceQuery(InstanceQuery object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Order By Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Order By Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseOrderByElement(OrderByElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Query Result</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Query Result</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseQueryResult(QueryResult object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Simple Binary Expression</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Simple Binary Expression</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseSimpleBinaryExpression(SimpleBinaryExpression object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Left Operand</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Left Operand</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseLeftOperand(LeftOperand object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Result Entry</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Result Entry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseResultEntry(ResultEntry object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Correlation Query</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Correlation Query</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCorrelationQuery(CorrelationQuery object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Time Based Correlation Query</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Time Based Correlation Query</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTimeBasedCorrelationQuery(TimeBasedCorrelationQuery object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //ExtensionsSwitch
