/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: HierarchyFactoryImpl.java,v 1.19 2004/11/29 21:08:05 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCExecParameter;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class HierarchyFactoryImpl extends EFactoryImpl implements HierarchyFactory {
	/**
	 * Creates and instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HierarchyFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case HierarchyPackage.TRC_PROCESS_PROXY: return createTRCProcessProxy();
			case HierarchyPackage.TRC_OPTION: return createTRCOption();
			case HierarchyPackage.TRC_AGENT: return createTRCAgent();
			case HierarchyPackage.TRC_AGENT_PROXY: return createTRCAgentProxy();
			case HierarchyPackage.TRC_CONFIGURATION: return createTRCConfiguration();
			case HierarchyPackage.TRC_ENVIRONMENT_VARIABLE: return createTRCEnvironmentVariable();
			case HierarchyPackage.TRC_EXEC_PARAMETER: return createTRCExecParameter();
			case HierarchyPackage.TRC_FILTER: return createTRCFilter();
			case HierarchyPackage.TRC_NODE: return createTRCNode();
			case HierarchyPackage.TRC_MONITOR: return createTRCMonitor();
			case HierarchyPackage.UNRESOLVED_CORRELATION: return createUnresolvedCorrelation();
			case HierarchyPackage.CORRELATION_SOURCE_INFO: return createCorrelationSourceInfo();
			case HierarchyPackage.CORRELATION_CONTAINER: return createCorrelationContainer();
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY: return createCorrelationContainerProxy();
			case HierarchyPackage.CORRELATION_ENTRY: return (EObject)createCorrelationEntry();
			case HierarchyPackage.CORRELATION_ENGINE: return createCorrelationEngine();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case HierarchyPackage.TRC_COLLECTION_MODE: {
				TRCCollectionMode result = TRCCollectionMode.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case HierarchyPackage.BOOLEAN_ARRAY:
				return createBooleanArrayFromString(eDataType, initialValue);
			case HierarchyPackage.INT_ARRAY:
				return createIntArrayFromString(eDataType, initialValue);
			case HierarchyPackage.DOUBLE_ARRAY:
				return createDoubleArrayFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case HierarchyPackage.TRC_COLLECTION_MODE:
				return instanceValue == null ? null : instanceValue.toString();
			case HierarchyPackage.BOOLEAN_ARRAY:
				return convertBooleanArrayToString(eDataType, instanceValue);
			case HierarchyPackage.INT_ARRAY:
				return convertIntArrayToString(eDataType, instanceValue);
			case HierarchyPackage.DOUBLE_ARRAY:
				return convertDoubleArrayToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcessProxy createTRCProcessProxy() {
		TRCProcessProxyImpl trcProcessProxy = new TRCProcessProxyImpl();
		return trcProcessProxy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCOption createTRCOption() {
		TRCOptionImpl trcOption = new TRCOptionImpl();
		return trcOption;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAgent createTRCAgent() {
		TRCAgentImpl trcAgent = new TRCAgentImpl();
		return trcAgent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAgentProxy createTRCAgentProxy() {
		TRCAgentProxyImpl trcAgentProxy = new TRCAgentProxyImpl();
		return trcAgentProxy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCConfiguration createTRCConfiguration() {
		TRCConfigurationImpl trcConfiguration = new TRCConfigurationImpl();
		return trcConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCEnvironmentVariable createTRCEnvironmentVariable() {
		TRCEnvironmentVariableImpl trcEnvironmentVariable = new TRCEnvironmentVariableImpl();
		return trcEnvironmentVariable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCExecParameter createTRCExecParameter() {
		TRCExecParameterImpl trcExecParameter = new TRCExecParameterImpl();
		return trcExecParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCFilter createTRCFilter() {
		TRCFilterImpl trcFilter = new TRCFilterImpl();
		return trcFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCNode createTRCNode() {
		TRCNodeImpl trcNode = new TRCNodeImpl();
		return trcNode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMonitor createTRCMonitor() {
		TRCMonitorImpl trcMonitor = new TRCMonitorImpl();
		return trcMonitor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnresolvedCorrelation createUnresolvedCorrelation() {
		UnresolvedCorrelationImpl unresolvedCorrelation = new UnresolvedCorrelationImpl();
		return unresolvedCorrelation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationSourceInfo createCorrelationSourceInfo() {
		CorrelationSourceInfoImpl correlationSourceInfo = new CorrelationSourceInfoImpl();
		return correlationSourceInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationContainer createCorrelationContainer() {
		CorrelationContainerImpl correlationContainer = new CorrelationContainerImpl();
		return correlationContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationContainerProxy createCorrelationContainerProxy() {
		CorrelationContainerProxyImpl correlationContainerProxy = new CorrelationContainerProxyImpl();
		return correlationContainerProxy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Map.Entry createCorrelationEntry() {
		CorrelationEntryImpl correlationEntry = new CorrelationEntryImpl();
		return correlationEntry;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationEngine createCorrelationEngine() {
		CorrelationEngineImpl correlationEngine = new CorrelationEngineImpl();
		return correlationEngine;
	}

	/**
	 * <!-- begin-user-doc -->
	 * Strings containing only upper case letters can code boolean arrays if 4 boolean values are stored
	 * in one upper case letter in the range 'A' (for {F,F,F,F}) to 'P' (for {T,T,T,T})<br>
	 * Why only upper case letters? Because they are consecutive and can be passed in an xml stream
	 * without any modification.<br>
	 * Hexa character range from '0'..'9' and 'A' to 'F' are not consecutive.<br>
	 * The length of the array is computed thanks to the first digit of the string that contains the number
	 * of padding booleans (the number of useless booleans in the last upper case digit): '1' to '3';
	 * an upper case letter at first position in the string means no padding.<br> 
	 * See convertBooleanArrayToString for the reverse conversion
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean[] createBooleanArrayFromString(EDataType eDataType, String initialValue) {
		int s = 0, padding = 0;
		if (Character.isDigit(initialValue.charAt(0))) {
			padding = initialValue.charAt(0) - '0';
			if (padding < 0 || padding > 3) {
				throw new UnsupportedOperationException("Bad padding at the begining of the string");
			}
			s = 1;
		}
		boolean ret[] = new boolean[(initialValue.length()-s)*4 - padding];
		int i, j;
		for (i = s, j = 0; i < initialValue.length()-s; i++, j += 4) {
			int hexaDigit = (initialValue.charAt(i) - 'A');
			if (hexaDigit < 0 || hexaDigit > 15) {
				throw new UnsupportedOperationException("Bad character in the string: "+initialValue.charAt(i/4));
			}
			ret[j]   = (hexaDigit & 8) != 0; // left most bit is for the lower range
			ret[j+1] = (hexaDigit & 4) != 0;
			ret[j+2] = (hexaDigit & 2) != 0;
			ret[j+3] = (hexaDigit & 1) != 0; // right most bit is for the highest range
		}
		if (padding > 0) {
			int hexaDigit = (initialValue.charAt(i) - 'A');
			if (hexaDigit < 0 || hexaDigit > 15) {
				throw new UnsupportedOperationException("Bad character in the string: "+initialValue.charAt(i/4));
			}
			for (j = 4-padding; j > 0; j--) {
				ret[ret.length-j] = (hexaDigit & 8) != 0;
				hexaDigit *= 2;
			}
		}
		return ret;
	}

	/**
	 * <!-- begin-user-doc -->
	 * See createBooleanArrayFromString for the reverse conversion and explanations.
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String convertBooleanArrayToString(EDataType eDataType, Object instanceValue) {
		String ret = "";
		boolean input[];
		try {
			input = (boolean [])instanceValue;
		} catch (ClassCastException e) {
			throw new UnsupportedOperationException("instanceValue must be of boolean[] type");
		}
		int padding = 4 - input.length % 4;
		if (padding != 4) {
			ret += (char)('0' + padding);
		}
		for (int i = 0; i < input.length - (4-padding); i += 4) {
			int hexaDigit = (input[i]   ? 8 : 0) + // left most bit is for the lower range
							(input[i+1] ? 4 : 0) +
							(input[i+2] ? 2 : 0) +
							(input[i+3] ? 1 : 0);  // right most bit is for the highest range
			ret += (char)('A' + hexaDigit);
		}
		if (padding < 4) {
			int hexaDigit = 0;
			switch (padding) {
				case 1:
					hexaDigit += input[input.length+padding-2] ? 2 : 0;
				case 2:
					hexaDigit += input[input.length+padding-3] ? 4 : 0;
				case 3:
					hexaDigit += input[input.length+padding-4] ? 8 : 0;
			}
			ret += (char)('A' + hexaDigit);
		}
		return ret;
	}
	
//	public static void main(String args[]) {
//		testIt("3PI");
//		testIt("AB");
//		testIt("2ABCDEFGHIJKLMNOM");
//		testIt("1PPPK");
//		testIt("1PPPM");
//	}
//
//	private static String dumpB(boolean[] b) {
//		String ret = "";
//		for (int i = 0; i < b.length; i++) {
//			ret += (b[i] ? "T" : "F");
//			if (i % 4 == 3 && i < b.length-1) {
//				ret += " ";
//			}
//		}
//		return ret;
//	}
//	private static void testIt(String s) {
//		EDataType e = null;
//		HierarchyFactoryImpl f = new HierarchyFactoryImpl();
//		boolean b[] = f.createBooleanArrayFromString(e, s);
//		System.err.println(s + " " + dumpB(b) + " " + f.convertBooleanArrayToString(e, b));
//	}
//
	/**
	 * <!-- begin-user-doc -->
	 * Each int data from the table is to be translated as quickly as possible in an 8-hexadecimal-digits string.<br>
	 * Hexa digits are from 'A' to 'P', because these upper case letters are consecutive.
	 * They can also be streamed in xml without any modifications.<br>
	 * There is a direct relationship between the sizes of the table and of the string -> x8<br>
	 * See convertIntArrayToString for the reverse conversion.
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public int[] createIntArrayFromString(EDataType eDataType, String initialValue) {
		int length = initialValue.length() / 8;
		if (initialValue.length() % 8 != 0) {
			throw new UnsupportedOperationException("initialValue must be made of 8 digits for each item");
		}
		if (length < 1) {
			return null;
		}
		int ret[] = new int[length];
		for (int i = 0; i < initialValue.length(); i += 8) {
			for (int j = 0, d = 28; j < 8; j++, d -= 4) {
				ret[i/8] += ((initialValue.charAt(i+j) - 'A') << d);
			}
		}
		return ret;
	}

	/**
	 * <!-- begin-user-doc -->
	 * See createIntArrayFromString for the reverse conversion and explanations.
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String convertIntArrayToString(EDataType eDataType, Object instanceValue) {
		String ret = "";
		int input[];
		try {
			input = (int [])instanceValue;
		} catch (ClassCastException e) {
			throw new UnsupportedOperationException("instanceValue must be of int[] type");
		}
		for (int i = 0; i < input.length; i++) {
			int value = input[i];
			for (int j = 0; j < 8; j++) {
				ret += (char)('A' + (((value & 0x70000000) >> 28) | (value < 0 ? 0x8 : 0x0)));
				value = (value & 0x0fffffff) << 4;
			}
		}
		return ret;
	}

	/**
	 * <!-- begin-user-doc -->
	 * Here is the converter for a string containing an array of doubles.<br>
	 * The string starts with the hexa value of the number of items in the array, then a # sign.<br>
	 * All values are encoded as hexa values of long bits corresponding to this double value.
	 * Separator between values is a : sign.<br> 
	 * Here is an example:<br>
	 * <code>{ 3.1415926, 0.0, -1.0 }</code>
	 * is represented by the string
	 * <code>3#400921fb4d12d84a:0:-4010000000000000</code>
	 * See createDoubleArrayFromString for the reverse conversion
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public double[] createDoubleArrayFromString(EDataType eDataType, String initialValue) {
		double ret[] = null;
		int index = 0, start;
		for (index = 0; index < initialValue.length() && initialValue.charAt(index) != '#'; index++ );
		int length = Integer.parseInt(initialValue.substring(0, index), 16);
		ret = new double[length];
		start = index+1;
		for (int i = 0; i < length; i++) {
			for (index++; index < initialValue.length() && initialValue.charAt(index) != ':'; index++);
			if (index == start) {
				continue;
			}
			try {
				ret[i] = Double.longBitsToDouble(Long.parseLong(initialValue.substring(start, index), 16));
			} catch (NumberFormatException e) {
				throw new UnsupportedOperationException("String "+initialValue.substring(start, index)+" is not a long");
			}
			start = index+1;
		}
		return ret;
	}

	/**
	 * <!-- begin-user-doc -->
	 * See convertDoubleArrayToString for the reverse conversion and explanations.
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String convertDoubleArrayToString(EDataType eDataType, Object instanceValue) {
		StringBuffer ret = new StringBuffer();
		double input[];
		try {
			input = (double [])instanceValue;
		} catch (ClassCastException e) {
			throw new UnsupportedOperationException("instanceValue must be of double[] type");
		}
		ret.append(Integer.toHexString(input.length));
		String prefix = "#";
		String sign = "";
		for (int i = 0; i < input.length; i++) {
			long longBits = Double.doubleToRawLongBits(input[i]);
			if (longBits < 0) {
				sign = "-";
				longBits = -longBits;
			} else {
				sign = "";
			}
			ret.append(prefix + sign + Long.toHexString(longBits));
			prefix = ":";
		}
		return ret.toString();
	}
	
//	public static void main(String args[]) {
//		testIt(new double[] { 2.7 });
//		testIt(new double[] { });
//		testIt(new double[] { 3.1415926, 0, -1 });
//		bigTestIt(20000);
//		bigTestIt(40000);
//		bigTestIt(60000);
//		bigTestIt(80000);
//	}
//	private static void bigTestIt(int size) {
//		double big[] = new double[size];
//		for (int i = 0; i < big.length; i++) {
//			big[i] = Math.exp(Math.cos((double)i))/1000;
//		}
//		testIt(big);
//	}
//	private static String dumpB(double[] b) {
//		String ret = "";
//		for (int i = 0; i < b.length; i++) {
//			ret += Double.toString(b[i]);
//			if (i < b.length-1) {
//				ret += " ";
//			}
//		}
//		return ret;
//	}
//	private static void testIt(double b[]) {
//		EDataType e = null;
//		HierarchyFactoryImpl f = new HierarchyFactoryImpl();
//		System.err.println("-> Restart chrono");
//		long start = System.currentTimeMillis();
//		String s = f.convertDoubleArrayToString(e, b);
//		long duration1 = System.currentTimeMillis()-start;
//		System.err.println("decoding -> "+duration1+"ms"+(duration1>0 ? " "+b.length*1000/duration1+"/s" : ""));
//		start = System.currentTimeMillis();
//		double c[] = f.createDoubleArrayFromString(e, s);
//		long duration2 = System.currentTimeMillis()-start;
//		System.err.println("encoding -> "+duration2+"ms"+(duration2>0 ? " "+b.length*1000/duration2+"/s" : ""));
//		long durationTotal = duration1+duration2;
//		System.err.println("total -> "+durationTotal+"ms"+(durationTotal>0 ? " "+b.length*1000/durationTotal+"/s" : ""));
//		if (b.length != c.length) {
//			System.err.println("Bad conversion lengths: "+b.length+" "+c.length);
//		}
//		for (int i = 0; i < b.length; i++) {
//			if (b[i] != c[i]) {
//				System.err.println("Bad conversion: "+b[i]+" "+c[i]);
//			}
//		}
//		if (b.length < 20) {
//			System.err.println(dumpB(b) + " " + s + " " + dumpB(c));
//		}
//	}

//	public static void main(String args[]) {
//		testIt("AAAAAAAA");
//		testIt("PPPPAAAA");
//		testIt("AAAAPPPP");
//		testIt("PPPPPPPP");
//		testIt("IAAAAAAA");
//		testIt("HPPPPPPP");
//		testIt("AAAAAAAAPPPPAAAAAAAAPPPPPPPPPPPPIAAAAAAAHPPPPPPPHPPPPPPP");
//		HierarchyFactoryImpl f = new HierarchyFactoryImpl();
//	}
//
//	private static String dumpB(int[] i_) {
//		String ret = "";
//		for (int i = 0; i < i_.length; i++) {
//			ret += Integer.toString(i_[i], 16);
//			if (i < i_.length-1) {
//				ret += " ";
//			}
//		}
//		return ret;
//	}
//	private static void testIt(String s) {
//		EDataType e = null;
//		HierarchyFactoryImpl f = new HierarchyFactoryImpl();
//		int i[] = f.createIntArrayFromString(e, s);
//		System.err.println(s + " " + dumpB(i) + " " + f.convertIntArrayToString(e, i));
//	}
//
									/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->

	 * @generated
	 */
	public HierarchyPackage getHierarchyPackage() {
		return (HierarchyPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static HierarchyPackage getPackage() {
		return HierarchyPackage.eINSTANCE;
	}

} //HierarchyFactoryImpl
