/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: HierarchyAdapterFactory.java,v 1.13 2004/11/29 21:08:05 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.util;

import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent;
import org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary;
import org.eclipse.hyades.models.hierarchy.AbstractTRCDescription;
import org.eclipse.hyades.models.hierarchy.AbstractTRCProcess;
import org.eclipse.hyades.models.hierarchy.AbstractTRCView;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCExecParameter;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage
 * @generated
 */
public class HierarchyAdapterFactory extends AdapterFactoryImpl
{
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static HierarchyPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HierarchyAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = HierarchyPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch the delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HierarchySwitch modelSwitch =
		new HierarchySwitch() {
			public Object caseTRCProcessProxy(TRCProcessProxy object) {
				return createTRCProcessProxyAdapter();
			}
			public Object caseTRCOption(TRCOption object) {
				return createTRCOptionAdapter();
			}
			public Object caseTRCAgent(TRCAgent object) {
				return createTRCAgentAdapter();
			}
			public Object caseTRCAgentProxy(TRCAgentProxy object) {
				return createTRCAgentProxyAdapter();
			}
			public Object caseTRCConfiguration(TRCConfiguration object) {
				return createTRCConfigurationAdapter();
			}
			public Object caseTRCEnvironmentVariable(TRCEnvironmentVariable object) {
				return createTRCEnvironmentVariableAdapter();
			}
			public Object caseTRCExecParameter(TRCExecParameter object) {
				return createTRCExecParameterAdapter();
			}
			public Object caseTRCFilter(TRCFilter object) {
				return createTRCFilterAdapter();
			}
			public Object caseTRCNode(TRCNode object) {
				return createTRCNodeAdapter();
			}
			public Object caseTRCMonitor(TRCMonitor object) {
				return createTRCMonitorAdapter();
			}
			public Object caseAbstractDefaultEvent(AbstractDefaultEvent object) {
				return createAbstractDefaultEventAdapter();
			}
			public Object caseAbstractTRCView(AbstractTRCView object) {
				return createAbstractTRCViewAdapter();
			}
			public Object caseAbstractTRCDescription(AbstractTRCDescription object) {
				return createAbstractTRCDescriptionAdapter();
			}
			public Object caseAbstractTRCProcess(AbstractTRCProcess object) {
				return createAbstractTRCProcessAdapter();
			}
			public Object caseAbstractTRCCollectionBoundary(AbstractTRCCollectionBoundary object) {
				return createAbstractTRCCollectionBoundaryAdapter();
			}
			public Object caseUnresolvedCorrelation(UnresolvedCorrelation object) {
				return createUnresolvedCorrelationAdapter();
			}
			public Object caseCorrelationSourceInfo(CorrelationSourceInfo object) {
				return createCorrelationSourceInfoAdapter();
			}
			public Object caseCorrelationContainer(CorrelationContainer object) {
				return createCorrelationContainerAdapter();
			}
			public Object caseCorrelationContainerProxy(CorrelationContainerProxy object) {
				return createCorrelationContainerProxyAdapter();
			}
			public Object caseCorrelationEntry(Map.Entry object) {
				return createCorrelationEntryAdapter();
			}
			public Object caseCorrelationEngine(CorrelationEngine object) {
				return createCorrelationEngineAdapter();
			}
			public Object defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	public Adapter createAdapter(Notifier target) {
		return (Adapter)modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy <em>TRC Process Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy
	 * @generated
	 */
	public Adapter createTRCProcessProxyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.TRCOption <em>TRC Option</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.TRCOption
	 * @generated
	 */
	public Adapter createTRCOptionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.TRCAgent <em>TRC Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent
	 * @generated
	 */
	public Adapter createTRCAgentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy <em>TRC Agent Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy
	 * @generated
	 */
	public Adapter createTRCAgentProxyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration <em>TRC Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.TRCConfiguration
	 * @generated
	 */
	public Adapter createTRCConfigurationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable <em>TRC Environment Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable
	 * @generated
	 */
	public Adapter createTRCEnvironmentVariableAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.TRCExecParameter <em>TRC Exec Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.TRCExecParameter
	 * @generated
	 */
	public Adapter createTRCExecParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.TRCFilter <em>TRC Filter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.TRCFilter
	 * @generated
	 */
	public Adapter createTRCFilterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.TRCNode <em>TRC Node</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.TRCNode
	 * @generated
	 */
	public Adapter createTRCNodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.TRCMonitor <em>TRC Monitor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.TRCMonitor
	 * @generated
	 */
	public Adapter createTRCMonitorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent <em>Abstract Default Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent
	 * @generated
	 */
	public Adapter createAbstractDefaultEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCView <em>Abstract TRC View</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCView
	 * @generated
	 */
	public Adapter createAbstractTRCViewAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCDescription <em>Abstract TRC Description</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCDescription
	 * @generated
	 */
	public Adapter createAbstractTRCDescriptionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCProcess <em>Abstract TRC Process</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCProcess
	 * @generated
	 */
	public Adapter createAbstractTRCProcessAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary <em>Abstract TRC Collection Boundary</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary
	 * @generated
	 */
	public Adapter createAbstractTRCCollectionBoundaryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation <em>Unresolved Correlation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation
	 * @generated
	 */
	public Adapter createUnresolvedCorrelationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo <em>Correlation Source Info</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo
	 * @generated
	 */
	public Adapter createCorrelationSourceInfoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.CorrelationContainer <em>Correlation Container</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.CorrelationContainer
	 * @generated
	 */
	public Adapter createCorrelationContainerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy <em>Correlation Container Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy
	 * @generated
	 */
	public Adapter createCorrelationContainerProxyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link java.util.Map.Entry <em>Correlation Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see java.util.Map.Entry
	 * @generated
	 */
	public Adapter createCorrelationEntryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.CorrelationEngine <em>Correlation Engine</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.CorrelationEngine
	 * @generated
	 */
	public Adapter createCorrelationEngineAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //HierarchyAdapterFactory
