/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.util.Collection;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;

/**
 * @author slavescu
 */
public interface IExtendedQueryService {
	QueryResult executeQuery(Query query,ResourceSet targetResourceSet, Collection notLoadedTypes);
	QueryResult executeQuery(String queryName,ResourceSet targetResourceSet, Collection notLoadedTypes);
	boolean validateQuery(Query query);
	boolean storeQuery(Query query);
}
