/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.common.internal.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;

public class RunDestinationPage 
extends WizardPage implements Listener
{
	private ResourceAndContainerGroup containerSelectionGroup;
	private IContainer initialContainer;
	
	public RunDestinationPage()
	{
		super("location");
		setTitle(TestUIPlugin.getString("RUN_WTITLE"));
		setDescription(TestUIPlugin.getString("RUN_LDESC"));
		
	}
	
	public void setInitialDestination(IContainer initialContainer)
	{
		this.initialContainer = initialContainer;
	}
	
	/*
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent)
	{
		
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		
		GridData data = GridDataUtil.createFill();
		data.heightHint = 300;
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(layout);
		composite.setLayoutData(GridDataUtil.createFill());

		containerSelectionGroup = new ResourceAndContainerGroup(composite, this, TestUIPlugin.getString("LOCATION_OUTPUT_LABEL"), "file", true, data.heightHint);
		containerSelectionGroup.setResource(((RunWizard)getWizard()).getExecutionResultInitialName());
		if(initialContainer != null)
			containerSelectionGroup.setContainerFullPath(initialContainer.getFullPath());
		
		
		setPageComplete(validatePage());
		
		setControl(composite);
		
		WorkbenchHelp.setHelp(composite, TestCommonPlugin.getID() + ContextIds.RUN_DEST_PAGE);				
		WorkbenchHelp.setHelp(composite, TestCommonPlugin.getID() + ContextIds.RUN_DEST_PAGE_TEXT);				
		
	}
	
	/*
	 * @see Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event)
	{
		setPageComplete(validatePage());
	}

    /**
     * 
     * @return execution result name
     */
	public String getExecutionResultName()
	{
		return containerSelectionGroup.getResource().trim();
	}
	
	/**
	 * 
	 * @return container path
	 */
	public IPath getContainerPath()
	{
		return 	containerSelectionGroup.getContainerFullPath();
	}

	protected boolean validatePage()
	{		
		IPath path = containerSelectionGroup.getContainerFullPath();
		if((path == null) || (path.segmentCount() == 0))
		{
			setErrorMessage(TestUIPlugin.getString("RUN_LOC_NOCONT"));
			return false;
		}
		
		if(ResourcesPlugin.getWorkspace().getRoot().findMember(path.segment(0)) == null)
		{
			setErrorMessage(TestUIPlugin.getString("RUN_LOC_NOCONT"));
			return false;
		}
		
		String name = getExecutionResultName();
		if(name.length() == 0)
		{
			setErrorMessage(TestUIPlugin.getString("RUN_LOC_EMPTY_NAME"));
			return false;
		}
		
		if((name.indexOf("\\") >=0) || (name.indexOf("/") >=0))
		{
			setErrorMessage(TestUIPlugin.getString("RUN_LOC_INVALID_NAME"));
			return false;
		}
			
	    setErrorMessage(null);
		return true;
	}
	
}