/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

/**
 * A profile event listener registers with the profile plug-in
 * to receive profile event notification from the application being profiled.
  * <p>
 * Clients may implement this interface.
 * </p> 
 */
public interface IProfileEventListener {
	/**
	 * Notifies this listener of the given profile event.
	 *
	 * @param event the profile event
	 */
	public void handleProfileEvent(ProfileEvent event);
}
